/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker.application;

import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.application.VanillaDockerApplication;
import brooklyn.entity.container.docker.application.VanillaDockerApplicationDriver;
import brooklyn.location.docker.DockerContainerLocation;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaDockerApplicationImpl
extends SoftwareProcessImpl
implements VanillaDockerApplication {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaDockerApplicationImpl.class);

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        super.connectSensors();
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    public void rebind() {
        super.rebind();
        this.disconnectSensors();
        this.connectSensors();
    }

    public Class<? extends VanillaDockerApplicationDriver> getDriverInterface() {
        return VanillaDockerApplicationDriver.class;
    }

    @Override
    public DockerContainer getDockerContainer() {
        DockerContainerLocation location = (DockerContainerLocation)((Object)Iterables.find((Iterable)this.getLocations(), (Predicate)Predicates.instanceOf(DockerContainerLocation.class)));
        return location.getOwner();
    }

    @Override
    public DockerHost getDockerHost() {
        return this.getDockerContainer().getDockerHost();
    }

    @Override
    public String getDockerfile() {
        return (String)this.config().get(DOCKERFILE_URL);
    }

    @Override
    public List<Integer> getContainerPorts() {
        return (List)this.config().get(DockerAttributes.DOCKER_OPEN_PORTS);
    }
}

