/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerHostDriver;
import brooklyn.entity.container.docker.DockerHostImpl;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.geo.LocalhostExternalIpLoader;
import brooklyn.location.jclouds.JcloudsMachineLocation;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.file.ArchiveUtils;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class DockerHostSshDriver
extends AbstractSoftwareProcessSshDriver
implements DockerHostDriver {
    public DockerHostSshDriver(DockerHostImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_SSL_PORT);
    }

    @Override
    public String buildImage(String dockerFile, String name) {
        if (!ArchiveUtils.ArchiveType.UNKNOWN.equals((Object)ArchiveUtils.ArchiveType.of((String)dockerFile)) || Urls.isDirectory((String)dockerFile)) {
            ArchiveUtils.deploy((String)dockerFile, (SshMachineLocation)this.getMachine(), (String)Os.mergePaths((String[])new String[]{this.getRunDir(), name}));
            String baseImageId = this.buildDockerfileDirectory(name);
            log.info("Created base Dockerfile image with ID {}", (Object)baseImageId);
        } else {
            ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{String.format("mkdir -p %s", Os.mergePaths((String[])new String[]{this.getRunDir(), name}))}).machine(this.getMachine())).newTask();
            DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this.getEntity()).orSubmitAndBlock();
            int result = (Integer)task.get();
            if (result != 0) {
                throw new IllegalStateException("Error creating image directory: " + name);
            }
            this.copyTemplate(dockerFile, Os.mergePaths((String[])new String[]{name, "BaseDockerfile"}), false, this.getExtraTemplateSubstitutions(name));
            String baseImageId = this.buildDockerfile("BaseDockerfile", name);
            log.info("Created base Dockerfile image with ID {}", (Object)baseImageId);
        }
        this.copyTemplate("classpath://brooklyn/entity/container/docker/SshdDockerfile", Os.mergePaths((String[])new String[]{name, "SshdDockerfile"}), false, this.getExtraTemplateSubstitutions(name));
        String sshdImageId = this.buildDockerfile("SshdDockerfile", name);
        log.info("Created SSHable Dockerfile image with ID {}", (Object)sshdImageId);
        return sshdImageId;
    }

    @Override
    public String layerSshableImageOn(String name, String tag) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)tag, (Object)"tag");
        this.copyTemplate("classpath://brooklyn/entity/container/docker/SshdDockerfile", Os.mergePaths((String[])new String[]{name, "SshdDockerfile"}), true, (Map)ImmutableMap.of((Object)"fullyQualifiedImageName", (Object)(name + ":" + tag)));
        String sshdImageId = this.buildDockerfile("SshdDockerfile", name);
        log.info("Created SSH-based image from {} with ID {}", (Object)name, (Object)sshdImageId);
        return sshdImageId;
    }

    private Map<String, Object> getExtraTemplateSubstitutions(String imageName) {
        MutableMap templateSubstitutions = MutableMap.of((Object)"fullyQualifiedImageName", (Object)imageName);
        DockerHost host = (DockerHost)this.getEntity();
        templateSubstitutions.putAll((Map)host.getInfrastructure().config().get(DockerInfrastructure.DOCKERFILE_SUBSTITUTIONS));
        return templateSubstitutions;
    }

    private String buildDockerfileDirectory(String name) {
        String build = String.format("build --rm -t %s %s", name, Os.mergePaths((String[])new String[]{this.getRunDir(), name}));
        String stdout = ((DockerHost)this.getEntity()).runDockerCommandTimeout(build, Duration.minutes((Number)20));
        String prefix = Strings.getFirstWordAfter((String)stdout, (String)"Successfully built");
        return this.getImageId(prefix, name);
    }

    private String buildDockerfile(String dockerfile, String name) {
        String build = String.format("build --rm -t %s - < %s", name, Os.mergePaths((String[])new String[]{this.getRunDir(), name, dockerfile}));
        String stdout = ((DockerHost)this.getEntity()).runDockerCommandTimeout(build, Duration.minutes((Number)20));
        String prefix = Strings.getFirstWordAfter((String)stdout, (String)"Successfully built");
        return this.getImageId(prefix, name);
    }

    private String getImageId(String prefix, String name) {
        String inspect = String.format("inspect --format={{.Id}} %s", prefix);
        String imageId = ((DockerHost)this.getEntity()).runDockerCommand(inspect);
        return DockerUtils.checkId(imageId);
    }

    public String getEpelRelease() {
        return (String)this.getEntity().config().get(DockerHost.EPEL_RELEASE);
    }

    public String getStorageOpts() {
        String driver = (String)this.getEntity().config().get(DockerHost.DOCKER_STORAGE_DRIVER);
        if (Strings.isBlank((CharSequence)driver)) {
            return "";
        }
        return "-s " + Strings.toLowerCase((String)driver);
    }

    @Override
    public String deployArchive(String url) {
        String volumeId = Identifiers.makeIdFromHash((long)url.hashCode());
        String path = Os.mergePaths((String[])new String[]{this.getRunDir(), volumeId});
        ArchiveUtils.deploy((String)url, (SshMachineLocation)this.getMachine(), (String)path);
        return path;
    }

    @Override
    public void configureSecurityGroups() {
        String securityGroup = (String)this.getEntity().config().get(DockerInfrastructure.SECURITY_GROUP);
        if (Strings.isBlank((CharSequence)securityGroup)) {
            if (!(this.getLocation() instanceof JcloudsSshMachineLocation)) {
                log.info("{} not running in a JcloudsSshMachineLocation, not configuring extra security groups", (Object)this.entity);
                return;
            }
            JcloudsMachineLocation location = (JcloudsMachineLocation)this.getLocation();
            JcloudsLocationSecurityGroupCustomizer customizer = JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getEntity().getApplicationId());
            Collection<IpPermission> permissions = this.getIpPermissions();
            log.debug("Applying custom security groups to {}: {}", (Object)location, permissions);
            customizer.addPermissionsToLocation(location, permissions);
        }
    }

    protected Collection<IpPermission> getIpPermissions() {
        String localhost = LocalhostExternalIpLoader.getLocalhostIpWithin((Duration)Duration.minutes((Number)1)) + "/32";
        IpPermission dockerPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).toPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).cidrBlock(localhost).build();
        IpPermission dockerSslPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).toPort(((Integer)this.getEntity().getAttribute((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).cidrBlock(localhost).build();
        IpPermission dockerPortForwarding = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(32768).toPort(65534).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        MutableList permissions = MutableList.of((Object)dockerPort, (Object)dockerSslPort, (Object[])new IpPermission[]{dockerPortForwarding});
        if (((Boolean)this.getEntity().config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            SdnProvider provider = (SdnProvider)((Entity)this.entity.getAttribute(DockerHost.DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.SDN_PROVIDER);
            Collection<IpPermission> sdnPermissions = provider.getIpPermissions(localhost);
            permissions.addAll(sdnPermissions);
        }
        return permissions;
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("docker-%s", this.getVersion()))}));
    }

    public void install() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String osVersion = osDetails.getVersion();
        String arch = osDetails.getArch();
        if (!osDetails.is64bit()) {
            throw new IllegalStateException("Docker supports only 64bit OS");
        }
        if (osDetails.isWindows()) {
            throw new IllegalStateException("Windows operating system not yet supported by Docker");
        }
        log.debug("Installing Docker on {} version {}", (Object)osDetails.getName(), (Object)osVersion);
        if (osDetails.isLinux()) {
            int present;
            String kernelVersion = Strings.getFirstWord((String)((DockerHost)this.getEntity()).execCommand("uname -r"));
            String storage = Strings.toLowerCase((String)((String)this.entity.config().get(DockerHost.DOCKER_STORAGE_DRIVER)));
            if (!"devicemapper".equals(storage) && (present = ((DockerHost)this.getEntity()).execCommandStatus("modprobe " + storage)) != 0) {
                MutableList commands = MutableList.of();
                if ("ubuntu".equalsIgnoreCase(osDetails.getName())) {
                    commands.add(BashCommands.installPackage((String)"software-properties-common"));
                    commands.add(BashCommands.sudo((String)"add-apt-repository -y ppa:canonical-kernel-team/ppa"));
                    commands.add("export UCF_FORCE_CONFFNEW=1");
                    if ("overlay".equals(storage) || "btrfs".equals(storage)) {
                        commands.add(BashCommands.installPackage((String)"linux-{image,headers,image-extra}-3.19.\\*-generic"));
                    } else if ("aufs".equals(storage) || Strings.isBlank((CharSequence)storage)) {
                        commands.add(BashCommands.installPackage((String)("linux-image-extra-" + kernelVersion)));
                    } else {
                        commands.add(BashCommands.installPackage((String)"linux-{image,headers,image-extra}-3.16.\\*-generic"));
                    }
                    this.executeKernelInstallation((List<String>)commands);
                }
                if ("centos".equalsIgnoreCase(osDetails.getName())) {
                    commands.add(BashCommands.sudo((String)"yum -y --nogpgcheck upgrade kernel"));
                    this.executeKernelInstallation((List<String>)commands);
                }
            }
        }
        ArrayList commands = Lists.newArrayList();
        if (osDetails.isMac()) {
            commands.add(BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)"boot2docker status || boot2docker init"), BashCommands.fail((String)"Mac OSX install requires Boot2Docker preinstalled", (int)1)}));
        }
        if (osDetails.isLinux()) {
            commands.add(BashCommands.INSTALL_CURL);
            if ("ubuntu".equalsIgnoreCase(osDetails.getName())) {
                commands.add(this.installDockerOnUbuntu());
            } else if ("centos".equalsIgnoreCase(osDetails.getName())) {
                commands.add(BashCommands.ifExecutableElse1((String)"yum", (String)this.useYum(osVersion, arch, this.getEpelRelease())));
                commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"docker-io"), null));
                commands.add(BashCommands.sudo((String)String.format("curl https://get.docker.com/builds/Linux/x86_64/docker-%s -o /usr/bin/docker", this.getVersion())));
            } else {
                commands.add(this.installDockerFallback());
            }
        }
        this.newScript((String)"installing").body.append((Collection)commands).failOnNonZeroResultCode().execute();
    }

    private void executeKernelInstallation(List<String> commands) {
        this.newScript((String)"installingkernel").body.append(commands).body.append((CharSequence)BashCommands.sudo((String)"reboot")).execute();
        Stopwatch stopwatchForReboot = Stopwatch.createStarted();
        Time.sleep((Duration)Duration.seconds((Number)30));
        Task sshable = TaskBuilder.builder().name("Waiting until host is SSHable").body((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Repeater.create().every(Duration.TEN_SECONDS).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return DockerHostSshDriver.this.getLocation().isSshable();
                    }
                }).limitTimeTo(Duration.minutes((Number)15)).run();
            }
        }).build();
        Boolean result = (Boolean)DynamicTasks.queueIfPossible((TaskAdaptable)sshable).orSubmitAndBlock().andWaitForSuccess();
        if (!result.booleanValue()) {
            throw new IllegalStateException(String.format("The entity %s is not sshable after reboot (waited %s)", this.entity, Time.makeTimeStringRounded((Stopwatch)stopwatchForReboot)));
        }
    }

    private String useYum(String osVersion, String arch, String epelRelease) {
        String osMajorVersion = osVersion.substring(0, osVersion.lastIndexOf("."));
        return BashCommands.chainGroup((String[])new String[]{BashCommands.alternatives((String[])new String[]{BashCommands.sudo((String)"rpm -qa | grep epel-release"), BashCommands.sudo((String)String.format("rpm -Uvh http://dl.fedoraproject.org/pub/epel/%s/%s/epel-release-%s.noarch.rpm", osMajorVersion, arch, epelRelease))})});
    }

    public String getVersion() {
        String version = super.getVersion();
        if (version.matches("^[0-9]+\\.[0-9]+$")) {
            version = version + ".0";
        }
        return version;
    }

    private String installDockerOnUbuntu() {
        String version = this.getVersion();
        log.debug("Installing Docker version {} on Ubuntu", (Object)version);
        return BashCommands.chainGroup((String[])new String[]{BashCommands.installPackage((String)"apt-transport-https"), "echo 'deb https://get.docker.com/ubuntu docker main' | " + BashCommands.sudo((String)"tee -a /etc/apt/sources.list.d/docker.list"), BashCommands.sudo((String)"apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 36A1D7869245C8950F966E92D8576A8BA88D21E9"), BashCommands.installPackage((String)("lxc-docker-" + version))});
    }

    private String installDockerFallback() {
        return "curl -s https://get.docker.com/ | " + BashCommands.sudo((String)"sh");
    }

    public void customize() {
        if (this.isRunning()) {
            log.info("Stopping running Docker instance at {} before customising", (Object)this.getMachine());
            this.stop();
        }
        this.newScript((String)"customizing").body.append(new CharSequence[]{BashCommands.ifExecutableElse0((String)"apt-get", (String)BashCommands.chainGroup((String[])new String[]{String.format("echo 'DOCKER_OPTS=\"-H tcp://0.0.0.0:%d -H unix:///var/run/docker.sock %s --tls --tlscert=%s/cert.pem --tlskey=%<s/key.pem\"' | ", this.getDockerPort(), this.getStorageOpts(), this.getRunDir()) + BashCommands.sudo((String)"tee -a /etc/default/docker"), BashCommands.sudo((String)"groupadd -f docker"), BashCommands.sudo((String)String.format("gpasswd -a %s docker", this.getMachine().getUser())), BashCommands.sudo((String)"newgrp docker")})), BashCommands.ifExecutableElse0((String)"yum", (String)(String.format("echo 'other_args=\"--selinux-enabled -H tcp://0.0.0.0:%d -H unix:///var/run/docker.sock -e lxc %s --tls --tlscert=%s/cert.pem --tlskey=%<s/key.pem\"' | ", this.getDockerPort(), this.getStorageOpts(), this.getRunDir()) + BashCommands.sudo((String)"tee -a /etc/sysconfig/docker")))}).failOnNonZeroResultCode().execute();
        MutableMap mapping = MutableMap.of();
        Map volumes = (Map)this.getEntity().config().get(DockerHost.DOCKER_HOST_VOLUME_MAPPING);
        if (volumes != null) {
            for (String source : volumes.keySet()) {
                if (Urls.isUrlWithProtocol((String)source)) {
                    String path = this.deployArchive(source);
                    mapping.put(path, volumes.get(source));
                    continue;
                }
                mapping.put(source, volumes.get(source));
            }
        }
        this.getEntity().setAttribute(DockerHost.DOCKER_HOST_VOLUME_MAPPING, (Object)mapping);
    }

    public boolean isRunning() {
        ScriptHelper helper = this.newScript((String)"check-running").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)"boot2docker status"), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker status"))})).noExtraOutput().gatherOutput();
        helper.execute();
        return helper.getResultStdout().contains("running");
    }

    public void stop() {
        this.newScript((String)"stopping").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)"boot2docker down"), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker stop"))})).failOnNonZeroResultCode().execute();
    }

    public void launch() {
        this.newScript((String)"launching").body.append((CharSequence)BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse1((String)"boot2docker", (String)"boot2docker up"), BashCommands.ifExecutableElse1((String)"service", (String)BashCommands.sudo((String)"service docker start"))})).failOnNonZeroResultCode().uniqueSshConnection().execute();
    }

    public Map<String, String> getShellEnvironment() {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(super.getShellEnvironment());
        if (this.getMachine().getMachineDetails().getOsDetails().isMac()) {
            builder.put((Object)"DOCKER_HOST", (Object)String.format("tcp://%s:%d", this.getSubnetAddress(), this.getDockerPort()));
        }
        return builder.build();
    }
}

