/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHostImpl;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.machine.MachineEntity;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.affinity.AffinityRules;
import brooklyn.location.dynamic.LocationOwner;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;

@ImplementedBy(value=DockerHostImpl.class)
public interface DockerHost
extends MachineEntity,
Resizable,
HasShortName,
LocationOwner<DockerHostLocation, DockerHost> {
    @SetFromFlag(value="dockerVersion")
    public static final ConfigKey<String> DOCKER_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.6.2");
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"https://get.docker.com/");
    @SetFromFlag(value="dockerPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.port", (String)"Docker port", (Object)PortRanges.fromInteger((int)2375));
    @SetFromFlag(value="dockerSslPort")
    public static final PortAttributeSensorAndConfigKey DOCKER_SSL_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"docker.ssl.port", (String)"Docker port", (Object)PortRanges.fromInteger((int)2376));
    @SetFromFlag(value="openIptables")
    public static final ConfigKey<Boolean> OPEN_IPTABLES = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)JcloudsLocationConfig.OPEN_IPTABLES);
    @SetFromFlag(value="containerSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec, EntitySpec> DOCKER_CONTAINER_SPEC = ConfigKeys.newSensorAndConfigKey(EntitySpec.class, (String)"docker.container.spec", (String)"Specification to use when creating child Docker container", (Object)EntitySpec.create(DockerContainer.class));
    @SetFromFlag(value="infrastructure")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = DockerAttributes.DOCKER_INFRASTRUCTURE;
    public static final ConfigKey<String> DOCKER_HOST_NAME_FORMAT = ConfigKeys.newStringConfigKey((String)"docker.host.nameFormat", (String)"Format for generating Docker host names", (String)"docker-host-brooklyn-%1$s");
    public static final ConfigKey<String> EPEL_RELEASE = ConfigKeys.newStringConfigKey((String)"docker.host.epel.release", (String)"EPEL release for yum based OS", (String)"6-8");
    public static final ConfigKey<String> DOCKER_STORAGE_DRIVER = ConfigKeys.newStringConfigKey((String)"docker.host.driver.storage", (String)"The Docker storage driver type ('devicemapper', 'btrfs', 'aufs' or 'overlay', null uses Docker default)");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID;
    public static final AttributeSensor<String> DOCKER_IMAGE_NAME = DockerAttributes.DOCKER_IMAGE_NAME;
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID;
    @SetFromFlag(value="volumeMappings")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = DockerAttributes.DOCKER_HOST_VOLUME_MAPPING;
    @SetFromFlag(value="password")
    public static final ConfigKey<String> DOCKER_PASSWORD = DockerAttributes.DOCKER_PASSWORD;
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<List<String>> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    public static final AttributeSensor<String> DOCKER_HOST_NAME = Sensors.newStringSensor((String)"docker.host.name", (String)"The name of the Docker host");
    @SetFromFlag(value="provisioningFlags")
    public static final ConfigKey<Map<String, Object>> PROVISIONING_FLAGS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"docker.host.flags", (String)"Provisioning flags for the Docker hosts", (Object)MutableMap.of());
    @SetFromFlag(value="scanInterval")
    public static final ConfigKey<Duration> SCAN_INTERVAL = ConfigKeys.newConfigKey(Duration.class, (String)"docker.host.scanInterval", (String)"Interval between scans of Docker containers", (Object)Duration.TEN_SECONDS);
    public static final AttributeSensor<Void> SCAN = Sensors.newSensor(Void.class, (String)"docker.host.scan", (String)"Notification of host scan");
    public static final AttributeSensor<DynamicCluster> DOCKER_CONTAINER_CLUSTER = Sensors.newSensor(DynamicCluster.class, (String)"docker.container.cluster", (String)"The cluster of Docker containers");
    public static final AttributeSensor<JcloudsLocation> JCLOUDS_DOCKER_LOCATION = Sensors.newSensor(JcloudsLocation.class, (String)"docker.jclouds.location", (String)"The location used for provisioning Docker containers");
    public static final AttributeSensor<SubnetTier> DOCKER_HOST_SUBNET_TIER = Sensors.newSensor(SubnetTier.class, (String)"docker.subnetTier", (String)"The SubnetTier for Docker port mapping");
    public static final MethodEffector<String> CREATE_SSHABLE_IMAGE = new MethodEffector(DockerHost.class, "createSshableImage");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND = new MethodEffector(DockerHost.class, "runDockerCommand");
    public static final MethodEffector<String> RUN_DOCKER_COMMAND_TIMEOUT = new MethodEffector(DockerHost.class, "runDockerCommandTimeout");
    public static final MethodEffector<String> DEPLOY_ARCHIVE = new MethodEffector(DockerHost.class, "deployArchive");

    public String getPassword();

    public Integer getDockerPort();

    public JcloudsLocation getJcloudsLocation();

    public SubnetTier getSubnetTier();

    public String getDockerHostName();

    public DynamicCluster getDockerContainerCluster();

    public List<Entity> getDockerContainerList();

    public DockerInfrastructure getInfrastructure();

    public int execCommandStatusTimeout(String var1, Duration var2);

    public int execCommandStatus(String var1);

    public Optional<String> getImageNamed(String var1);

    public Optional<String> getImageNamed(String var1, String var2);

    @Effector(description="Create an SSHable image and returns the image ID")
    public String createSshableImage(@EffectorParam(name="dockerFile", description="URL of Dockerfile to copy") String var1, @EffectorParam(name="name", description="Repository name") String var2);

    @Effector(description="Create an SSHable image based on the named image and return its ID")
    public String layerSshableImageOn(@EffectorParam(name="baseImage", description="The image's name") String var1, @EffectorParam(name="tag", description="The image's tag, e.g. latest") String var2);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommand(@EffectorParam(name="command", description="Docker command") String var1);

    @Effector(description="Execute a Docker command and return the output")
    public String runDockerCommandTimeout(@EffectorParam(name="command", description="Docker command") String var1, @EffectorParam(name="timeout", description="Timeout") Duration var2);

    @Effector(description="Upload an archive file to the host and expand it, for export to a container")
    public String deployArchive(@EffectorParam(name="url", description="Archive source URL") String var1);
}

