/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container;

import brooklyn.config.ConfigInheritance;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.docker.strategy.DockerAwarePlacementStrategy;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.javalang.Reflections;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DockerAttributes {
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.url", (String)"URL of a Dockerfile to use");
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.name", (String)"Name for the image created by the Dockerfile being used");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.id", (String)"The ID of a Docker image to use for a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_REPOSITORY = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.repository", (String)"The repository of the Docker image used by a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.name", (String)"The name of the Docker image used by a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_TAG = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.tag", (String)"The tag of the image to use", (String)"latest");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = ConfigKeys.newStringSensorAndConfigKey((String)"docker.hardwareId", (String)"The ID of a Docker hardware type to use for a container", (String)"small");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_CONTAINER_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"docker.container.name", (String)"The name of the Docker container");
    public static final ConfigKey<String> DOCKER_PASSWORD = ConfigKeys.newConfigKeyWithPrefix((String)"docker.", (ConfigKey)SshTool.PROP_PASSWORD);
    public static final ConfigKey<Boolean> DOCKER_USE_HOST_DNS_NAME = ConfigKeys.newBooleanConfigKey((String)"docker.useHostDnsName", (String)"Container uses same DNS hostname as Docker host", (Boolean)Boolean.TRUE);
    public static final ConfigKey<Integer> DOCKER_CPU_SHARES = ConfigKeys.newIntegerConfigKey((String)"docker.cpuShares", (String)"Container CPU shares configuration");
    public static final ConfigKey<Integer> DOCKER_MEMORY = ConfigKeys.newIntegerConfigKey((String)"docker.memory", (String)"Container memory configuration");
    public static final ConfigKey<Boolean> MANAGED = ConfigKeys.newBooleanConfigKey((String)"docker.container.managed", (String)"Set to false if the container is not managed by Brooklyn and Clocker", (Boolean)Boolean.TRUE);
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"docker.host.volumes", (String)"Host volume mapping configuration");
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.container.volumes", (String)"Container volume export configuration");
    public static final ConfigKey<List<DockerAwarePlacementStrategy>> PLACEMENT_STRATEGIES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<DockerAwarePlacementStrategy>>(){}, (String)"docker.container.strategies", (String)"Placement strategy list for Docker containers");
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = ConfigKeys.newSensorAndConfigKey(Entity.class, (String)"docker.infrastructure", (String)"The Docker infrastructure");
    public static final ConfigKey<List<PortAttributeSensorAndConfigKey>> DOCKER_DIRECT_PORT_CONFIG = ConfigKeys.builder((TypeToken)new TypeToken<List<PortAttributeSensorAndConfigKey>>(){}).name("docker.container.directPorts.configKeys").description("List of configration keys for ports that are to be mapped directly on the Docker host").inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<Integer>> DOCKER_DIRECT_PORTS = ConfigKeys.builder((TypeToken)new TypeToken<List<Integer>>(){}).name("docker.container.directPorts").description("List of ports that are to be mapped directly on the Docker host").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<Integer>> DOCKER_OPEN_PORTS = ConfigKeys.builder((TypeToken)new TypeToken<List<Integer>>(){}).name("docker.container.openPorts").description("List of extra ports to open on the container for forwarding").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hosts.total", (String)"Number of Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containers.total", (String)"Number of Docker containers");
    public static final AttributeSensor<Integer> DOCKER_IDLE_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hosts.idle", (String)"Number of idle Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_IDLE_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containers.idle", (String)"Number of idle Docker containers");
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private DockerAttributes() {
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        TypeCoercions.registerAdapter(String.class, DockerAwarePlacementStrategy.class, (Function)new Function<String, DockerAwarePlacementStrategy>(){

            public DockerAwarePlacementStrategy apply(String input) {
                ClassLoader classLoader = DockerAwarePlacementStrategy.class.getClassLoader();
                Optional strategy = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (strategy.isPresent()) {
                    return (DockerAwarePlacementStrategy)strategy.get();
                }
                throw new IllegalStateException("Failed to create DockerAwarePlacementStrategy " + input);
            }
        });
    }

    static {
        DockerAttributes.init();
    }
}

