/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.policy;

import brooklyn.entity.BrooklynAppUnitTestSupport;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.container.policy.ContainerHeadroomEnricher;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.strategy.MaxContainersPlacementStrategy;
import brooklyn.policy.EnricherSpec;
import brooklyn.test.Asserts;
import brooklyn.test.EntityTestUtils;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContainerHeadroomEnricherTest
extends BrooklynAppUnitTestSupport {
    private final Map<String, Duration> assertMap = ImmutableMap.of((Object)"timeout", (Object)Duration.ONE_SECOND);
    private EntityInternal entity;
    private RecordingSensorEventListener listener;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.entity = (EntityInternal)this.app.createAndManageChild(EntitySpec.create(DockerInfrastructure.class).impl(DockerInfrastructureSimulated.class).configure(MaxContainersPlacementStrategy.DOCKER_CONTAINER_CLUSTER_MAX_SIZE, (Object)8));
        this.listener = new RecordingSensorEventListener();
        this.app.subscribe((Entity)this.entity, (Sensor)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT, (SensorEventListener)this.listener);
        this.app.subscribe((Entity)this.entity, (Sensor)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD, (SensorEventListener)this.listener);
        this.app.subscribe((Entity)this.entity, (Sensor)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK, (SensorEventListener)this.listener);
    }

    @Test
    public void testNoEventsWhenAllOk() throws Exception {
        this.entity.addEnricher(EnricherSpec.create(ContainerHeadroomEnricher.class).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM, (Object)4));
        this.entity.setAttribute(DockerInfrastructure.DOCKER_HOST_COUNT, (Object)2);
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)8);
        this.assertNoEventsContinually();
    }

    @Test(groups={"integration"})
    public void testTooHotWhenHeadroomExceeded() throws Exception {
        this.entity.addEnricher(EnricherSpec.create(ContainerHeadroomEnricher.class).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM, (Object)4));
        this.entity.setAttribute(DockerInfrastructure.DOCKER_HOST_COUNT, (Object)2);
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)13);
        this.assertTooHot(new CurrentStatus().hostCount(2).needed(1).utilization(0.8125).lowThreshold(0.25).highThreshold(0.75));
        this.listener.clearEventsContinually();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)28);
        this.assertTooHot(new CurrentStatus().hostCount(2).needed(16).utilization(1.75).lowThreshold(0.25).highThreshold(0.75));
        this.listener.clearEvents();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)8);
        this.assertOk(new CurrentStatus().hostCount(2).needed(-4).utilization(0.5).lowThreshold(0.25).highThreshold(0.75));
        this.listener.clearEvents();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)9);
        this.assertNoEventsContinually();
    }

    @Test(groups={"integration"})
    public void testTooColdThenOk() throws Exception {
        this.entity.addEnricher(EnricherSpec.create(ContainerHeadroomEnricher.class).configure(ContainerHeadroomEnricher.CONTAINER_HEADROOM, (Object)4));
        this.entity.setAttribute(DockerInfrastructure.DOCKER_HOST_COUNT, (Object)10);
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)1);
        this.assertTooCold(new CurrentStatus().hostCount(10).needed(-75).utilization(0.0125).lowThreshold(0.85).highThreshold(0.95));
        this.listener.clearEventsContinually();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_HOST_COUNT, (Object)2);
        this.assertTooCold(new CurrentStatus().hostCount(2).needed(-11).utilization(0.0625).lowThreshold(0.25).highThreshold(0.75));
        this.listener.clearEvents();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)8);
        this.assertOk(new CurrentStatus().hostCount(2).needed(-4).utilization(0.5).lowThreshold(0.25).highThreshold(0.75));
        this.listener.clearEvents();
        this.entity.setAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)9);
        this.assertNoEventsContinually();
    }

    private void assertNoEventsContinually() {
        Asserts.succeedsContinually((Runnable)new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals(ContainerHeadroomEnricherTest.this.listener.getEvents(), (Collection)ImmutableList.of());
            }
        });
    }

    private void assertTooHot(CurrentStatus status) {
        this.assertTemperatureEvent(status, (BasicNotificationSensor<Map>)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_HOT);
    }

    private void assertTooCold(CurrentStatus status) {
        this.assertTemperatureEvent(status, (BasicNotificationSensor<Map>)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_COLD);
    }

    private void assertOk(CurrentStatus status) {
        this.assertTemperatureEvent(status, (BasicNotificationSensor<Map>)ContainerHeadroomEnricher.DOCKER_CONTAINER_CLUSTER_OK);
    }

    private void assertTemperatureEvent(final CurrentStatus status, final BasicNotificationSensor<Map> eventType) {
        EntityTestUtils.assertAttributeEqualsEventually(this.assertMap, (Entity)this.entity, (AttributeSensor)ContainerHeadroomEnricher.CONTAINERS_NEEDED, (Object)status.needed);
        EntityTestUtils.assertAttributeEqualsEventually(this.assertMap, (Entity)this.entity, (AttributeSensor)ContainerHeadroomEnricher.DOCKER_CONTAINER_UTILISATION, (Object)status.utilization);
        Asserts.succeedsEventually(this.assertMap, (Runnable)new Runnable(){

            @Override
            public void run() {
                List<SensorEvent<Object>> events = ContainerHeadroomEnricherTest.this.listener.getEvents();
                Assert.assertTrue((events.size() == 1 || events.size() == 2 ? 1 : 0) != 0, (String)("events=" + events));
                if (events.size() == 2) {
                    Assert.assertEquals((Object)events.get(0).getSensor(), (Object)events.get(1).getSensor());
                    Assert.assertEquals((Object)events.get(0).getValue(), (Object)events.get(1).getValue());
                }
                Assert.assertEquals((Object)events.get(0).getSensor(), (Object)eventType);
                Assert.assertEquals((Object)events.get(0).getValue(), (Object)ImmutableMap.of((Object)"pool.current.size", (Object)status.hostCount, (Object)"pool.current.workrate", (Object)status.utilization, (Object)"pool.low.threshold", (Object)status.lowThreshold, (Object)"pool.high.threshold", (Object)status.highThreshold));
            }
        });
    }

    public static class RecordingSensorEventListener
    implements SensorEventListener<Object> {
        List<SensorEvent<Object>> events = Lists.newCopyOnWriteArrayList();

        public void onEvent(SensorEvent<Object> event) {
            this.events.add(event);
        }

        public List<SensorEvent<Object>> getEvents() {
            return this.events;
        }

        public void clearEvents() {
            this.events.clear();
        }

        public void clearEventsContinually() {
            Time.sleep((Duration)Duration.ONE_SECOND);
            this.clearEvents();
        }
    }

    public static class DockerInfrastructureSimulated
    extends BasicStartableImpl
    implements DockerInfrastructure {
        private int currentSize = 0;

        public Integer resize(Integer desiredSize) {
            this.currentSize = desiredSize;
            return this.currentSize;
        }

        public Integer getCurrentSize() {
            return this.currentSize;
        }

        public boolean isLocationAvailable() {
            return false;
        }

        public void deleteLocation() {
        }

        public List<Entity> getDockerHostList() {
            return ImmutableList.of();
        }

        public List<Entity> getDockerContainerList() {
            return ImmutableList.of();
        }

        public DockerLocation getDynamicLocation() {
            throw new UnsupportedOperationException();
        }

        public DockerLocation createLocation(Map<String, ?> flags) {
            throw new UnsupportedOperationException();
        }

        public DynamicCluster getDockerHostCluster() {
            throw new UnsupportedOperationException();
        }

        public DynamicGroup getContainerFabric() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CurrentStatus {
        int hostCount;
        int needed;
        double utilization;
        double lowThreshold;
        double highThreshold;

        private CurrentStatus() {
        }

        CurrentStatus hostCount(int val) {
            this.hostCount = val;
            return this;
        }

        CurrentStatus needed(int val) {
            this.needed = val;
            return this;
        }

        CurrentStatus utilization(double val) {
            this.utilization = val;
            return this;
        }

        CurrentStatus lowThreshold(double val) {
            this.lowThreshold = val;
            return this;
        }

        CurrentStatus highThreshold(double val) {
            this.highThreshold = val;
            return this;
        }
    }
}

