/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EmptySoftwareProcess;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.test.EntityTestUtils;
import brooklyn.test.entity.TestApplication;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInfrastructureTests {
    private static final Logger LOG = LoggerFactory.getLogger(DockerInfrastructureTests.class);

    private DockerInfrastructureTests() {
    }

    public static DockerInfrastructure deployAndWaitForDockerInfrastructure(TestApplication app, Location location) {
        DockerInfrastructure dockerInfrastructure = (DockerInfrastructure)app.createAndManageChild((EntitySpec)EntitySpec.create(DockerInfrastructure.class).configure(DockerInfrastructure.DOCKER_HOST_CLUSTER_MIN_SIZE, (Object)1).configure(DockerInfrastructure.SDN_ENABLE, (Object)false).displayName("Docker Infrastructure"));
        LOG.info("Starting {} in {}", (Object)dockerInfrastructure, (Object)location);
        app.start((Collection)ImmutableList.of((Object)location));
        LOG.info("Waiting {} for {} to have started", (Object)Duration.TWO_MINUTES, (Object)dockerInfrastructure);
        EntityTestUtils.assertAttributeEqualsEventually((Map)ImmutableMap.of((Object)"timeout", (Object)Duration.FIVE_MINUTES), (Entity)dockerInfrastructure, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
        return dockerInfrastructure;
    }

    public static void testDeploysTrivialApplication(TestApplication app, Location location) {
        DockerInfrastructure dockerInfrastructure = DockerInfrastructureTests.deployAndWaitForDockerInfrastructure(app, location);
        int existingCount = (Integer)dockerInfrastructure.getAttribute(DockerInfrastructure.DOCKER_CONTAINER_COUNT);
        TestApplication deployment = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)app.getManagementContext());
        deployment.createAndManageChild(EntitySpec.create(EmptySoftwareProcess.class));
        deployment.start((Collection)ImmutableList.of((Object)dockerInfrastructure.getDynamicLocation()));
        EntityTestUtils.assertAttributeEqualsEventually((Entity)deployment, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
        EntityTestUtils.assertAttributeEqualsEventually((Entity)dockerInfrastructure, (AttributeSensor)DockerInfrastructure.DOCKER_CONTAINER_COUNT, (Object)(existingCount + 1));
        deployment.stop();
    }
}

