/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.AbstractDockerPlacementStrategy;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadthFirstPlacementStrategy
extends AbstractDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BreadthFirstPlacementStrategy.class);
    public static final ConfigKey<Integer> DOCKER_CONTAINER_CLUSTER_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"docker.container.cluster.maxSize", (String)"Maximum size of a Docker container cluster", (Integer)4);

    @Override
    protected List<Location> getDockerHostLocations(Multimap<Location, Entity> members, List<DockerHostLocation> available, int n) {
        int remaining = n;
        for (DockerHostLocation machine : available) {
            int maxSize = (Integer)machine.getOwner().getConfig(DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
            int currentSize = machine.getOwner().getCurrentSize();
            remaining -= maxSize - currentSize;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested {}, Need {} more from new Docker hosts, current hosts {}", new Object[]{n, remaining, Iterables.toString((Iterable)Iterables.transform(available, BreadthFirstPlacementStrategy.identity()))});
        }
        if (remaining > 0) {
            int maxSize = (Integer)this.getDockerInfrastructure().getConfig(DOCKER_CONTAINER_CLUSTER_MAX_SIZE);
            int delta = remaining / maxSize + (remaining % maxSize > 0 ? 1 : 0);
            Collection added = this.getDockerInfrastructure().getDockerHostCluster().resizeByDelta(delta);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added {} Docker hosts: {}", (Object)delta, (Object)Iterables.toString((Iterable)Iterables.transform((Iterable)added, BreadthFirstPlacementStrategy.identity())));
            }
            for (Entity each : added) {
                Entities.waitForServiceUp((Entity)each);
            }
            Collection dockerHosts = Collections2.transform((Collection)added, (Function)new Function<Entity, DockerHostLocation>(){

                public DockerHostLocation apply(@Nullable Entity input) {
                    return (DockerHostLocation)((DockerHost)input).getDynamicLocation();
                }
            });
            available.addAll(dockerHosts);
        }
        ArrayList result = Lists.newArrayList();
        Map<DockerHostLocation, Integer> sizes = this.toAvailableLocationSizes(available);
        for (int i = 0; i < n; ++i) {
            DockerHostLocation smallest = null;
            int minSize = 0;
            for (DockerHostLocation loc : sizes.keySet()) {
                int size = sizes.get(loc);
                if (smallest != null && size >= minSize) continue;
                smallest = loc;
                minSize = size;
            }
            Preconditions.checkState((smallest != null ? 1 : 0) != 0, (String)"Smallest was null; locs=%s", (Object[])new Object[]{sizes.keySet()});
            result.add(smallest);
            int maxSize = smallest.getMaxSize();
            int currentSize = sizes.get(smallest) + 1;
            if (currentSize < maxSize) {
                sizes.put(smallest, currentSize);
                continue;
            }
            sizes.remove(smallest);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Placement for {} nodes: {}", (Object)n, (Object)Iterables.toString((Iterable)Iterables.transform((Iterable)result, BreadthFirstPlacementStrategy.identity())));
        }
        return result;
    }
}

