/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.KeyValueParser;
import brooklyn.util.text.Strings;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerResolver
implements LocationResolver.EnableableLocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DockerResolver.class);
    public static final String DOCKER = "docker";
    public static final Pattern PATTERN = Pattern.compile("(docker|" + "docker".toUpperCase() + ")" + ":([a-zA-Z0-9]+)" + "(:([a-zA-Z0-9]+))?" + "(:\\((.*)\\))?$");
    public static final Set<String> ACCEPTABLE_ARGS = ImmutableSet.of((Object)"name", (Object)"displayName");
    public static final String DOCKER_INFRASTRUCTURE_SPEC = "docker:%s";
    public static final String DOCKER_HOST_MACHINE_SPEC = "docker:%s:%s";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public String getPrefix() {
        return DOCKER;
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        return this.newLocationFromString(spec, registry, registry.getProperties(), locationFlags);
    }

    protected Location newLocationFromString(String spec, LocationRegistry registry, Map properties, Map locationFlags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving location '" + spec + "' with flags " + Joiner.on((String)",").withKeyValueSeparator("=").join(locationFlags));
        }
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        Matcher matcher = PATTERN.matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; must specify something like docker:entityId or docker:entityId:(name=abc)");
        }
        String argsPart = matcher.group(6);
        Map argsMap = argsPart != null ? KeyValueParser.parseMap((String)argsPart) : Collections.emptyMap();
        String displayNamePart = (String)argsMap.get("displayName");
        String namePart = (String)argsMap.get("name");
        if (!ACCEPTABLE_ARGS.containsAll(argsMap.keySet())) {
            Sets.SetView illegalArgs = Sets.difference(argsMap.keySet(), ACCEPTABLE_ARGS);
            throw new IllegalArgumentException("Invalid location '" + spec + "'; illegal args " + illegalArgs + "; acceptable args are " + ACCEPTABLE_ARGS);
        }
        if (argsMap.containsKey("displayName") && Strings.isEmpty((CharSequence)displayNamePart)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if displayName supplied then value must be non-empty");
        }
        if (argsMap.containsKey("name") && Strings.isEmpty((CharSequence)namePart)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if name supplied then value must be non-empty");
        }
        Map filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(DOCKER, namedLocation, properties);
        MutableMap flags = MutableMap.builder().putAll(filteredProperties).putAll(locationFlags).build();
        String infrastructureId = matcher.group(2);
        if (Strings.isBlank((CharSequence)infrastructureId)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; infrastructure entity id must be non-empty");
        }
        String dockerHostId = matcher.group(4);
        StringBuilder name = new StringBuilder();
        if (displayNamePart != null) {
            name.append(displayNamePart);
        } else {
            name.append("Docker ");
            if (dockerHostId == null) {
                name.append("Infrastructure ").append(infrastructureId);
            } else {
                name.append("Host ").append(dockerHostId);
            }
        }
        String displayName = name.toString();
        name = new StringBuilder();
        if (namePart != null) {
            name.append(namePart);
        } else {
            name.append("docker-");
            name.append(infrastructureId);
            if (dockerHostId != null) {
                name.append("-").append(dockerHostId);
            }
        }
        String locationName = name.toString();
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.managementContext.getEntityManager().getEntity(infrastructureId);
        if (dockerHostId == null) {
            LocationSpec locationSpec = (LocationSpec)LocationSpec.create(DockerLocation.class).configure((Map)flags).configure(DynamicLocation.OWNER, (Object)infrastructure).configure(LocationInternal.NAMED_SPEC_NAME, (Object)locationName).displayName(displayName);
            return this.managementContext.getLocationManager().createLocation(locationSpec);
        }
        DockerHost dockerHost = (DockerHost)this.managementContext.getEntityManager().getEntity(dockerHostId);
        LocationSpec locationSpec = (LocationSpec)LocationSpec.create(DockerHostLocation.class).parent(infrastructure.getDynamicLocation()).configure((Map)flags).configure(DynamicLocation.OWNER, (Object)dockerHost).configure(LocationInternal.NAMED_SPEC_NAME, (Object)locationName).displayName(displayName);
        return this.managementContext.getLocationManager().createLocation(locationSpec);
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true);
    }

    public boolean isEnabled() {
        return true;
    }
}

