/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.affinity;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.location.Location;
import brooklyn.location.affinity.AffinityRuleExtension;
import brooklyn.location.affinity.AffinityRules;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.management.ManagementContext;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerAffinityRuleStrategy
implements AffinityRuleExtension {
    private static final Logger LOG = LoggerFactory.getLogger(DockerAffinityRuleStrategy.class);
    private final ManagementContext managementContext;
    private final DockerLocation location;

    public DockerAffinityRuleStrategy(ManagementContext managementContext, DockerLocation location) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        this.location = (DockerLocation)Preconditions.checkNotNull((Object)location, (Object)"location");
    }

    @Override
    public List<Location> filterLocations(Entity entity) {
        List hosts = ((AvailabilityZoneExtension)this.location.getExtension(AvailabilityZoneExtension.class)).getAllSubLocations();
        ArrayList available = Lists.newArrayList();
        for (DockerHostLocation machine : Iterables.filter((Iterable)hosts, DockerHostLocation.class)) {
            Optional entityRules = Optional.fromNullable((Object)entity.getConfig(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            Optional hostRules = Optional.fromNullable((Object)machine.getOwner().getConfig(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            Optional infrastructureRules = Optional.fromNullable((Object)machine.getOwner().getInfrastructure().getConfig(DockerHost.DOCKER_HOST_AFFINITY_RULES));
            String combined = Joiner.on((char)'\n').join(Optional.presentInstances((Iterable)ImmutableList.of((Object)entityRules, (Object)hostRules, (Object)infrastructureRules)));
            AffinityRules rules = AffinityRules.rulesFor(entity).parse(combined);
            Collection entities = this.managementContext.getEntityManager().findEntities(EntityPredicates.withLocation((Location)machine));
            if (Iterables.isEmpty((Iterable)entities)) {
                if (!rules.allowEmptyLocations()) continue;
                available.add(machine);
                continue;
            }
            Iterable filtered = Iterables.filter((Iterable)entities, (Predicate)rules);
            if (Iterables.size((Iterable)filtered) != Iterables.size((Iterable)entities)) continue;
            available.add(machine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Available Docker hosts: {}", (Object)Iterables.toString((Iterable)available));
        }
        return ImmutableList.copyOf((Collection)available);
    }
}

