/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructureImpl;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicMultiGroup;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.affinity.AffinityRules;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.strategy.CpuUsagePlacementStrategy;
import brooklyn.location.docker.strategy.DepthFirstPlacementStrategy;
import brooklyn.location.docker.strategy.DockerAwarePlacementStrategy;
import brooklyn.location.dynamic.LocationOwner;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.util.flags.SetFromFlag;
import java.util.List;

@Catalog(name="Docker Infrastructure", description="Docker is an open-source engine to easily create lightweight, portable, self-sufficient containers from any application.", iconUrl="classpath:///docker-top-logo.png")
@ImplementedBy(value=DockerInfrastructureImpl.class)
public interface DockerInfrastructure
extends BasicStartable,
Resizable,
LocationOwner<DockerLocation, DockerInfrastructure> {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> DOCKER_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.2");
    @SetFromFlag(value="securityGroup")
    public static final ConfigKey<String> SECURITY_GROUP = ConfigKeys.newStringConfigKey((String)"docker.host.securityGroup", (String)"Set a network security group for cloud servers to use; (null to use default configuration)");
    @SetFromFlag(value="openIptables")
    public static final ConfigKey<Boolean> OPEN_IPTABLES = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)JcloudsLocationConfig.OPEN_IPTABLES);
    @SetFromFlag(value="minHost")
    public static final ConfigKey<Integer> DOCKER_HOST_CLUSTER_MIN_SIZE = ConfigKeys.newConfigKeyWithPrefix((String)"docker.host.", (ConfigKey)DynamicCluster.INITIAL_SIZE);
    @SetFromFlag(value="strategy")
    public static final ConfigKey<DockerAwarePlacementStrategy> PLACEMENT_STRATEGY = ConfigKeys.newConfigKey(DockerAwarePlacementStrategy.class, (String)"docker.container.strategy", (String)"Placement stratgy for Docker containers");
    @SetFromFlag(value="maxContainer")
    public static final ConfigKey<Integer> DOCKER_CONTAINER_CLUSTER_MAX_SIZE = DepthFirstPlacementStrategy.DOCKER_CONTAINER_CLUSTER_MAX_SIZE;
    @SetFromFlag(value="maxCpu")
    public static final ConfigKey<Double> DOCKER_CONTAINER_CLUSTER_MAX_CPU = CpuUsagePlacementStrategy.DOCKER_CONTAINER_CLUSTER_MAX_CPU;
    @SetFromFlag(value="registerHosts")
    public static final ConfigKey<Boolean> REGISTER_DOCKER_HOST_LOCATIONS = ConfigKeys.newBooleanConfigKey((String)"docker.host.register", (String)"Register new Docker Host locations for deployment", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="removeEmptyHosts")
    public static final ConfigKey<Boolean> REMOVE_EMPTY_DOCKER_HOSTS = ConfigKeys.newBooleanConfigKey((String)"docker.host.removeEmpty", (String)"Remove empty Docker Hosts with no containers", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="hostSpec")
    public static final BasicAttributeSensorAndConfigKey<EntitySpec> DOCKER_HOST_SPEC = new BasicAttributeSensorAndConfigKey(EntitySpec.class, "docker.host.spec", "Specification to use when creating child Docker Hosts", (Object)EntitySpec.create(DockerHost.class));
    @SetFromFlag(value="dockerfileUrl")
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_URL, (Object)"classpath://brooklyn/entity/container/docker/ubuntu/Dockerfile");
    @SetFromFlag(value="dockerfileName")
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newConfigKeyWithDefault(DockerAttributes.DOCKERFILE_NAME, (Object)"ubuntu");
    @SetFromFlag(value="imageId")
    public static final ConfigKey<String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID.getConfigKey();
    @SetFromFlag(value="hardwareId")
    public static final ConfigKey<String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID.getConfigKey();
    @SetFromFlag(value="affinityRules")
    public static final ConfigKey<String> DOCKER_HOST_AFFINITY_RULES = AffinityRules.AFFINITY_RULES;
    public static final AttributeSensor<DynamicCluster> DOCKER_HOST_CLUSTER = Sensors.newSensor(DynamicCluster.class, (String)"docker.hosts", (String)"Docker host cluster");
    public static final AttributeSensor<DynamicGroup> DOCKER_CONTAINER_FABRIC = Sensors.newSensor(DynamicGroup.class, (String)"docker.fabric", (String)"Docker container fabric");
    public static final AttributeSensor<DynamicMultiGroup> DOCKER_APPLICATIONS = Sensors.newSensor(DynamicMultiGroup.class, (String)"docker.buckets", (String)"Docker applications");
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = DockerAttributes.DOCKER_HOST_COUNT;
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = DockerAttributes.DOCKER_CONTAINER_COUNT;

    public List<Entity> getDockerHostList();

    public DynamicCluster getDockerHostCluster();

    public List<Entity> getDockerContainerList();

    public DynamicGroup getContainerFabric();
}

