/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerHostDriver;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.machine.MachineEntityImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.access.PortForwardManagerAuthority;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import brooklyn.management.LocationManager;
import brooklyn.management.ManagementContext;
import brooklyn.networking.portforwarding.DockerPortForwarder;
import brooklyn.networking.subnet.PortForwarder;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.networking.subnet.SubnetTierImpl;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.ha.ServiceFailureDetector;
import brooklyn.policy.ha.ServiceReplacer;
import brooklyn.policy.ha.ServiceRestarter;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Cidr;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostImpl
extends MachineEntityImpl
implements DockerHost {
    private static final Logger LOG = LoggerFactory.getLogger(DockerHostImpl.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private DynamicCluster containers;
    private JcloudsLocation jcloudsLocation;
    private DockerPortForwarder portForwarder;
    private SubnetTier subnetTier;

    public void init() {
        LOG.info("Starting Docker host id {}", (Object)this.getId());
        super.init();
        String dockerHostName = String.format((String)this.getConfig(DockerHost.HOST_NAME_FORMAT), this.getId(), COUNTER.incrementAndGet());
        this.setDisplayName(dockerHostName);
        this.setAttribute(DOCKER_HOST_NAME, dockerHostName);
        String repository = (String)this.getConfig((ConfigKey.HasConfigKey)DOCKER_REPOSITORY);
        if (Strings.isBlank((CharSequence)repository)) {
            repository = this.getId();
        }
        repository = DockerAttributes.allowed(repository);
        this.setAttribute((AttributeSensor)DOCKER_REPOSITORY, repository);
        String password = (String)this.getConfig(DOCKER_PASSWORD);
        if (Strings.isBlank((CharSequence)password)) {
            password = Identifiers.makeRandomId((int)8);
            this.setConfig(DOCKER_PASSWORD, password);
        }
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        EntitySpec dockerContainerSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.getConfig((ConfigKey.HasConfigKey)DOCKER_CONTAINER_SPEC))).configure(DockerContainer.DOCKER_HOST, (Object)this).configure(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getInfrastructure());
        if (((Boolean)this.getConfig(HA_POLICY_ENABLE)).booleanValue()) {
            dockerContainerSpec.policy(PolicySpec.create(ServiceRestarter.class).configure(ServiceRestarter.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceFailureDetector.ENTITY_FAILED));
        }
        this.setAttribute((AttributeSensor)DOCKER_CONTAINER_SPEC, dockerContainerSpec);
        this.containers = (DynamicCluster)this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure((ConfigKey)Cluster.INITIAL_SIZE, (Object)0).configure(DynamicCluster.QUARANTINE_FAILED_ENTITIES, (Object)false).configure(DynamicCluster.MEMBER_SPEC, (Object)dockerContainerSpec).displayName("Docker Containers"));
        if (((Boolean)this.getConfig(HA_POLICY_ENABLE)).booleanValue()) {
            this.containers.addPolicy(PolicySpec.create(ServiceReplacer.class).configure(ServiceReplacer.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceRestarter.ENTITY_RESTART_FAILED));
        }
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)this.containers);
        }
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)DynamicCluster.GROUP_SIZE, DockerAttributes.DOCKER_CONTAINER_COUNT)).from((Entity)this.containers)).build());
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        Map flags = super.obtainProvisioningFlags(location);
        TemplateBuilder template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName());
        if (template == null) {
            template = new PortableTemplateBuilder();
            if (this.isJcloudsLocation(location, "google-compute-engine")) {
                template.osFamily(OsFamily.CENTOS).osVersionMatches("6");
            } else {
                template.osFamily(OsFamily.UBUNTU).osVersionMatches("12.04");
            }
        }
        template.os64Bit(true);
        template.minRam(2048);
        flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
        String securityGroup = (String)this.getConfig(DockerInfrastructure.SECURITY_GROUP);
        if (Strings.isNonBlank((CharSequence)securityGroup)) {
            if (this.isJcloudsLocation(location, "google-compute-engine")) {
                flags.put("networkName", securityGroup);
            } else {
                flags.put("securityGroups", securityGroup);
            }
        } else {
            flags.put(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZER.getName(), JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId()));
        }
        return flags;
    }

    private boolean isJcloudsLocation(MachineProvisioningLocation location, String providerName) {
        return location instanceof JcloudsLocation && ((JcloudsLocation)location).getProvider().equals(providerName);
    }

    public Integer resize(Integer desiredSize) {
        return this.getDockerContainerCluster().resize(desiredSize);
    }

    public String getShortName() {
        return "Docker Host";
    }

    public Integer getCurrentSize() {
        return this.getDockerContainerCluster().getCurrentSize();
    }

    public Class<?> getDriverInterface() {
        return DockerHostDriver.class;
    }

    public DockerHostDriver getDriver() {
        return (DockerHostDriver)super.getDriver();
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.getAttribute((AttributeSensor)DOCKER_PORT);
    }

    @Override
    public String getDockerHostName() {
        return (String)this.getAttribute(DOCKER_HOST_NAME);
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return ImmutableList.copyOf((Collection)this.containers.getMembers());
    }

    @Override
    public DockerInfrastructure getInfrastructure() {
        return (DockerInfrastructure)this.getConfig((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
    }

    @Override
    public String getPassword() {
        return (String)this.getConfig(DOCKER_PASSWORD);
    }

    @Override
    public String getRepository() {
        return (String)this.getAttribute((AttributeSensor)DOCKER_REPOSITORY);
    }

    @Override
    public String createSshableImage(String dockerFile, String name) {
        String imageId = this.getDriver().buildImage(dockerFile, name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully created image {} ({}/{})", new Object[]{imageId, this.getRepository(), name});
        }
        return imageId;
    }

    @Override
    public String runDockerCommand(String command) {
        return this.runDockerCommandTimeout(command, Duration.ONE_MINUTE);
    }

    @Override
    public String runDockerCommandTimeout(String command, Duration timeout) {
        String stdout = this.execCommandTimeout(BashCommands.sudo((String)String.format("docker %s", command)), timeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully executed Docker {}: {}", (Object)Strings.getFirstWord((String)command), (Object)Strings.getFirstLine((String)stdout));
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deployArchive(String url) {
        Tasks.setBlockingDetails((String)("Deploy " + url));
        try {
            String string = this.getDriver().deployArchive(url);
            return string;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }

    public DockerHostLocation getDynamicLocation() {
        return (DockerHostLocation)this.getAttribute(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public DynamicCluster getDockerContainerCluster() {
        return this.containers;
    }

    @Override
    public JcloudsLocation getJcloudsLocation() {
        return this.jcloudsLocation;
    }

    @Override
    public PortForwarder getPortForwarder() {
        return this.portForwarder;
    }

    @Override
    public SubnetTier getSubnetTier() {
        return this.subnetTier;
    }

    public DockerHostLocation createLocation(Map<String, ?> flags) {
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.getConfig((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
        DockerLocation docker = (DockerLocation)infrastructure.getDynamicLocation();
        String locationName = docker.getId() + "-" + this.getDockerHostName();
        String locationSpec = String.format("docker:%s:%s", infrastructure.getId(), this.getId()) + String.format(":(name=\"%s\")", locationName);
        this.setAttribute(LOCATION_SPEC, locationSpec);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, flags);
        Location location = this.getManagementContext().getLocationRegistry().resolve((LocationDefinition)definition);
        this.setAttribute(DYNAMIC_LOCATION, location);
        this.setAttribute((AttributeSensor)LOCATION_NAME, location.getId());
        if (((Boolean)this.getConfig(DockerInfrastructure.REGISTER_DOCKER_HOST_LOCATIONS)).booleanValue()) {
            this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        }
        this.getManagementContext().getLocationManager().manage(location);
        this.getManagementContext().addPropertiesReloadListener(new ManagementContext.PropertiesReloadListener((LocationDefinition)definition){
            final /* synthetic */ LocationDefinition val$definition;
            {
                this.val$definition = locationDefinition;
            }

            public void reloaded() {
                if (DockerHostImpl.this.getInfrastructure().isLocationAvailable()) {
                    Location resolved = DockerHostImpl.this.getManagementContext().getLocationRegistry().resolve(this.val$definition);
                    if (((Boolean)DockerHostImpl.this.getConfig(DockerInfrastructure.REGISTER_DOCKER_HOST_LOCATIONS)).booleanValue()) {
                        DockerHostImpl.this.getManagementContext().getLocationRegistry().updateDefinedLocation(this.val$definition);
                    }
                    DockerHostImpl.this.getManagementContext().getLocationManager().manage(resolved);
                }
            }
        });
        LOG.info("New Docker host location {} created", (Object)location);
        return (DockerHostLocation)location;
    }

    public void deleteLocation() {
        DockerHostLocation location = this.getDynamicLocation();
        if (location != null) {
            LocationManager mgr = this.getManagementContext().getLocationManager();
            if (mgr.isManaged((Location)location)) {
                mgr.unmanage((Location)location);
            }
            if (((Boolean)this.getConfig(DockerInfrastructure.REGISTER_DOCKER_HOST_LOCATIONS)).booleanValue()) {
                this.getManagementContext().getLocationRegistry().removeDefinedLocation(location.getId());
            }
        }
        this.setAttribute(DYNAMIC_LOCATION, null);
        this.setAttribute((AttributeSensor)LOCATION_NAME, null);
    }

    protected void preStart() {
        this.getDriver().configureSecurityGroups();
        Maybe found = Machines.findUniqueSshMachineLocation((Iterable)this.getLocations());
        String dockerLocationSpec = String.format("jclouds:docker:http://%s:%s", ((SshMachineLocation)found.get()).getSshHostAndPort().getHostText(), this.getDockerPort());
        this.jcloudsLocation = (JcloudsLocation)this.getManagementContext().getLocationRegistry().resolve(dockerLocationSpec, (Map)MutableMap.of((Object)"identity", (Object)"docker", (Object)"credential", (Object)"docker", (Object)"jclouds.image.login-user", (Object)("root:" + this.getPassword())));
        this.portForwarder = new DockerPortForwarder((PortForwardManager)new PortForwardManagerAuthority((Entity)this));
        this.portForwarder.init(URI.create(this.jcloudsLocation.getEndpoint()));
        this.subnetTier = (SubnetTier)this.addChild(EntitySpec.create(SubnetTier.class, SubnetTierImpl.class).configure(SubnetTier.PORT_FORWARDER, (Object)this.portForwarder).configure(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL));
        this.subnetTier.start((Collection)ImmutableList.of((Object)found.get()));
        MutableMap flags = MutableMap.builder().putAll((Map)this.getConfig(LOCATION_FLAGS)).put((Object)"machine", found.get()).put((Object)"jcloudsLocation", (Object)this.jcloudsLocation).put((Object)"portForwarder", (Object)this.portForwarder).put((Object)"repository", (Object)this.getRepository()).build();
        this.createLocation((Map)flags);
    }

    public void postStart() {
        String imageId = (String)this.getConfig((ConfigKey.HasConfigKey)DOCKER_IMAGE_ID);
        if (Strings.isBlank((CharSequence)imageId)) {
            String dockerfileUrl = (String)this.getConfig(DockerInfrastructure.DOCKERFILE_URL);
            String imageName = DockerAttributes.imageName((Entity)this, dockerfileUrl, this.getRepository());
            imageId = this.createSshableImage(dockerfileUrl, imageName);
            this.setAttribute(DOCKER_IMAGE_NAME, imageName);
        }
        this.setAttribute((AttributeSensor)DOCKER_IMAGE_ID, imageId);
    }

    public void doStop() {
        super.doStop();
        this.deleteLocation();
    }

    static {
        RendererHints.register((Object)DOCKER_INFRASTRUCTURE, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

