/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerAttributes;
import brooklyn.entity.container.docker.DockerContainerImpl;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.dynamic.LocationOwner;
import brooklyn.util.flags.SetFromFlag;
import java.util.List;

@ImplementedBy(value=DockerContainerImpl.class)
public interface DockerContainer
extends BasicStartable,
HasShortName,
LocationOwner<DockerContainerLocation, DockerContainer> {
    @SetFromFlag(value="dockerHost")
    public static final AttributeSensorAndConfigKey<DockerHost, DockerHost> DOCKER_HOST = ConfigKeys.newSensorAndConfigKey(DockerHost.class, (String)"docker.host", (String)"The parent Docker host");
    @SetFromFlag(value="infrastructure")
    public static final AttributeSensorAndConfigKey<DockerInfrastructure, DockerInfrastructure> DOCKER_INFRASTRUCTURE = DockerHost.DOCKER_INFRASTRUCTURE;
    @SetFromFlag(value="managed")
    public static final ConfigKey<Boolean> MANAGED = DockerAttributes.MANAGED;
    @SetFromFlag(value="password")
    public static final ConfigKey<String> DOCKER_PASSWORD = DockerAttributes.DOCKER_PASSWORD;
    @SetFromFlag(value="imageId")
    public static final ConfigKey<String> DOCKER_IMAGE_ID = DockerAttributes.DOCKER_IMAGE_ID.getConfigKey();
    @SetFromFlag(value="hardwareId")
    public static final ConfigKey<String> DOCKER_HARDWARE_ID = DockerAttributes.DOCKER_HARDWARE_ID.getConfigKey();
    @SetFromFlag(value="useHostDnsName")
    public static final ConfigKey<Boolean> DOCKER_USE_HOST_DNS_NAME = DockerAttributes.DOCKER_USE_HOST_DNS_NAME;
    @SetFromFlag(value="cpuShares")
    public static final ConfigKey<Integer> DOCKER_CPU_SHARES = DockerAttributes.DOCKER_CPU_SHARES;
    @SetFromFlag(value="memory")
    public static final ConfigKey<Integer> DOCKER_MEMORY = DockerAttributes.DOCKER_MEMORY;
    @SetFromFlag(value="volumeExports")
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = DockerAttributes.DOCKER_CONTAINER_VOLUME_EXPORT;
    @SetFromFlag(value="entity")
    public static final AttributeSensorAndConfigKey<Entity, Entity> ENTITY = ConfigKeys.newSensorAndConfigKey(Entity.class, (String)"docker.container.entity", (String)"The entity running in this Docker container");
    public static final ConfigKey<String> DOCKER_CONTAINER_NAME_FORMAT = ConfigKeys.newStringConfigKey((String)"docker.container.nameFormat", (String)"Format for generating Docker container names", (String)"docker-container-brooklyn-%1$s");
    public static final AttributeSensor<String> DOCKER_CONTAINER_NAME = Sensors.newStringSensor((String)"docker.container.name", (String)"The name of the Docker container");
    public static final AttributeSensor<String> IMAGE_ID = Sensors.newStringSensor((String)"docker.container.imageId", (String)"The Docker container image ID");
    public static final AttributeSensor<String> IMAGE_NAME = Sensors.newStringSensor((String)"docker.container.imageName", (String)"The Docker container image name");
    public static final AttributeSensor<String> HARDWARE_ID = Sensors.newStringSensor((String)"docker.container.hardwareId", (String)"The Docker container hardware ID");
    public static final AttributeSensor<String> CONTAINER_ID = Sensors.newStringSensor((String)"docker.container.id", (String)"The Docker container ID");
    public static final AttributeSensor<Entity> CONTAINER = Sensors.newSensor(Entity.class, (String)"docker.container", (String)"The Docker container entity");
    public static final AttributeSensor<Boolean> CONTAINER_RUNNING = Sensors.newBooleanSensor((String)"docker.container.running", (String)"The Docker container process status");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = SoftwareProcess.SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<SshMachineLocation> SSH_MACHINE_LOCATION = Sensors.newSensor(SshMachineLocation.class, (String)"docker.container.ssh", (String)"The SSHable machine");
    public static final MethodEffector<Void> SHUT_DOWN = new MethodEffector(DockerContainer.class, "shutDown");
    public static final MethodEffector<Void> PAUSE = new MethodEffector(DockerContainer.class, "pause");
    public static final MethodEffector<Void> RESUME = new MethodEffector(DockerContainer.class, "resume");

    @Effector(description="Shut-down the Docker container")
    public void shutDown();

    @Effector(description="Pause the Docker container")
    public void pause();

    @Effector(description="Resume the Docker container")
    public void resume();

    public String getDockerContainerName();

    public String getContainerId();

    public Entity getRunningEntity();

    public void setRunningEntity(Entity var1);

    public DockerHost getDockerHost();

    public SshMachineLocation getMachine();
}

