/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import io.branch.referral.validators.BranchIntegrationModel;
import io.branch.referral.validators.IntegrationValidatorCheck;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class URISchemeCheck
extends IntegrationValidatorCheck {
    String name = "URI Scheme";
    String uriSchemeNotSetInManifestErrorMessage = "No intent found for opening the app through uri Scheme. Please add the intent with URI scheme to your Android manifest.";
    String uriSchemeNotSetInBranchDashboardErrorMessage = "Uri Scheme to open your app is not specified in Branch dashboard. Please add URI scheme in Branch dashboard.";
    String uriSchemesDoNotMatchErrorMessage = "Uri scheme specified in Branch dashboard doesn't match with the deep link intent in manifest file.";
    String moreInfoLinkApp = "<a href=\"https://help.branch.io/developers-hub/docs/android-basic-integration#4-configure-app:~:text=%3Cintent%2Dfilter%3E%0A%09%09%09%09%3C!%2D%2D%20If,/%3E%0A%09%09%09%3C/intent%2Dfilter%3E\">More info</a>";
    String moreInfoLinkDashboard = "<a href=\"https://help.branch.io/developers-hub/docs/android-basic-integration#1-configure-branch-dashboard:~:text=%22Android%20URI%20Scheme%22\">More info</a>";
    BranchIntegrationModel integrationModel;
    JSONObject branchAppConfig;

    public URISchemeCheck(BranchIntegrationModel integrationModel, JSONObject branchAppConfig) {
        ((IntegrationValidatorCheck)this).name = this.name;
        this.errorMessage = "";
        this.moreInfoLink = this.moreInfoLinkApp;
        this.integrationModel = integrationModel;
        this.branchAppConfig = branchAppConfig;
    }

    @Override
    public boolean RunTests(Context context) {
        String branchAppUriScheme = this.branchAppConfig.optString("android_uri_scheme").substring(0, this.branchAppConfig.optString("android_uri_scheme").length() - 3);
        String dashboardUriScheme = this.checkBranchKey(this.integrationModel.deeplinkUriScheme.keys(), branchAppUriScheme);
        boolean isUriSchemeProperlySetOnDashboard = !TextUtils.isEmpty((CharSequence)branchAppUriScheme);
        boolean isUriSchemeIntentProperlySetup = this.checkIfIntentAddedForURIScheme(this.branchAppConfig.optString("android_uri_scheme")) && this.integrationModel.appSettingsAvailable;
        boolean doUriSchemesMatch = branchAppUriScheme.trim().equals(dashboardUriScheme.trim());
        if (!isUriSchemeProperlySetOnDashboard) {
            this.errorMessage = this.uriSchemeNotSetInBranchDashboardErrorMessage;
            this.moreInfoLink = this.moreInfoLinkDashboard;
        } else if (!isUriSchemeIntentProperlySetup) {
            this.errorMessage = this.uriSchemeNotSetInManifestErrorMessage;
            this.moreInfoLink = this.moreInfoLinkApp;
        } else if (!doUriSchemesMatch) {
            this.errorMessage = this.uriSchemesDoNotMatchErrorMessage;
            this.moreInfoLink = this.moreInfoLinkApp;
        }
        return doUriSchemesMatch && isUriSchemeProperlySetOnDashboard && isUriSchemeIntentProperlySetup;
    }

    private String checkBranchKey(Iterator<String> keys, String branchAppUriScheme) {
        String targetKey = branchAppUriScheme.replace("://", "");
        while (keys.hasNext()) {
            String key = keys.next();
            if (!targetKey.equals(key)) continue;
            return key;
        }
        return "";
    }

    @Override
    public String GetOutput(Context context, boolean didTestSucceed) {
        didTestSucceed = this.RunTests(context);
        return super.GetOutput(context, didTestSucceed);
    }

    private boolean checkIfIntentAddedForURIScheme(String uriScheme) {
        Uri branchDeepLinkURI = Uri.parse((String)uriScheme);
        String uriHost = branchDeepLinkURI.getScheme();
        String uriPath = branchDeepLinkURI.getHost();
        uriPath = TextUtils.isEmpty((CharSequence)uriPath) ? "open" : uriPath;
        boolean foundMatchingUri = false;
        if (this.integrationModel.deeplinkUriScheme != null) {
            Iterator it = this.integrationModel.deeplinkUriScheme.keys();
            block0: while (it.hasNext()) {
                String key = (String)it.next();
                if (uriHost == null || !uriHost.equals(key)) continue;
                JSONArray hosts = this.integrationModel.deeplinkUriScheme.optJSONArray(key);
                if (hosts != null && hosts.length() > 0) {
                    for (int i = 0; i < hosts.length(); ++i) {
                        if (uriPath == null || !uriPath.equals(hosts.optString(i))) continue;
                        foundMatchingUri = true;
                        continue block0;
                    }
                    continue;
                }
                foundMatchingUri = true;
                break;
            }
        }
        return foundMatchingUri;
    }
}

