/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import io.branch.referral.R;
import io.branch.referral.validators.LinkingValidatorDialogRowItem;
import java.util.ArrayList;

public class LinkingValidatorDialog
extends Dialog
implements AdapterView.OnItemSelectedListener {
    private ROUTING_TYPE routingType;
    private final Button ctaButton;
    private final Spinner linkingValidatorDropdownMenu;
    private final TextView linkingValidatorText;
    private final EditText linkingValidatorEditText;
    private final LinearLayout customKVPField;
    private final LinearLayout linkingValidatorRowsLayout;
    private int step = 1;
    private String routingKey = "";
    private String routingValue = "";
    private LinkingValidatorDialogRowItem row1;
    private LinkingValidatorDialogRowItem row2;
    private LinkingValidatorDialogRowItem row3;
    private LinkingValidatorDialogRowItem row4;
    private LinkingValidatorDialogRowItem row5;
    private LinkingValidatorDialogRowItem row6;

    public LinkingValidatorDialog(Context context) {
        super(context);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_linking_validator);
        this.linkingValidatorDropdownMenu = (Spinner)this.findViewById(R.id.linkingValidatorDropdownMenu);
        ArrayList<String> choices = new ArrayList<String>();
        choices.add("$canonical_url");
        choices.add("$deeplink_path");
        choices.add("other (custom)");
        ArrayAdapter dataAdapter = new ArrayAdapter(context, 17367048, choices);
        dataAdapter.setDropDownViewResource(0x1090009);
        this.linkingValidatorDropdownMenu.setAdapter((SpinnerAdapter)dataAdapter);
        this.linkingValidatorDropdownMenu.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.ctaButton = (Button)this.findViewById(R.id.linkingValidatorButton);
        this.ctaButton.setText((CharSequence)"Next");
        this.ctaButton.setOnClickListener(view -> {
            switch (this.step) {
                case 1: {
                    this.LoadStep2Screen();
                    break;
                }
                case 2: {
                    this.GenerateBranchLinks();
                    break;
                }
                case 3: {
                    this.CloseDialog();
                }
            }
        });
        this.linkingValidatorText = (TextView)this.findViewById(R.id.linkingValidatorText);
        this.linkingValidatorEditText = (EditText)this.findViewById(R.id.linkingValidatorEditText);
        this.customKVPField = (LinearLayout)this.findViewById(R.id.customKVPField);
        this.linkingValidatorRowsLayout = (LinearLayout)this.findViewById(R.id.linkingValidatorRows);
        this.linkingValidatorEditText.setVisibility(8);
        this.customKVPField.setVisibility(8);
        this.linkingValidatorRowsLayout.setVisibility(8);
        this.routingType = ROUTING_TYPE.CANONICAL_URL;
        this.row1 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow1);
        this.row2 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow2);
        this.row3 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow3);
        this.row4 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow4);
        this.row5 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow5);
        this.row6 = (LinkingValidatorDialogRowItem)this.findViewById(R.id.linkingValidatorRow6);
    }

    public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
        String item;
        switch (item = adapterView.getItemAtPosition(i).toString()) {
            case "$canonical_url": {
                this.routingType = ROUTING_TYPE.CANONICAL_URL;
                break;
            }
            case "$deeplink_path": {
                this.routingType = ROUTING_TYPE.DEEPLINK_PATH;
                break;
            }
            case "other (custom)": {
                this.routingType = ROUTING_TYPE.CUSTOM;
            }
        }
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    void LoadStep2Screen() {
        ++this.step;
        this.ctaButton.setText((CharSequence)"  Generate Links for Testing  ");
        this.linkingValidatorDropdownMenu.setVisibility(8);
        switch (this.routingType) {
            case CANONICAL_URL: {
                this.linkingValidatorEditText.setVisibility(0);
                this.linkingValidatorText.setText((CharSequence)"Please paste in a web link for the $canonical_url");
                break;
            }
            case DEEPLINK_PATH: {
                this.linkingValidatorEditText.setVisibility(0);
                this.linkingValidatorText.setText((CharSequence)"Please paste in a value for the $deeplink_path");
                break;
            }
            case CUSTOM: {
                this.customKVPField.setVisibility(0);
                this.linkingValidatorText.setText((CharSequence)"Please enter your custom key and value for routing");
            }
        }
    }

    void GenerateBranchLinks() {
        switch (this.routingType) {
            case CANONICAL_URL: {
                this.routingKey = "$canonical_url";
                this.routingValue = this.linkingValidatorEditText.getText().toString();
                break;
            }
            case DEEPLINK_PATH: {
                this.routingKey = "$deeplink_path";
                this.routingValue = this.linkingValidatorEditText.getText().toString();
            }
        }
        ++this.step;
        this.linkingValidatorEditText.setVisibility(8);
        this.customKVPField.setVisibility(8);
        this.linkingValidatorText.setVisibility(8);
        this.ctaButton.setText((CharSequence)"Done");
        this.linkingValidatorRowsLayout.setVisibility(0);
        EditText customKeyEditText = (EditText)this.findViewById(R.id.keyEditText);
        EditText customValueEditText = (EditText)this.findViewById(R.id.valueEditText);
        if (this.routingKey.isEmpty()) {
            this.routingKey = customKeyEditText.getText().toString();
            this.routingValue = customValueEditText.getText().toString();
        }
        this.row1.InitializeRow("Link using App Link", "Verifies that Universal Links / App Links are working correctly for your Branch domain", "Ensure you\u2019ve entered the correct SHA 256s on the dashboard and added your Branch domains to the Android Manifest", this.routingKey, this.routingValue, "regularBranchLink", true, 0, new String[0]);
        this.row2.InitializeRow("Link using URI scheme", "Verifies that URI schemes work correctly for your Branch domain", "Ensure that you\u2019ve added a unique Branch URI scheme to the dashboard and Android Manifest", this.routingKey, this.routingValue, "uriFallbackBranchLink", true, 1, "$uri_redirect_mode", "2");
        this.row3.InitializeRow("Web-only link", "Verifies that web-only links are handled correctly to take you to the mobile web", "Ensure that your code checks for $web-only in the link data, and if it is true routes the user to the mobile web", this.routingKey, this.routingValue, "webOnlyBranchLink", true, 2, "$web_only", "true");
        this.row4.InitializeRow("Link with missing data", "Verifies that your app gracefully handles Branch links missing deep link data", "Ensure that your code gracefully handles missing or invalid deep link data like taking them to the home screen", this.routingKey, "", "missingDataBranchLink", true, 3, new String[0]);
        this.row5.InitializeRow("Warm start use case", "Click the button to simulate a deep link click for the warm start use case", "Ensure that you are initializing Branch inside of onStart() and that the code is called anytime the app enters the foreground", this.routingKey, this.routingValue, "warmStartUseCase", false, 4, new String[0]);
        this.row6.InitializeRow("Foreground click use case", "Click the button to simulate a deep link click for the foreground use case", "Ensure that you are calling reInit() inside of onNewIntent() after checking if branch_force_new_session is true", this.routingKey, this.routingValue, "foregroundClickUseCase", false, 5, new String[0]);
    }

    private void CloseDialog() {
        this.dismiss();
    }

    private static enum ROUTING_TYPE {
        CANONICAL_URL,
        DEEPLINK_PATH,
        CUSTOM;

    }
}

