/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.app.AlertDialog;
import android.content.Context;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.branch.referral.R;

public class IntegrationValidatorDialogRowItem
extends LinearLayout {
    TextView titleText;
    TextView testResultSymbol;
    Button detailsButton;
    String detailsMessage;
    String moreInfoLink;

    public IntegrationValidatorDialogRowItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.integration_validator_dialog_row_item, null);
        this.addView(view);
        this.titleText = (TextView)view.findViewById(R.id.title_text);
        this.testResultSymbol = (TextView)view.findViewById(R.id.pass_or_fail_symbol_text);
        this.detailsButton = (Button)view.findViewById(R.id.details_button);
        this.detailsButton.setOnClickListener(view1 -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setMessage((CharSequence)(this.detailsMessage + "\n"));
            TextView hyperlinkToDocs = new TextView(context);
            hyperlinkToDocs.setMovementMethod(LinkMovementMethod.getInstance());
            hyperlinkToDocs.setGravity(1);
            String link = "<a href=" + this.moreInfoLink + "</a>";
            hyperlinkToDocs.setText((CharSequence)Html.fromHtml((String)link));
            builder.setView((View)hyperlinkToDocs);
            builder.setCancelable(false);
            builder.setPositiveButton((CharSequence)"OK", (dialog, which) -> {});
            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        });
    }

    public IntegrationValidatorDialogRowItem(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void SetTitleText(String title) {
        this.titleText.setText((CharSequence)title);
    }

    public void SetDetailsMessage(String detailsMessage) {
        this.detailsMessage = detailsMessage;
    }

    public void SetMoreInfoLink(String moreInfoLink) {
        this.moreInfoLink = moreInfoLink;
    }

    public void SetTestResult(boolean didTestPass) {
        String result = didTestPass ? "\u2705" : "\u274c";
        this.testResultSymbol.setText((CharSequence)result);
        this.ToggleDetailsButton(didTestPass);
    }

    public void ToggleDetailsButton(boolean didTestPass) {
        if (didTestPass) {
            this.detailsButton.setVisibility(4);
        } else {
            this.detailsButton.setVisibility(0);
        }
    }
}

