/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.util.Log;
import android.view.WindowManager;
import io.branch.interfaces.IBranchLoggingCallbacks;
import io.branch.referral.Branch;
import io.branch.referral.validators.AlternateDomainsCheck;
import io.branch.referral.validators.AppLinksCheck;
import io.branch.referral.validators.BranchInstanceCreationValidatorCheck;
import io.branch.referral.validators.BranchIntegrationModel;
import io.branch.referral.validators.BranchKeysValidatorCheck;
import io.branch.referral.validators.CustomDomainCheck;
import io.branch.referral.validators.DefaultDomainsCheck;
import io.branch.referral.validators.IntegrationValidatorDialog;
import io.branch.referral.validators.PackageNameCheck;
import io.branch.referral.validators.ServerRequestGetAppConfig;
import io.branch.referral.validators.URISchemeCheck;
import java.util.Objects;
import org.json.JSONObject;

public class IntegrationValidator
implements ServerRequestGetAppConfig.IGetAppConfigEvents {
    private static IntegrationValidator instance;
    private final BranchIntegrationModel integrationModel;
    private final String TAG = "BranchSDK_Doctor";
    private final StringBuilder branchLogsStringBuilder;
    Context context;
    boolean hasRan = false;
    boolean hasTestFailed = false;
    IntegrationValidatorDialog integrationValidatorDialog;

    private IntegrationValidator(Context context) {
        this.integrationModel = new BranchIntegrationModel(context);
        this.context = context;
        this.branchLogsStringBuilder = new StringBuilder();
    }

    public static void validate(Context context) {
        if (instance == null) {
            instance = new IntegrationValidator(context);
        }
        IBranchLoggingCallbacks iBranchLoggingCallbacks = new IBranchLoggingCallbacks(){

            @Override
            public void onBranchLog(String logMessage, String severityConstantName) {
                instance.branchLogsStringBuilder.append(logMessage);
            }
        };
        Branch.enableLogging(iBranchLoggingCallbacks);
        instance.validateSDKIntegration(context);
        IntegrationValidator.instance.integrationValidatorDialog = new IntegrationValidatorDialog(context);
    }

    public static String getLogs() {
        return IntegrationValidator.instance.branchLogsStringBuilder.toString();
    }

    private void validateSDKIntegration(Context context) {
        Branch.getInstance().requestQueue_.handleNewRequest(new ServerRequestGetAppConfig(context, this));
    }

    private void doValidateWithAppConfig(JSONObject branchAppConfig) {
        Branch.getInstance().requestQueue_.handleNewRequest(new ServerRequestGetAppConfig(this.context, this));
        this.logValidationProgress("\n\n------------------- Initiating Branch integration verification ---------------------------");
        BranchInstanceCreationValidatorCheck branchInstanceCreationValidatorCheck = new BranchInstanceCreationValidatorCheck();
        boolean result = branchInstanceCreationValidatorCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(1, branchInstanceCreationValidatorCheck.GetTestName(), result, branchInstanceCreationValidatorCheck.GetOutput(this.context, result), branchInstanceCreationValidatorCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "1. Verifying Branch instance creation", "Branch is not initialised from your Application class. Please add `Branch.getAutoInstance(this);` to your Application#onCreate() method.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-load-branch");
        BranchKeysValidatorCheck branchKeysValidatorCheck = new BranchKeysValidatorCheck();
        result = branchKeysValidatorCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(2, branchKeysValidatorCheck.GetTestName(), result, branchKeysValidatorCheck.GetOutput(this.context, result), branchKeysValidatorCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "2. Checking Branch keys", "Unable to read Branch keys from your application. Did you forget to add Branch keys in your application?.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
        PackageNameCheck packageNameCheck = new PackageNameCheck(this.integrationModel, branchAppConfig);
        result = packageNameCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(3, packageNameCheck.GetTestName(), result, packageNameCheck.GetOutput(this.context, result), packageNameCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "3. Verifying application package name", packageNameCheck.errorMessage, "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-branch-dashboard");
        URISchemeCheck uriSchemeCheck = new URISchemeCheck(this.integrationModel, branchAppConfig);
        result = uriSchemeCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(4, uriSchemeCheck.GetTestName(), result, uriSchemeCheck.GetOutput(this.context, result), uriSchemeCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "4. Checking Android Manifest for URI based deep link config", uriSchemeCheck.errorMessage, "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
        AppLinksCheck appLinksCheck = new AppLinksCheck(this.integrationModel, branchAppConfig);
        result = appLinksCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(5, appLinksCheck.GetTestName(), result, appLinksCheck.GetOutput(this.context, result), appLinksCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "5. Checking AndroidManifest for AppLink config.", "Could not find any App Link hosts to support Android AppLinks. Please add intent filter for handling AppLinks in your Android Manifest file", "https://help.branch.io/using-branch/docs/android-app-links#section-add-intent-filter-to-manifest");
        CustomDomainCheck customDomainCheck = new CustomDomainCheck(this.integrationModel, branchAppConfig);
        result = customDomainCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(6, customDomainCheck.GetTestName(), result, customDomainCheck.GetOutput(this.context, result), customDomainCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "6. Verifying any supported custom link domains.", String.format("Could not find intent filter to support custom link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", branchAppConfig.optString("short_url_domain")), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
        DefaultDomainsCheck defaultDomainsCheck = new DefaultDomainsCheck(this.integrationModel, branchAppConfig);
        result = defaultDomainsCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(7, defaultDomainsCheck.GetTestName(), result, defaultDomainsCheck.GetOutput(this.context, result), defaultDomainsCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "7. Verifying default link domains integrations.", String.format("Could not find intent filter to support Branch default link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", branchAppConfig.optString("default_short_url_domain")), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
        AlternateDomainsCheck alternateDomainsCheck = new AlternateDomainsCheck(this.integrationModel, branchAppConfig);
        result = alternateDomainsCheck.RunTests(this.context);
        this.integrationValidatorDialog.SetTestResultForRowItem(8, alternateDomainsCheck.GetTestName(), result, alternateDomainsCheck.GetOutput(this.context, result), alternateDomainsCheck.GetMoreInfoLink());
        this.logOutputForTest(result, "8. Verifying alternate link domains integrations.", String.format("Could not find intent filter to support alternate link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", branchAppConfig.optString("alternate_short_url_domain")), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
        this.finishTestingOutput();
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(Objects.requireNonNull(IntegrationValidator.instance.integrationValidatorDialog.getWindow()).getAttributes());
        lp.width = -1;
        lp.height = 1500;
        IntegrationValidator.instance.integrationValidatorDialog.show();
        IntegrationValidator.instance.integrationValidatorDialog.getWindow().setAttributes(lp);
    }

    @Override
    public void onAppConfigAvailable(JSONObject branchAppConfig) {
        if (branchAppConfig != null && !this.hasRan) {
            this.hasRan = true;
            this.doValidateWithAppConfig(branchAppConfig);
        } else if (branchAppConfig == null) {
            this.logIntegrationError("Unable to read Dashboard config. Please confirm that your Branch key is properly added to the manifest. Please fix your Dashboard settings.", "https://branch.app.link/link-settings-page");
        }
    }

    private void logIntegrationError(String message, String documentLink) {
        Log.d((String)"BranchSDK_Doctor", (String)("** ERROR ** : " + message + "\nPlease follow the link for more info " + documentLink));
    }

    private void logValidationProgress(String message) {
        Log.d((String)"BranchSDK_Doctor", (String)(message + " ... "));
    }

    private void logValidationPassed() {
        Log.d((String)"BranchSDK_Doctor", (String)"Passed");
    }

    private void logOutputForTest(boolean result, String progressMessage, String errorMessage, String documentLink) {
        this.logValidationProgress(progressMessage);
        if (result) {
            this.logValidationPassed();
        } else {
            this.logIntegrationError(errorMessage, documentLink);
            this.hasTestFailed = true;
        }
    }

    private void finishTestingOutput() {
        if (!this.hasTestFailed) {
            Log.d((String)"BranchSDK_Doctor", (String)"--------------------------------------------\nSuccessfully completed Branch integration validation. Everything looks good!");
            Log.d((String)"BranchSDK_Doctor", (String)"\n         Great! Comment out the 'validateSDKIntegration' line in your app. Next check your deep link routing.\n         Append '?bnc_validate=true' to any of your app's Branch links and click it on your mobile device (not the Simulator!) to start the test.\n         For instance, to validate a link like:\n         https://<yourapp>.app.link/NdJ6nFzRbK\n         click on:\n         https://<yourapp>.app.link/NdJ6nFzRbK?bnc_validate=true");
        } else {
            Log.d((String)"BranchSDK_Doctor", (String)"--------------------------------------------\nCompleted Branch integration validation. Almost there! Please correct the issues identified for your Branch SDK implementation.");
        }
    }
}

