/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import io.branch.referral.BranchAsyncTask;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

class BranchIntegrationModel {
    JSONObject deeplinkUriScheme;
    private final String branchKeyTest;
    private final String branchKeyLive;
    final List<String> applinkScheme;
    final String packageName;
    boolean appSettingsAvailable = false;

    public BranchIntegrationModel(Context context) {
        String liveKey = null;
        String testKey = null;
        this.applinkScheme = new ArrayList<String>();
        this.packageName = context.getPackageName();
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                liveKey = appInfo.metaData.getString("io.branch.sdk.BranchKey");
                testKey = appInfo.metaData.getString("io.branch.sdk.BranchKey.test");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.branchKeyLive = liveKey;
        this.branchKeyTest = testKey;
        this.updateDeepLinkSchemes(context);
    }

    private void updateDeepLinkSchemes(Context context) {
        JSONObject obj = null;
        try {
            obj = (JSONObject)new getDeepLinkSchemeTasks().executeTask(context).get(2500L, TimeUnit.MILLISECONDS);
            this.appSettingsAvailable = true;
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        if (obj != null) {
            this.deeplinkUriScheme = obj.optJSONObject(Defines.Jsonkey.URIScheme.getKey());
            JSONArray hostArray = obj.optJSONArray(Defines.Jsonkey.AppLinks.getKey());
            if (hostArray != null) {
                for (int i = 0; i < hostArray.length(); ++i) {
                    this.applinkScheme.add(hostArray.optString(i));
                }
            }
        }
    }

    private class getDeepLinkSchemeTasks
    extends BranchAsyncTask<Context, Void, JSONObject> {
        private getDeepLinkSchemeTasks() {
        }

        protected JSONObject doInBackground(Context ... contexts) {
            return BranchUtil.getDeepLinkSchemes(contexts[0]);
        }
    }
}

