/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.text.TextUtils;
import io.branch.referral.validators.BranchIntegrationModel;
import io.branch.referral.validators.IntegrationValidatorCheck;
import org.json.JSONObject;

public class AlternateDomainsCheck
extends IntegrationValidatorCheck {
    String name = "Alt Domains";
    String errorMessage = "Could not find intent filter to support alternate link domain. Please add intent filter for handling alternate link domain in your Android Manifest file";
    String moreInfoLink = "<a href=\"https://help.branch.io/developers-hub/docs/android-basic-integration#:~:text=The%20%2Dalternate.app.link%20domain%20associated%20with%20your%20app\">More info</a>";
    BranchIntegrationModel integrationModel;
    JSONObject branchAppConfig;

    public AlternateDomainsCheck(BranchIntegrationModel integrationModel, JSONObject branchAppConfig) {
        ((IntegrationValidatorCheck)this).name = this.name;
        ((IntegrationValidatorCheck)this).errorMessage = this.errorMessage;
        ((IntegrationValidatorCheck)this).moreInfoLink = this.moreInfoLink;
        this.integrationModel = integrationModel;
        this.branchAppConfig = branchAppConfig;
    }

    @Override
    public boolean RunTests(Context context) {
        String alternateAppLinkDomain = this.branchAppConfig.optString("alternate_short_url_domain");
        return TextUtils.isEmpty((CharSequence)alternateAppLinkDomain) || this.checkIfIntentAddedForLinkDomain(alternateAppLinkDomain);
    }

    @Override
    public String GetOutput(Context context, boolean didTestSucceed) {
        didTestSucceed = this.RunTests(context);
        return super.GetOutput(context, didTestSucceed);
    }

    private boolean checkIfIntentAddedForLinkDomain(String domainName) {
        boolean foundIntentFilterMatchingDomainName = false;
        if (!TextUtils.isEmpty((CharSequence)domainName)) {
            for (String host : this.integrationModel.applinkScheme) {
                if (!domainName.equals(host)) continue;
                foundIntentFilterMatchingDomainName = true;
                break;
            }
        }
        return foundIntentFilterMatchingDomainName;
    }
}

