/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.util;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import io.branch.referral.util.BranchContentSchema;
import io.branch.referral.util.CurrencyType;
import io.branch.referral.util.ProductCategory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentMetadata
implements Parcelable {
    BranchContentSchema contentSchema;
    public Double quantity;
    public Double price;
    public CurrencyType currencyType;
    public String sku;
    public String productName;
    public String productBrand;
    public ProductCategory productCategory;
    public CONDITION condition;
    public String productVariant;
    public Double rating;
    public Double ratingAverage;
    public Integer ratingCount;
    public Double ratingMax;
    public String addressStreet;
    public String addressCity;
    public String addressRegion;
    public String addressCountry;
    public String addressPostalCode;
    public Double latitude;
    public Double longitude;
    private final ArrayList<String> imageCaptions = new ArrayList();
    private final HashMap<String, String> customMetadata = new HashMap();
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public ContentMetadata createFromParcel(Parcel in) {
            return new ContentMetadata(in);
        }

        public ContentMetadata[] newArray(int size) {
            return new ContentMetadata[size];
        }
    };

    public ContentMetadata() {
    }

    public ContentMetadata addImageCaptions(String ... captions) {
        Collections.addAll(this.imageCaptions, captions);
        return this;
    }

    public ContentMetadata addCustomMetadata(String key, String value) {
        this.customMetadata.put(key, value);
        return this;
    }

    public ContentMetadata setContentSchema(BranchContentSchema contentSchema) {
        this.contentSchema = contentSchema;
        return this;
    }

    public ContentMetadata setQuantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    public ContentMetadata setAddress(@Nullable String street, @Nullable String city, @Nullable String region, @Nullable String country, @Nullable String postalCode) {
        this.addressStreet = street;
        this.addressCity = city;
        this.addressRegion = region;
        this.addressCountry = country;
        this.addressPostalCode = postalCode;
        return this;
    }

    public ContentMetadata setLocation(@Nullable Double latitude, @Nullable Double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        return this;
    }

    public ContentMetadata setRating(@Nullable Double rating, @Nullable Double averageRating, @Nullable Double maximumRating, @Nullable Integer ratingCount) {
        this.rating = rating;
        this.ratingAverage = averageRating;
        this.ratingMax = maximumRating;
        this.ratingCount = ratingCount;
        return this;
    }

    public ContentMetadata setRating(@Nullable Double averageRating, @Nullable Double maximumRating, @Nullable Integer ratingCount) {
        this.ratingAverage = averageRating;
        this.ratingMax = maximumRating;
        this.ratingCount = ratingCount;
        return this;
    }

    public ContentMetadata setPrice(Double price, @Nullable CurrencyType currency) {
        this.price = price;
        this.currencyType = currency;
        return this;
    }

    public ContentMetadata setProductBrand(String productBrand) {
        this.productBrand = productBrand;
        return this;
    }

    public ContentMetadata setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
        return this;
    }

    public ContentMetadata setProductCondition(CONDITION productCondition) {
        this.condition = productCondition;
        return this;
    }

    public ContentMetadata setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public ContentMetadata setProductVariant(String productVariant) {
        this.productVariant = productVariant;
        return this;
    }

    public ContentMetadata setSku(String sku) {
        this.sku = sku;
        return this;
    }

    public ArrayList<String> getImageCaptions() {
        return this.imageCaptions;
    }

    public HashMap<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public JSONObject convertToJson() {
        JSONObject metadataJson = new JSONObject();
        try {
            if (this.contentSchema != null) {
                metadataJson.put(Defines.Jsonkey.ContentSchema.getKey(), (Object)this.contentSchema.name());
            }
            if (this.quantity != null) {
                metadataJson.put(Defines.Jsonkey.Quantity.getKey(), (Object)this.quantity);
            }
            if (this.price != null) {
                metadataJson.put(Defines.Jsonkey.Price.getKey(), (Object)this.price);
            }
            if (this.currencyType != null) {
                metadataJson.put(Defines.Jsonkey.PriceCurrency.getKey(), (Object)this.currencyType.toString());
            }
            if (!TextUtils.isEmpty((CharSequence)this.sku)) {
                metadataJson.put(Defines.Jsonkey.SKU.getKey(), (Object)this.sku);
            }
            if (!TextUtils.isEmpty((CharSequence)this.productName)) {
                metadataJson.put(Defines.Jsonkey.ProductName.getKey(), (Object)this.productName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.productBrand)) {
                metadataJson.put(Defines.Jsonkey.ProductBrand.getKey(), (Object)this.productBrand);
            }
            if (this.productCategory != null) {
                metadataJson.put(Defines.Jsonkey.ProductCategory.getKey(), (Object)this.productCategory.getName());
            }
            if (this.condition != null) {
                metadataJson.put(Defines.Jsonkey.Condition.getKey(), (Object)this.condition.name());
            }
            if (!TextUtils.isEmpty((CharSequence)this.productVariant)) {
                metadataJson.put(Defines.Jsonkey.ProductVariant.getKey(), (Object)this.productVariant);
            }
            if (this.rating != null) {
                metadataJson.put(Defines.Jsonkey.Rating.getKey(), (Object)this.rating);
            }
            if (this.ratingAverage != null) {
                metadataJson.put(Defines.Jsonkey.RatingAverage.getKey(), (Object)this.ratingAverage);
            }
            if (this.ratingCount != null) {
                metadataJson.put(Defines.Jsonkey.RatingCount.getKey(), (Object)this.ratingCount);
            }
            if (this.ratingMax != null) {
                metadataJson.put(Defines.Jsonkey.RatingMax.getKey(), (Object)this.ratingMax);
            }
            if (!TextUtils.isEmpty((CharSequence)this.addressStreet)) {
                metadataJson.put(Defines.Jsonkey.AddressStreet.getKey(), (Object)this.addressStreet);
            }
            if (!TextUtils.isEmpty((CharSequence)this.addressCity)) {
                metadataJson.put(Defines.Jsonkey.AddressCity.getKey(), (Object)this.addressCity);
            }
            if (!TextUtils.isEmpty((CharSequence)this.addressRegion)) {
                metadataJson.put(Defines.Jsonkey.AddressRegion.getKey(), (Object)this.addressRegion);
            }
            if (!TextUtils.isEmpty((CharSequence)this.addressCountry)) {
                metadataJson.put(Defines.Jsonkey.AddressCountry.getKey(), (Object)this.addressCountry);
            }
            if (!TextUtils.isEmpty((CharSequence)this.addressPostalCode)) {
                metadataJson.put(Defines.Jsonkey.AddressPostalCode.getKey(), (Object)this.addressPostalCode);
            }
            if (this.latitude != null) {
                metadataJson.put(Defines.Jsonkey.Latitude.getKey(), (Object)this.latitude);
            }
            if (this.longitude != null) {
                metadataJson.put(Defines.Jsonkey.Longitude.getKey(), (Object)this.longitude);
            }
            if (this.imageCaptions.size() > 0) {
                JSONArray imageCaptionsArray = new JSONArray();
                metadataJson.put(Defines.Jsonkey.ImageCaptions.getKey(), (Object)imageCaptionsArray);
                for (String caption : this.imageCaptions) {
                    imageCaptionsArray.put((Object)caption);
                }
            }
            if (this.customMetadata.size() > 0) {
                for (String customDataKey : this.customMetadata.keySet()) {
                    metadataJson.put(customDataKey, (Object)this.customMetadata.get(customDataKey));
                }
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        return metadataJson;
    }

    public static ContentMetadata createFromJson(BranchUtil.JsonReader jsonReader) {
        ContentMetadata contentMetadata = new ContentMetadata();
        contentMetadata.contentSchema = BranchContentSchema.getValue(jsonReader.readOutString(Defines.Jsonkey.ContentSchema.getKey()));
        contentMetadata.quantity = jsonReader.readOutDouble(Defines.Jsonkey.Quantity.getKey(), null);
        contentMetadata.price = jsonReader.readOutDouble(Defines.Jsonkey.Price.getKey(), null);
        contentMetadata.currencyType = CurrencyType.getValue(jsonReader.readOutString(Defines.Jsonkey.PriceCurrency.getKey()));
        contentMetadata.sku = jsonReader.readOutString(Defines.Jsonkey.SKU.getKey());
        contentMetadata.productName = jsonReader.readOutString(Defines.Jsonkey.ProductName.getKey());
        contentMetadata.productBrand = jsonReader.readOutString(Defines.Jsonkey.ProductBrand.getKey());
        contentMetadata.productCategory = ProductCategory.getValue(jsonReader.readOutString(Defines.Jsonkey.ProductCategory.getKey()));
        contentMetadata.condition = CONDITION.getValue(jsonReader.readOutString(Defines.Jsonkey.Condition.getKey()));
        contentMetadata.productVariant = jsonReader.readOutString(Defines.Jsonkey.ProductVariant.getKey());
        contentMetadata.rating = jsonReader.readOutDouble(Defines.Jsonkey.Rating.getKey(), null);
        contentMetadata.ratingAverage = jsonReader.readOutDouble(Defines.Jsonkey.RatingAverage.getKey(), null);
        contentMetadata.ratingCount = jsonReader.readOutInt(Defines.Jsonkey.RatingCount.getKey(), null);
        contentMetadata.ratingMax = jsonReader.readOutDouble(Defines.Jsonkey.RatingMax.getKey(), null);
        contentMetadata.addressStreet = jsonReader.readOutString(Defines.Jsonkey.AddressStreet.getKey());
        contentMetadata.addressCity = jsonReader.readOutString(Defines.Jsonkey.AddressCity.getKey());
        contentMetadata.addressRegion = jsonReader.readOutString(Defines.Jsonkey.AddressRegion.getKey());
        contentMetadata.addressCountry = jsonReader.readOutString(Defines.Jsonkey.AddressCountry.getKey());
        contentMetadata.addressPostalCode = jsonReader.readOutString(Defines.Jsonkey.AddressPostalCode.getKey());
        contentMetadata.latitude = jsonReader.readOutDouble(Defines.Jsonkey.Latitude.getKey(), null);
        contentMetadata.longitude = jsonReader.readOutDouble(Defines.Jsonkey.Longitude.getKey(), null);
        JSONArray imageCaptionJsonArray = jsonReader.readOutJsonArray(Defines.Jsonkey.ImageCaptions.getKey());
        if (imageCaptionJsonArray != null) {
            for (int i = 0; i < imageCaptionJsonArray.length(); ++i) {
                contentMetadata.imageCaptions.add(imageCaptionJsonArray.optString(i));
            }
        }
        try {
            JSONObject customFieldsObj = jsonReader.getJsonObject();
            Iterator keys = customFieldsObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                contentMetadata.customMetadata.put(key, customFieldsObj.optString(key));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return contentMetadata;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.contentSchema != null ? this.contentSchema.name() : "");
        dest.writeSerializable((Serializable)this.quantity);
        dest.writeSerializable((Serializable)this.price);
        dest.writeString(this.currencyType != null ? this.currencyType.name() : "");
        dest.writeString(this.sku);
        dest.writeString(this.productName);
        dest.writeString(this.productBrand);
        dest.writeString(this.productCategory != null ? this.productCategory.getName() : "");
        dest.writeString(this.condition != null ? this.condition.name() : "");
        dest.writeString(this.productVariant);
        dest.writeSerializable((Serializable)this.rating);
        dest.writeSerializable((Serializable)this.ratingAverage);
        dest.writeSerializable((Serializable)this.ratingCount);
        dest.writeSerializable((Serializable)this.ratingMax);
        dest.writeString(this.addressStreet);
        dest.writeString(this.addressCity);
        dest.writeString(this.addressRegion);
        dest.writeString(this.addressCountry);
        dest.writeString(this.addressPostalCode);
        dest.writeSerializable((Serializable)this.latitude);
        dest.writeSerializable((Serializable)this.longitude);
        dest.writeSerializable(this.imageCaptions);
        dest.writeSerializable(this.customMetadata);
    }

    private ContentMetadata(Parcel in) {
        this();
        this.contentSchema = BranchContentSchema.getValue(in.readString());
        this.quantity = (Double)in.readSerializable();
        this.price = (Double)in.readSerializable();
        this.currencyType = CurrencyType.getValue(in.readString());
        this.sku = in.readString();
        this.productName = in.readString();
        this.productBrand = in.readString();
        this.productCategory = ProductCategory.getValue(in.readString());
        this.condition = CONDITION.getValue(in.readString());
        this.productVariant = in.readString();
        this.rating = (Double)in.readSerializable();
        this.ratingAverage = (Double)in.readSerializable();
        this.ratingCount = (Integer)in.readSerializable();
        this.ratingMax = (Double)in.readSerializable();
        this.addressStreet = in.readString();
        this.addressCity = in.readString();
        this.addressRegion = in.readString();
        this.addressCountry = in.readString();
        this.addressPostalCode = in.readString();
        this.latitude = (Double)in.readSerializable();
        this.longitude = (Double)in.readSerializable();
        ArrayList imageCaptionsTemp = (ArrayList)in.readSerializable();
        this.imageCaptions.addAll(imageCaptionsTemp);
        HashMap tempCustomMetadata = (HashMap)in.readSerializable();
        this.customMetadata.putAll(tempCustomMetadata);
    }

    public static enum CONDITION {
        OTHER,
        NEW,
        GOOD,
        FAIR,
        POOR,
        USED,
        REFURBISHED,
        EXCELLENT;


        public static CONDITION getValue(String name) {
            CONDITION conditionResult = null;
            if (!TextUtils.isEmpty((CharSequence)name)) {
                for (CONDITION condition : CONDITION.values()) {
                    if (!condition.name().equalsIgnoreCase(name)) continue;
                    conditionResult = condition;
                    break;
                }
            }
            return conditionResult;
        }
    }
}

