/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.net.TrafficStats;
import android.text.TextUtils;
import io.branch.referral.BranchAsyncTask;
import io.branch.referral.BranchLogger;
import io.branch.referral.PrefHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class UniversalResourceAnalyser {
    private static JSONObject skipURLFormats;
    private final ArrayList<String> acceptURLFormats;
    private static final String SKIP_URL_FORMATS_KEY = "skip_url_format_key";
    private static final String VERSION_KEY = "version";
    private static final String SKIP_LIST_KEY = "uri_skip_list";
    private static final String UPDATE_URL_PATH = "%sdk/uriskiplist_v#.json";
    private final JSONObject DEFAULT_SKIP_URL_LIST = new JSONObject();
    private static UniversalResourceAnalyser instance;

    public static UniversalResourceAnalyser getInstance(Context context) {
        if (instance == null) {
            instance = new UniversalResourceAnalyser(context);
        }
        return instance;
    }

    private UniversalResourceAnalyser(Context context) {
        try {
            this.DEFAULT_SKIP_URL_LIST.putOpt(VERSION_KEY, (Object)0);
            JSONArray skipURIArray = new JSONArray();
            this.DEFAULT_SKIP_URL_LIST.putOpt(SKIP_LIST_KEY, (Object)skipURIArray);
            skipURIArray.put((Object)"^fb\\d+:((?!campaign_ids).)*$");
            skipURIArray.put((Object)"^li\\d+:");
            skipURIArray.put((Object)"^pdk\\d+:");
            skipURIArray.put((Object)"^twitterkit-.*:");
            skipURIArray.put((Object)"^com\\.googleusercontent\\.apps\\.\\d+-.*:\\/oauth");
            skipURIArray.put((Object)"^(?i)(?!(http|https):).*(:|:.*\\b)(password|o?auth|o?auth.?token|access|access.?token)\\b");
            skipURIArray.put((Object)"^(?i)((http|https):\\/\\/).*[\\/|?|#].*\\b(password|o?auth|o?auth.?token|access|access.?token)\\b");
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
        skipURLFormats = this.retrieveSkipURLFormats(context);
        this.acceptURLFormats = new ArrayList();
    }

    private JSONObject retrieveSkipURLFormats(Context context) {
        PrefHelper prefHelper = PrefHelper.getInstance(context);
        JSONObject urlFormat = new JSONObject();
        String latestUrlFormats = prefHelper.getString(SKIP_URL_FORMATS_KEY);
        if (TextUtils.isEmpty((CharSequence)latestUrlFormats) || "bnc_no_value".equals(latestUrlFormats)) {
            urlFormat = this.DEFAULT_SKIP_URL_LIST;
        } else {
            try {
                urlFormat = new JSONObject(latestUrlFormats);
            }
            catch (JSONException e) {
                BranchLogger.d(e.getMessage());
            }
        }
        return urlFormat;
    }

    void addToSkipURLFormats(String skipURLFormat) {
        JSONArray skipURLArray = skipURLFormats.optJSONArray(SKIP_LIST_KEY);
        try {
            if (skipURLArray == null) {
                skipURLArray = new JSONArray();
                skipURLFormats.put(SKIP_LIST_KEY, (Object)skipURLArray);
            }
            skipURLArray.put((Object)skipURLFormat);
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
    }

    void addToAcceptURLFormats(String acceptUrl) {
        this.acceptURLFormats.add(acceptUrl);
    }

    void addToAcceptURLFormats(List<String> acceptUrls) {
        this.acceptURLFormats.addAll(acceptUrls);
    }

    void checkAndUpdateSkipURLFormats(Context context) {
        try {
            new UrlSkipListUpdateTask(context).executeTask(new Void[0]);
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
    }

    String getStrippedURL(String url) {
        String strippedURL;
        block8: {
            strippedURL = null;
            try {
                JSONArray skipURLArray = skipURLFormats.optJSONArray(SKIP_LIST_KEY);
                if (skipURLArray != null) {
                    for (int i = 0; i < skipURLArray.length(); ++i) {
                        try {
                            String skipPattern = skipURLArray.getString(i);
                            Pattern p = Pattern.compile(skipPattern);
                            Matcher m = p.matcher(url);
                            if (!m.find()) continue;
                            strippedURL = skipPattern;
                            break;
                        }
                        catch (JSONException e) {
                            BranchLogger.d(e.getMessage());
                        }
                    }
                }
                if (strippedURL != null) break block8;
                if (this.acceptURLFormats.size() > 0) {
                    for (String skipPattern : this.acceptURLFormats) {
                        if (!url.matches(skipPattern)) continue;
                        strippedURL = url;
                        break block8;
                    }
                    break block8;
                }
                strippedURL = url;
            }
            catch (Exception ex) {
                strippedURL = url;
            }
        }
        return strippedURL;
    }

    private static class UrlSkipListUpdateTask
    extends BranchAsyncTask<Void, Void, JSONObject> {
        private final PrefHelper prefHelper;
        private final int TIME_OUT = 1500;

        private UrlSkipListUpdateTask(Context context) {
            this.prefHelper = PrefHelper.getInstance(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(Void ... params) {
            TrafficStats.setThreadStatsTag((int)0);
            JSONObject respObject = new JSONObject();
            HttpURLConnection connection = null;
            try {
                String update_url_path = UniversalResourceAnalyser.UPDATE_URL_PATH.replace("%", PrefHelper.getCDNBaseUrl());
                URL urlObject = new URL(update_url_path.replace("#", Integer.toString(skipURLFormats.optInt(UniversalResourceAnalyser.VERSION_KEY) + 1)));
                connection = (HttpsURLConnection)urlObject.openConnection();
                connection.setConnectTimeout(1500);
                connection.setReadTimeout(1500);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200 && connection.getInputStream() != null) {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    respObject = new JSONObject(rd.readLine());
                }
            }
            catch (Exception e) {
                BranchLogger.d(e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return respObject;
        }

        protected void onPostExecute(JSONObject updatedURLFormatsObj) {
            super.onPostExecute((Object)updatedURLFormatsObj);
            if (updatedURLFormatsObj.optInt(UniversalResourceAnalyser.VERSION_KEY) > skipURLFormats.optInt(UniversalResourceAnalyser.VERSION_KEY)) {
                skipURLFormats = updatedURLFormatsObj;
                this.prefHelper.setString(UniversalResourceAnalyser.SKIP_URL_FORMATS_KEY, skipURLFormats.toString());
            }
        }
    }
}

