/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.PrefHelper;
import org.json.JSONObject;

public class TrackingController {
    private boolean trackingDisabled = true;

    TrackingController(Context context) {
        this.updateTrackingState(context);
    }

    void disableTracking(Context context, boolean disableTracking, @Nullable Branch.TrackingStateCallback callback) {
        BranchLogger.v("disableTracking context: " + context + " disableTracking: " + disableTracking + " callback: " + callback);
        if (this.trackingDisabled == disableTracking) {
            if (callback != null) {
                BranchLogger.v("Tracking state is already set to " + disableTracking + ". Returning the same to the callback");
                callback.onTrackingStateChanged(this.trackingDisabled, Branch.getInstance().getFirstReferringParams(), null);
            }
            return;
        }
        this.trackingDisabled = disableTracking;
        PrefHelper.getInstance(context).setBool("bnc_tracking_state", disableTracking);
        if (disableTracking) {
            BranchLogger.v("Tracking disabled. Clearing all pending requests");
            this.onTrackingDisabled(context);
            if (callback != null) {
                callback.onTrackingStateChanged(true, null, null);
            }
        } else {
            BranchLogger.v("Tracking enabled. Registering app init");
            this.onTrackingEnabled((referringParams, error) -> {
                if (callback != null) {
                    callback.onTrackingStateChanged(false, referringParams, error);
                }
            });
        }
    }

    boolean isTrackingDisabled() {
        return this.trackingDisabled;
    }

    public static boolean isTrackingDisabled(@NonNull Context context) {
        return PrefHelper.getInstance(context).getBool("bnc_tracking_state");
    }

    void updateTrackingState(Context context) {
        this.trackingDisabled = PrefHelper.getInstance(context).getBool("bnc_tracking_state");
    }

    private void onTrackingDisabled(Context context) {
        Branch.getInstance().clearPendingRequests();
        PrefHelper prefHelper = PrefHelper.getInstance(context);
        prefHelper.setSessionID("bnc_no_value");
        prefHelper.setLinkClickID("bnc_no_value");
        prefHelper.setLinkClickIdentifier("bnc_no_value");
        prefHelper.setAppLink("bnc_no_value");
        prefHelper.setInstallReferrerParams("bnc_no_value");
        prefHelper.setAppStoreReferrer("bnc_no_value");
        prefHelper.setAppStoreSource("bnc_no_value");
        prefHelper.setGoogleSearchInstallIdentifier("bnc_no_value");
        prefHelper.setInitialReferrer("bnc_no_value");
        prefHelper.setExternalIntentUri("bnc_no_value");
        prefHelper.setExternalIntentExtra("bnc_no_value");
        prefHelper.setSessionParams("bnc_no_value");
        prefHelper.setAnonID("bnc_no_value");
        prefHelper.setReferringUrlQueryParameters(new JSONObject());
        Branch.getInstance().clearPartnerParameters();
    }

    private void onTrackingEnabled(Branch.BranchReferralInitListener callback) {
        BranchLogger.v("onTrackingEnabled callback: " + callback);
        Branch branch = Branch.getInstance();
        if (branch != null) {
            branch.registerAppInit(branch.getInstallOrOpenRequest(callback, true), false);
        }
    }
}

