/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerRequestLogEvent
extends ServerRequest {
    public ServerRequestLogEvent(Context context, Defines.RequestPath requestPath, String eventName, HashMap<String, Object> topLevelProperties, JSONObject standardProperties, JSONObject customProperties, List<BranchUniversalObject> buoList) {
        super(context, requestPath);
        JSONObject reqBody = new JSONObject();
        try {
            reqBody.put(Defines.Jsonkey.Name.getKey(), (Object)eventName);
            if (customProperties.length() > 0) {
                reqBody.put(Defines.Jsonkey.CustomData.getKey(), (Object)customProperties);
            }
            if (standardProperties.length() > 0) {
                reqBody.put(Defines.Jsonkey.EventData.getKey(), (Object)standardProperties);
            }
            if (topLevelProperties.size() > 0) {
                for (Map.Entry<String, Object> entry : topLevelProperties.entrySet()) {
                    reqBody.put(entry.getKey(), entry.getValue());
                }
            }
            if (buoList.size() > 0) {
                JSONArray contentItemsArray = new JSONArray();
                reqBody.put(Defines.Jsonkey.ContentItems.getKey(), (Object)contentItemsArray);
                for (BranchUniversalObject buo : buoList) {
                    contentItemsArray.put((Object)buo.convertToJson());
                }
            }
            this.setPost(reqBody);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        this.updateEnvironment(context, reqBody);
    }

    @Override
    protected void setPost(JSONObject post) throws JSONException {
        super.setPost(post);
        this.prefHelper_.loadPartnerParams(post);
    }

    @Override
    public boolean handleErrors(Context context) {
        return false;
    }

    @Override
    public void onRequestSucceeded(ServerResponse response, Branch branch) {
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
    }

    @Override
    public ServerRequest.BRANCH_API_VERSION getBranchRemoteAPIVersion() {
        return ServerRequest.BRANCH_API_VERSION.V2;
    }

    @Override
    protected boolean shouldUpdateLimitFacebookTracking() {
        return true;
    }

    @Override
    protected boolean shouldAddDMAParams() {
        return true;
    }

    @Override
    public boolean shouldRetryOnFail() {
        return false;
    }
}

