/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.PrefHelper;
import io.branch.referral.ReferringUrlUtility;
import io.branch.referral.ServerRequestCreateUrl;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerRequestLogEvent;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerRequestRegisterOpen;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ServerRequest {
    private static final Defines.RequestPath[] initializationAndEventRoutes = new Defines.RequestPath[]{Defines.RequestPath.RegisterInstall, Defines.RequestPath.RegisterOpen, Defines.RequestPath.ContentEvent, Defines.RequestPath.TrackStandardEvent, Defines.RequestPath.TrackCustomEvent};
    private static final String POST_KEY = "REQ_POST";
    private static final String POST_PATH_KEY = "REQ_POST_PATH";
    protected long creation_ts = 0L;
    protected String uuid;
    private JSONObject params_;
    final Defines.RequestPath requestPath_;
    protected final PrefHelper prefHelper_;
    private long queueWaitTime_ = 0L;
    private final Context context_;
    private final Set<PROCESS_WAIT_LOCK> locks_;
    public boolean constructError_ = false;
    public int currentRetryCount = 0;

    public ServerRequest(Context context, Defines.RequestPath requestPath) {
        this(requestPath, new JSONObject(), context);
    }

    protected ServerRequest(Defines.RequestPath requestPath, JSONObject post, Context context) {
        BranchLogger.v("ServerRequest constructor");
        this.context_ = context;
        this.requestPath_ = requestPath;
        this.params_ = post;
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.locks_ = new HashSet<PROCESS_WAIT_LOCK>();
        this.creation_ts = System.currentTimeMillis();
        String creation_ts_date_formatted = this.formatUnixEpochToDateFormat(this.creation_ts);
        this.uuid = this.getRequestUuid(creation_ts_date_formatted);
    }

    private String formatUnixEpochToDateFormat(long creationTs) {
        SimpleDateFormat sdf = new SimpleDateFormat("-yyyyMMddHH", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(creationTs);
    }

    private String getRequestUuid(String creationTsDateFormatted) {
        return UUID.randomUUID().toString() + creationTsDateFormatted;
    }

    public abstract boolean handleErrors(Context var1);

    public abstract void onRequestSucceeded(ServerResponse var1, Branch var2);

    public abstract void handleFailure(int var1, String var2);

    public abstract boolean isGetRequest();

    public abstract void clearCallbacks();

    public boolean shouldRetryOnFail() {
        return false;
    }

    protected boolean shouldUpdateLimitFacebookTracking() {
        return false;
    }

    protected boolean shouldAddDMAParams() {
        return false;
    }

    void addDMAParams() {
        if (this.prefHelper_.isDMAParamsInitialized()) {
            try {
                BRANCH_API_VERSION version = this.getBranchRemoteAPIVersion();
                if (version == BRANCH_API_VERSION.V1) {
                    this.params_.put(Defines.Jsonkey.DMA_EEA.getKey(), this.prefHelper_.getEEARegion());
                    this.params_.put(Defines.Jsonkey.DMA_Ad_Personalization.getKey(), this.prefHelper_.getAdPersonalizationConsent());
                    this.params_.put(Defines.Jsonkey.DMA_Ad_User_Data.getKey(), this.prefHelper_.getAdUserDataUsageConsent());
                } else {
                    JSONObject userDataObj = this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey());
                    if (userDataObj != null) {
                        userDataObj.put(Defines.Jsonkey.DMA_EEA.getKey(), this.prefHelper_.getEEARegion());
                        userDataObj.put(Defines.Jsonkey.DMA_Ad_Personalization.getKey(), this.prefHelper_.getAdPersonalizationConsent());
                        userDataObj.put(Defines.Jsonkey.DMA_Ad_User_Data.getKey(), this.prefHelper_.getAdUserDataUsageConsent());
                    }
                }
            }
            catch (JSONException e) {
                BranchLogger.d(e.getMessage());
            }
        }
    }

    private void addConsumerProtectionAttributionLevel() {
        if (this.prefHelper_.isAttributionLevelInitialized()) {
            try {
                if (this.getBranchRemoteAPIVersion() == BRANCH_API_VERSION.V1) {
                    this.params_.put(Defines.Jsonkey.Consumer_Protection_Attribution_Level.getKey(), (Object)this.prefHelper_.getConsumerProtectionAttributionLevel().toString());
                } else {
                    JSONObject userDataObj = this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey());
                    if (userDataObj != null) {
                        userDataObj.put(Defines.Jsonkey.Consumer_Protection_Attribution_Level.getKey(), (Object)this.prefHelper_.getConsumerProtectionAttributionLevel().toString());
                    }
                }
            }
            catch (JSONException e) {
                BranchLogger.d(e.getMessage());
            }
        }
    }

    public final String getRequestPath() {
        return this.requestPath_.getPath();
    }

    public String getRequestUrl() {
        return this.prefHelper_.getAPIBaseUrl() + this.requestPath_.getPath();
    }

    protected void setPost(JSONObject post) throws JSONException {
        BranchLogger.v("setPost " + post);
        this.params_ = post;
        if (this.getBranchRemoteAPIVersion() == BRANCH_API_VERSION.V1) {
            DeviceInfo.getInstance().updateRequestWithV1Params(this, this.params_);
        } else {
            JSONObject userDataObj = new JSONObject();
            this.params_.put(Defines.Jsonkey.UserData.getKey(), (Object)userDataObj);
            DeviceInfo.getInstance().updateRequestWithV2Params(this, this.prefHelper_, userDataObj);
        }
        this.params_.put(Defines.Jsonkey.Debug.getKey(), Branch.isDeviceIDFetchDisabled());
    }

    public JSONObject getPost() {
        return this.params_;
    }

    public boolean isGAdsParamsRequired() {
        return true;
    }

    public JSONObject getPostWithInstrumentationValues(ConcurrentHashMap<String, String> instrumentationData) {
        JSONObject extendedPost = new JSONObject();
        try {
            Object key;
            Object keys;
            if (this.params_ != null) {
                JSONObject originalParams = new JSONObject(this.params_.toString());
                keys = originalParams.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    extendedPost.put((String)key, originalParams.get((String)key));
                }
            }
            if (instrumentationData.size() > 0) {
                JSONObject instrObj = new JSONObject();
                keys = instrumentationData.keySet();
                try {
                    key = keys.iterator();
                    while (key.hasNext()) {
                        String key2 = (String)key.next();
                        instrObj.put(key2, (Object)instrumentationData.get(key2));
                        instrumentationData.remove(key2);
                    }
                    extendedPost.put(Defines.Jsonkey.Branch_Instrumentation.getKey(), (Object)instrObj);
                }
                catch (JSONException e) {
                    BranchLogger.w("Caught JSONException " + e.getMessage());
                }
            }
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
        catch (ConcurrentModificationException ex) {
            extendedPost = this.params_;
        }
        catch (Exception e) {
            BranchLogger.v("ServerRequest " + this + " getPostWithInstrumentationValues caught exception: " + e.getMessage());
        }
        return extendedPost;
    }

    public JSONObject getGetParams() {
        return this.params_;
    }

    protected void addGetParam(String paramKey, String paramValue) {
        try {
            this.params_.put(paramKey, (Object)paramValue);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
    }

    @CallSuper
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put(POST_KEY, (Object)this.params_);
            json.put(POST_PATH_KEY, (Object)this.requestPath_.getPath());
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
            return null;
        }
        return json;
    }

    public static ServerRequest fromJSON(JSONObject json, Context context) {
        JSONObject post = null;
        String requestPath = "";
        boolean initiatedByClient = true;
        try {
            if (json.has(POST_KEY)) {
                post = json.getJSONObject(POST_KEY);
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        try {
            if (json.has(POST_PATH_KEY)) {
                requestPath = json.getString(POST_PATH_KEY);
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        try {
            if (json.has("INITIATED_BY_CLIENT")) {
                initiatedByClient = json.getBoolean("INITIATED_BY_CLIENT");
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)requestPath)) {
            return ServerRequest.getExtendedServerRequest(requestPath, post, context, initiatedByClient);
        }
        return null;
    }

    private static ServerRequest getExtendedServerRequest(String requestPath, JSONObject post, Context context, boolean initiatedByClient) {
        ServerRequest extendedReq = null;
        if (requestPath.equalsIgnoreCase(Defines.RequestPath.GetURL.getPath())) {
            extendedReq = new ServerRequestCreateUrl(Defines.RequestPath.GetURL, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RegisterInstall.getPath())) {
            extendedReq = new ServerRequestRegisterInstall(Defines.RequestPath.RegisterInstall, post, context, initiatedByClient);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RegisterOpen.getPath())) {
            extendedReq = new ServerRequestRegisterOpen(Defines.RequestPath.RegisterOpen, post, context, initiatedByClient);
        }
        return extendedReq;
    }

    void updateGAdsParams() {
        BRANCH_API_VERSION version = this.getBranchRemoteAPIVersion();
        int LATVal = DeviceInfo.getInstance().getSystemObserver().getLATVal();
        String gaid = DeviceInfo.getInstance().getSystemObserver().getAID();
        if (!(TextUtils.isEmpty((CharSequence)gaid) || this.prefHelper_.getConsumerProtectionAttributionLevel() != Defines.BranchAttributionLevel.FULL && this.prefHelper_.isAttributionLevelInitialized())) {
            this.updateAdvertisingIdsObject(gaid);
            this.replaceHardwareIdOnValidAdvertisingId();
        }
        try {
            if (version == BRANCH_API_VERSION.V1) {
                this.params_.put(Defines.Jsonkey.LATVal.getKey(), LATVal);
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    if (!(SystemObserver.isHuaweiMobileServicesAvailable(this.context_) || this.prefHelper_.getConsumerProtectionAttributionLevel() != Defines.BranchAttributionLevel.FULL && this.prefHelper_.isAttributionLevelInitialized())) {
                        this.params_.put(Defines.Jsonkey.GoogleAdvertisingID.getKey(), (Object)gaid);
                    }
                    this.params_.remove(Defines.Jsonkey.UnidentifiedDevice.getKey());
                } else if (!this.payloadContainsDeviceIdentifiers(this.params_) && !this.params_.optBoolean(Defines.Jsonkey.UnidentifiedDevice.getKey())) {
                    this.params_.put(Defines.Jsonkey.UnidentifiedDevice.getKey(), true);
                }
            } else {
                JSONObject userDataObj = this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey());
                if (userDataObj != null) {
                    userDataObj.put(Defines.Jsonkey.LimitedAdTracking.getKey(), LATVal);
                    if (!TextUtils.isEmpty((CharSequence)gaid)) {
                        if (!(SystemObserver.isHuaweiMobileServicesAvailable(this.context_) || this.prefHelper_.getConsumerProtectionAttributionLevel() != Defines.BranchAttributionLevel.FULL && this.prefHelper_.isAttributionLevelInitialized())) {
                            userDataObj.put(Defines.Jsonkey.AAID.getKey(), (Object)gaid);
                        }
                        userDataObj.remove(Defines.Jsonkey.UnidentifiedDevice.getKey());
                    } else if (!this.payloadContainsDeviceIdentifiers(userDataObj) && !userDataObj.optBoolean(Defines.Jsonkey.UnidentifiedDevice.getKey())) {
                        userDataObj.put(Defines.Jsonkey.UnidentifiedDevice.getKey(), true);
                    }
                }
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
    }

    private void updateAdvertisingIdsObject(@NonNull String aid) {
        try {
            String key = SystemObserver.isFireOSDevice() ? Defines.Jsonkey.FireAdId.getKey() : (SystemObserver.isHuaweiMobileServicesAvailable(Branch.getInstance().getApplicationContext()) ? Defines.Jsonkey.OpenAdvertisingID.getKey() : Defines.Jsonkey.AAID.getKey());
            JSONObject advertisingIdsObject = new JSONObject().put(key, (Object)aid);
            this.params_.put(Defines.Jsonkey.AdvertisingIDs.getKey(), (Object)advertisingIdsObject);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
    }

    private void replaceHardwareIdOnValidAdvertisingId() {
        try {
            JSONObject userData;
            SystemObserver.UniqueId generatedHardwareID = DeviceInfo.getInstance().getHardwareID();
            this.params_.put(Defines.Jsonkey.HardwareID.getKey(), (Object)generatedHardwareID.getId());
            this.params_.put(Defines.Jsonkey.IsHardwareIDReal.getKey(), generatedHardwareID.isReal());
            if (this.params_.has(Defines.Jsonkey.UserData.getKey()) && (userData = this.params_.getJSONObject(Defines.Jsonkey.UserData.getKey())).has(Defines.Jsonkey.AndroidID.getKey())) {
                userData.put(Defines.Jsonkey.AndroidID.getKey(), (Object)generatedHardwareID.getId());
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
    }

    private boolean payloadContainsDeviceIdentifiers(JSONObject payload) {
        return payload.has(Defines.Jsonkey.AndroidID.getKey()) || payload.has(Defines.Jsonkey.RandomizedDeviceToken.getKey());
    }

    private void updateDeviceInfo() {
        JSONObject userDataObj;
        BRANCH_API_VERSION version = this.getBranchRemoteAPIVersion();
        if (version == BRANCH_API_VERSION.V2 && (userDataObj = this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey())) != null) {
            try {
                userDataObj.put(Defines.Jsonkey.DeveloperIdentity.getKey(), (Object)this.prefHelper_.getIdentity());
                userDataObj.put(Defines.Jsonkey.RandomizedDeviceToken.getKey(), (Object)this.prefHelper_.getRandomizedDeviceToken());
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
    }

    private void updateRequestMetadata() {
        try {
            String key;
            JSONObject metadata = new JSONObject();
            Iterator i = this.prefHelper_.getRequestMetadata().keys();
            while (i.hasNext()) {
                String k = (String)i.next();
                metadata.put(k, this.prefHelper_.getRequestMetadata().get(k));
            }
            JSONObject originalMetadata = this.params_.optJSONObject(Defines.Jsonkey.Metadata.getKey());
            if (originalMetadata != null) {
                Iterator postIter = originalMetadata.keys();
                while (postIter.hasNext()) {
                    key = (String)postIter.next();
                    metadata.put(key, originalMetadata.get(key));
                }
            }
            if (this instanceof ServerRequestRegisterInstall && this.prefHelper_.getInstallMetadata().length() > 0) {
                Iterator postIterInstallMetaData = this.prefHelper_.getInstallMetadata().keys();
                while (postIterInstallMetaData.hasNext()) {
                    key = (String)postIterInstallMetaData.next();
                    this.params_.putOpt(key, this.prefHelper_.getInstallMetadata().get(key));
                }
            }
            this.params_.put(Defines.Jsonkey.Metadata.getKey(), (Object)metadata);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException. Could not merge metadata, ignoring user metadata. " + e.getMessage());
        }
    }

    private void updateLimitFacebookTracking() {
        boolean isLimitFacebookTracking;
        JSONObject updateJson;
        JSONObject jSONObject = updateJson = this.getBranchRemoteAPIVersion() == BRANCH_API_VERSION.V1 ? this.params_ : this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey());
        if (updateJson != null && (isLimitFacebookTracking = this.prefHelper_.isAppTrackingLimited())) {
            try {
                updateJson.putOpt(Defines.Jsonkey.limitFacebookTracking.getKey(), (Object)isLimitFacebookTracking);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
    }

    private void updateDisableAdNetworkCallouts() {
        boolean disableAdNetworkCallouts;
        JSONObject updateJson;
        JSONObject jSONObject = updateJson = this.getBranchRemoteAPIVersion() == BRANCH_API_VERSION.V1 ? this.params_ : this.params_.optJSONObject(Defines.Jsonkey.UserData.getKey());
        if (updateJson != null && (disableAdNetworkCallouts = this.prefHelper_.getAdNetworkCalloutsDisabled())) {
            try {
                updateJson.putOpt(Defines.Jsonkey.DisableAdNetworkCallouts.getKey(), (Object)disableAdNetworkCallouts);
            }
            catch (JSONException e) {
                BranchLogger.w("Caught JSONException " + e.getMessage());
            }
        }
    }

    private boolean prioritizeLinkAttribution(JSONObject params) {
        return Branch.isReferringLinkAttributionForPreinstalledAppsEnabled() && params.has(Defines.Jsonkey.LinkIdentifier.getKey());
    }

    private void removePreinstallData(JSONObject params) {
        params.remove(Defines.PreinstallKey.partner.getKey());
        params.remove(Defines.PreinstallKey.campaign.getKey());
        params.remove(Defines.Jsonkey.GooglePlayInstallReferrer.getKey());
    }

    void doFinalUpdateOnMainThread() {
        BranchLogger.v("doFinalUpdateOnMainThread");
        this.updateRequestMetadata();
        if (this.shouldUpdateLimitFacebookTracking()) {
            this.updateLimitFacebookTracking();
        }
        if (this.shouldAddDMAParams()) {
            this.addDMAParams();
        }
        this.addConsumerProtectionAttributionLevel();
        this.addClientRequestParameters();
    }

    private void addClientRequestParameters() {
        if (this.prefHelper_ != null) {
            try {
                this.params_.put(Defines.Jsonkey.Branch_Sdk_Request_Creation_Time_Stamp.getKey(), this.creation_ts);
                this.params_.put(Defines.Jsonkey.Branch_Sdk_Request_Uuid.getKey(), (Object)this.uuid);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void doFinalUpdateOnBackgroundThread() {
        BranchLogger.v("doFinalUpdateOnBackgroundThread");
        if (this instanceof ServerRequestInitSession) {
            ((ServerRequestInitSession)this).updateLinkReferrerParams();
            if (this.prioritizeLinkAttribution(this.params_)) {
                this.removePreinstallData(this.params_);
            }
        }
        this.updateDeviceInfo();
        this.updateDisableAdNetworkCallouts();
        if (this.isGAdsParamsRequired()) {
            this.updateGAdsParams();
        }
    }

    protected boolean doesAppHasInternetPermission(Context context) {
        boolean permissionGranted;
        int result = context.checkCallingOrSelfPermission("android.permission.INTERNET");
        boolean bl = permissionGranted = result == 0;
        if (!permissionGranted) {
            BranchLogger.v("Trouble executing your request. Please add 'android.permission.INTERNET' in your applications manifest file");
        }
        return result == 0;
    }

    public void onRequestQueued() {
        this.queueWaitTime_ = System.currentTimeMillis();
    }

    public long getQueueWaitTime() {
        long waitTime = 0L;
        if (this.queueWaitTime_ > 0L) {
            waitTime = System.currentTimeMillis() - this.queueWaitTime_;
        }
        return waitTime;
    }

    public void addProcessWaitLock(PROCESS_WAIT_LOCK lock) {
        if (lock != null) {
            this.locks_.add(lock);
        }
    }

    public void removeProcessWaitLock(PROCESS_WAIT_LOCK lock) {
        this.locks_.remove((Object)lock);
    }

    public String printWaitLocks() {
        return Arrays.toString(this.locks_.toArray());
    }

    public boolean isWaitingOnProcessToFinish() {
        return this.locks_.size() > 0;
    }

    public void onPreExecute() {
        BranchLogger.v("onPreExecute " + this);
        if (this instanceof ServerRequestRegisterOpen || this instanceof ServerRequestLogEvent) {
            try {
                ReferringUrlUtility utility = new ReferringUrlUtility(this.prefHelper_);
                String externalIntentUri = this.prefHelper_.getExternalIntentUri();
                utility.parseReferringURL(externalIntentUri);
                if (this.prefHelper_.getConsumerProtectionAttributionLevel() == Defines.BranchAttributionLevel.FULL || !this.prefHelper_.isAttributionLevelInitialized()) {
                    JSONObject urlQueryParams = utility.getURLQueryParamsForRequest(this);
                    Iterator it = urlQueryParams.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        this.params_.put(key, urlQueryParams.get(key));
                    }
                }
            }
            catch (Exception e) {
                BranchLogger.e("Caught exception in onPreExecute: " + e.getMessage() + " stacktrace " + BranchLogger.stackTraceToString(e));
            }
        }
    }

    protected void updateEnvironment(Context context, JSONObject post) {
        try {
            String environment;
            String string = environment = DeviceInfo.getInstance().isPackageInstalled() ? Defines.Jsonkey.NativeApp.getKey() : Defines.Jsonkey.InstantApp.getKey();
            if (this.getBranchRemoteAPIVersion() == BRANCH_API_VERSION.V2) {
                JSONObject userData = post.optJSONObject(Defines.Jsonkey.UserData.getKey());
                if (userData != null) {
                    userData.put(Defines.Jsonkey.Environment.getKey(), (Object)environment);
                }
            } else {
                post.put(Defines.Jsonkey.Environment.getKey(), (Object)environment);
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
    }

    public BRANCH_API_VERSION getBranchRemoteAPIVersion() {
        return BRANCH_API_VERSION.V1;
    }

    protected boolean prepareExecuteWithoutTracking() {
        return false;
    }

    boolean isInitializationOrEventRequest() {
        for (Defines.RequestPath item : initializationAndEventRoutes) {
            if (!item.equals((Object)this.requestPath_)) continue;
            return true;
        }
        return false;
    }

    public static enum BRANCH_API_VERSION {
        V1,
        V1_LATD,
        V2;

    }

    public static enum PROCESS_WAIT_LOCK {
        SDK_INIT_WAIT_LOCK,
        GAID_FETCH_WAIT_LOCK,
        INTENT_PENDING_WAIT_LOCK,
        USER_SET_WAIT_LOCK,
        INSTALL_REFERRER_FETCH_WAIT_LOCK,
        USER_AGENT_STRING_LOCK;

    }
}

