/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchUrlQueryParameter;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestLogEvent;
import io.branch.referral.ServerRequestRegisterOpen;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J!\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0015\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\tJ!\u0010\u001d\u001a\u00020\f2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0001\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/branch/referral/ReferringUrlUtility;", "", "prefHelper", "Lio/branch/referral/PrefHelper;", "(Lio/branch/referral/PrefHelper;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "urlQueryParameters", "", "", "Lio/branch/referral/BranchUrlQueryParameter;", "addGclidValueFor", "Lorg/json/JSONObject;", "request", "Lio/branch/referral/ServerRequest;", "checkForAndMigrateOldGclid", "", "defaultValidityWindowForParam", "", "paramName", "deserializeFromJson", "json", "deserializeFromJson$Branch_SDK_release", "findUrlQueryParam", "getURLQueryParamsForRequest", "isSupportedQueryParameter", "", "parseReferringURL", "urlString", "serializeToJson", "serializeToJson$Branch_SDK_release", "Branch-SDK_release"})
public final class ReferringUrlUtility {
    @NotNull
    private final Map<String, BranchUrlQueryParameter> urlQueryParameters;
    @NotNull
    private PrefHelper prefHelper;
    @NotNull
    private final SimpleDateFormat dateFormat;

    public ReferringUrlUtility(@NotNull PrefHelper prefHelper) {
        Intrinsics.checkNotNullParameter((Object)prefHelper, (String)"prefHelper");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        this.prefHelper = prefHelper;
        JSONObject jSONObject = prefHelper.getReferringURLQueryParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"prefHelper.referringURLQueryParameters");
        this.urlQueryParameters = this.deserializeFromJson$Branch_SDK_release(jSONObject);
        this.checkForAndMigrateOldGclid();
    }

    public final void parseReferringURL(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!Branch.getInstance().isTrackingDisabled()) {
            Uri uri = Uri.parse((String)urlString);
            if (uri.isHierarchical()) {
                for (String originalParamName : uri.getQueryParameterNames()) {
                    String paramName;
                    Intrinsics.checkNotNullExpressionValue((Object)originalParamName, (String)"originalParamName");
                    Intrinsics.checkNotNullExpressionValue((Object)originalParamName.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    String paramValue = uri.getQueryParameter(originalParamName);
                    BranchLogger.v("Found URL Query Parameter - Key: " + paramName + ", Value: " + paramValue);
                    if (!this.isSupportedQueryParameter(paramName)) continue;
                    BranchUrlQueryParameter param = this.findUrlQueryParam(paramName);
                    param.setValue(paramValue);
                    param.setTimestamp(new Date());
                    param.setDeepLink(true);
                    if (param.getValidityWindow() == 0L) {
                        param.setValidityWindow(this.defaultValidityWindowForParam(paramName));
                    }
                    this.urlQueryParameters.put(paramName, param);
                }
                this.prefHelper.setReferringUrlQueryParameters(this.serializeToJson$Branch_SDK_release(this.urlQueryParameters));
                BranchLogger.v("Current referringURLQueryParameters: " + this.prefHelper.getReferringURLQueryParameters());
            } else {
                BranchLogger.d("Skipping referring URL query parameter parsing because the URI is not hierarchical. URI: " + urlString);
            }
        } else {
            BranchLogger.d("Skipping referring URL query parameter parsing due to disabled tracking.");
        }
    }

    @NotNull
    public final JSONObject getURLQueryParamsForRequest(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Map returnedParams = new LinkedHashMap();
        JSONObject gclid = this.addGclidValueFor(request);
        if (gclid.length() > 0) {
            Iterator keys = gclid.keys();
            while (keys.hasNext()) {
                Object object;
                String key = (String)keys.next();
                Map map = returnedParams;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)gclid.get(key), (String)"gclid.get(key)");
                map.put(string, object);
            }
        }
        return new JSONObject(returnedParams);
    }

    private final JSONObject addGclidValueFor(ServerRequest request) {
        BranchUrlQueryParameter gclid;
        JSONObject returnParams = new JSONObject();
        if ((request instanceof ServerRequestLogEvent || request instanceof ServerRequestRegisterOpen) && (gclid = this.urlQueryParameters.get(Defines.Jsonkey.Gclid.getKey())) != null && gclid.getValue() != null && !Intrinsics.areEqual((Object)gclid.getValue(), (Object)"bnc_no_value")) {
            long currentTime = new Date().getTime();
            Date date = gclid.getTimestamp();
            Long gclidTimestamp = date != null ? Long.valueOf(date.getTime()) : null;
            long gclidValidityWindowMillis = gclid.getValidityWindow() * 1000L;
            if (gclidTimestamp != null) {
                if (gclid.getValidityWindow() == 0L || currentTime < gclidTimestamp + gclidValidityWindowMillis) {
                    returnParams.put(Defines.Jsonkey.Gclid.getKey(), (Object)gclid.getValue());
                    if (request instanceof ServerRequestRegisterOpen) {
                        returnParams.put(Defines.Jsonkey.IsDeeplinkGclid.getKey(), gclid.isDeepLink());
                    }
                    gclid.setDeepLink(false);
                    this.prefHelper.setReferringUrlQueryParameters(this.serializeToJson$Branch_SDK_release(this.urlQueryParameters));
                } else {
                    this.urlQueryParameters.remove(Defines.Jsonkey.Gclid.getKey());
                    this.prefHelper.setReferringUrlQueryParameters(this.serializeToJson$Branch_SDK_release(this.urlQueryParameters));
                }
            }
        }
        return returnParams;
    }

    private final boolean isSupportedQueryParameter(String paramName) {
        String string = paramName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String lowercase = string;
        List validURLQueryParameters = CollectionsKt.listOf((Object)Defines.Jsonkey.Gclid.getKey());
        return validURLQueryParameters.contains(lowercase);
    }

    private final BranchUrlQueryParameter findUrlQueryParam(String paramName) {
        BranchUrlQueryParameter branchUrlQueryParameter = this.urlQueryParameters.get(paramName);
        if (branchUrlQueryParameter == null) {
            branchUrlQueryParameter = new BranchUrlQueryParameter(paramName, null, null, false, 0L, 30, null);
        }
        return branchUrlQueryParameter;
    }

    private final long defaultValidityWindowForParam(String paramName) {
        return Intrinsics.areEqual((Object)paramName, (Object)Defines.Jsonkey.Gclid.getKey()) ? this.prefHelper.getReferrerGclidValidForWindow() / 1000L : 0L;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final JSONObject serializeToJson$Branch_SDK_release(@NotNull Map<String, BranchUrlQueryParameter> urlQueryParameters) {
        Intrinsics.checkNotNullParameter(urlQueryParameters, (String)"urlQueryParameters");
        JSONObject json = new JSONObject();
        try {
            for (BranchUrlQueryParameter param : urlQueryParameters.values()) {
                String string;
                JSONObject paramDict = new JSONObject();
                paramDict.put("name", (Object)param.getName());
                Object object = param.getValue();
                if (object == null) {
                    object = JSONObject.NULL;
                }
                paramDict.put("value", object);
                JSONObject jSONObject = paramDict;
                String string2 = "timestamp";
                if (param.getTimestamp() != null) {
                    void it;
                    String string3 = string2;
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    String string4 = this.dateFormat.format((Date)it);
                    jSONObject = jSONObject2;
                    string2 = string3;
                    string = string4;
                } else {
                    string = null;
                }
                jSONObject.put(string2, string);
                paramDict.put("isDeeplink", param.isDeepLink());
                paramDict.put("validityWindow", param.getValidityWindow());
                json.put(String.valueOf(param.getName()), (Object)paramDict);
            }
        }
        catch (JSONException e) {
            BranchLogger.e("Caught JSONException when serializing JSON for referring URL query parameters " + e.getMessage());
        }
        return json;
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, BranchUrlQueryParameter> deserializeFromJson$Branch_SDK_release(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Map result = new LinkedHashMap();
        try {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String paramName;
                String key = (String)keys.next();
                JSONObject temp = json.getJSONObject(key);
                BranchUrlQueryParameter param = new BranchUrlQueryParameter(null, null, null, false, 0L, 31, null);
                param.setName(temp.getString("name"));
                if (temp.has("value")) {
                    param.setValue(temp.getString("value"));
                }
                if (temp.has("timestamp")) {
                    try {
                        String timestampStr = temp.getString("timestamp");
                        param.setTimestamp(this.dateFormat.parse(timestampStr));
                    }
                    catch (ParseException e) {
                        BranchLogger.e("Caught JSONException when parsing referring URL query parameter timestamp " + e.getMessage());
                    }
                }
                if (temp.has("validityWindow")) {
                    param.setValidityWindow(temp.getLong("validityWindow"));
                }
                if (temp.has("isDeeplink")) {
                    param.setDeepLink(temp.getBoolean("isDeeplink"));
                } else {
                    param.setDeepLink(false);
                }
                if (param.getName() == null) continue;
                boolean bl = false;
                result.put(paramName, param);
            }
        }
        catch (JSONException e) {
            BranchLogger.e("Caught JSONException when deserializing JSON for referring URL query parameters " + e.getMessage());
        }
        return result;
    }

    private final void checkForAndMigrateOldGclid() {
        String existingGclidValue;
        BranchUrlQueryParameter newGclid;
        BranchUrlQueryParameter branchUrlQueryParameter = newGclid = this.urlQueryParameters.get(Defines.Jsonkey.Gclid.getKey());
        if ((branchUrlQueryParameter != null ? branchUrlQueryParameter.getValue() : null) == null && (existingGclidValue = this.prefHelper.getReferrerGclid()) != null && !Intrinsics.areEqual((Object)existingGclidValue, (Object)"bnc_no_value")) {
            long existingGclidValidityWindow = this.prefHelper.getReferrerGclidValidForWindow();
            Object object = Defines.Jsonkey.Gclid.getKey();
            Date date = new Date();
            BranchUrlQueryParameter gclid = new BranchUrlQueryParameter((String)object, existingGclidValue, date, false, existingGclidValidityWindow);
            object = this.urlQueryParameters;
            String string = Defines.Jsonkey.Gclid.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gclid.key");
            object.put(string, gclid);
            this.prefHelper.setReferringUrlQueryParameters(this.serializeToJson$Branch_SDK_release(this.urlQueryParameters));
            this.prefHelper.clearGclid();
            BranchLogger.v("Updated old Gclid (" + existingGclidValue + ") to new BranchUrlQueryParameter (" + gclid + ')');
        }
    }
}

