/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.text.TextUtils;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.SystemObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class BranchPreinstall {
    private static final String SYSTEM_PROPERTIES_CLASS_KEY = "android.os.SystemProperties";
    private static final String BRANCH_PREINSTALL_PROP_KEY = "io.branch.preinstall.apps.path";

    BranchPreinstall() {
    }

    public static void getPreinstallSystemData(Branch branchInstance, Context context) {
        String branchFilePath;
        if (branchInstance != null && !TextUtils.isEmpty((CharSequence)(branchFilePath = BranchPreinstall.checkForBranchPreinstallInSystem()))) {
            BranchPreinstall.readBranchFile(branchFilePath, branchInstance, context);
        }
    }

    private static String checkForBranchPreinstallInSystem() {
        String path = null;
        try {
            path = (String)Class.forName(SYSTEM_PROPERTIES_CLASS_KEY).getMethod("get", String.class).invoke(null, BRANCH_PREINSTALL_PROP_KEY);
        }
        catch (Exception e) {
            return null;
        }
        return path;
    }

    private static void readBranchFile(final String branchFilePath, final Branch branchInstance, final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    StringBuilder branchFileContent = new StringBuilder();
                    File branchFile = new File(branchFilePath);
                    BufferedReader br = new BufferedReader(new FileReader(branchFile));
                    while ((line = br.readLine()) != null) {
                        branchFileContent.append(line);
                    }
                    br.close();
                    JSONObject branchFileContentJson = new JSONObject(branchFileContent.toString().trim());
                    if (TextUtils.isEmpty((CharSequence)branchFileContentJson.toString())) {
                        throw new FileNotFoundException();
                    }
                    BranchPreinstall.getBranchFileContent(branchFileContentJson, branchInstance, context);
                }
                catch (FileNotFoundException e) {
                    BranchLogger.d(e.getMessage());
                }
                catch (IOException e) {
                    BranchLogger.d(e.getMessage());
                }
                catch (JSONException e) {
                    BranchLogger.d(e.getMessage());
                }
            }
        }).start();
    }

    public static void getBranchFileContent(JSONObject branchFileContentJson, Branch branchInstance, Context context) {
        Iterator keys = branchFileContentJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                if (!key.equals("apps") || !(branchFileContentJson.get(key) instanceof JSONObject) || branchFileContentJson.getJSONObject(key).get(SystemObserver.getPackageName(context)) == null) continue;
                JSONObject branchPreinstallData = branchFileContentJson.getJSONObject(key).getJSONObject(SystemObserver.getPackageName(context));
                Iterator preinstallDataKeys = branchPreinstallData.keys();
                while (preinstallDataKeys.hasNext()) {
                    String datakey = (String)preinstallDataKeys.next();
                    if (datakey.equals(Defines.PreinstallKey.campaign.getKey()) && TextUtils.isEmpty((CharSequence)PrefHelper.getInstance(context).getInstallMetaData(Defines.PreinstallKey.campaign.getKey()))) {
                        branchInstance.setPreinstallCampaign(branchPreinstallData.get(datakey).toString());
                        continue;
                    }
                    if (datakey.equals(Defines.PreinstallKey.partner.getKey()) && TextUtils.isEmpty((CharSequence)PrefHelper.getInstance(context).getInstallMetaData(Defines.PreinstallKey.partner.getKey()))) {
                        branchInstance.setPreinstallPartner(branchPreinstallData.get(datakey).toString());
                        continue;
                    }
                    branchInstance.setRequestMetadata(datakey, branchPreinstallData.get(datakey).toString());
                }
            }
            catch (JSONException e) {
                BranchLogger.d(e.getMessage());
            }
        }
    }

    public static void setBranchPreInstallGoogleReferrer(Context context, HashMap<String, String> referrerMap) {
        Branch branchInstance = Branch.getInstance();
        PrefHelper prefHelper = PrefHelper.getInstance(context);
        if (TextUtils.isEmpty((CharSequence)prefHelper.getInstallMetaData(Defines.PreinstallKey.partner.getKey())) && TextUtils.isEmpty((CharSequence)prefHelper.getInstallMetaData(Defines.PreinstallKey.campaign.getKey()))) {
            if (!TextUtils.isEmpty((CharSequence)referrerMap.get(Defines.Jsonkey.UTMCampaign.getKey()))) {
                branchInstance.setPreinstallCampaign(referrerMap.get(Defines.Jsonkey.UTMCampaign.getKey()));
            }
            if (!TextUtils.isEmpty((CharSequence)referrerMap.get(Defines.Jsonkey.UTMMedium.getKey()))) {
                branchInstance.setPreinstallPartner(referrerMap.get(Defines.Jsonkey.UTMMedium.getKey()));
            }
        }
    }
}

