/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import androidx.annotation.NonNull;
import io.branch.referral.BranchLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BranchPartnerParameters {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, String>> partnerParameters = new ConcurrentHashMap();
    private static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");

    void clearAllParameters() {
        this.partnerParameters.clear();
    }

    @NonNull
    ConcurrentHashMap<String, String> parametersForPartner(@NonNull String key) {
        ConcurrentHashMap<String, String> res = this.partnerParameters.get(key);
        if (res == null) {
            res = new ConcurrentHashMap();
            this.partnerParameters.put(key, res);
        }
        return res;
    }

    private void addParameterWithName(@NonNull String key, @NonNull String value, @NonNull String partnerName) {
        this.parametersForPartner(partnerName).put(key, value);
    }

    void addFacebookParameter(@NonNull String key, @NonNull String value) {
        if (this.isSha256Hashed(value)) {
            this.addParameterWithName(key, value, "fb");
        } else {
            BranchLogger.w("Invalid partner parameter passed. Value must be a SHA 256 hash.");
        }
    }

    void addSnapParameter(@NonNull String key, @NonNull String value) {
        if (this.isSha256Hashed(value)) {
            this.addParameterWithName(key, value, "snap");
        } else {
            BranchLogger.w("Invalid partner parameter passed. Value must be a SHA 256 hash.");
        }
    }

    boolean isSha256Hashed(String value) {
        return value != null && value.length() == 64 && this.isHexadecimal(value);
    }

    boolean isHexadecimal(String input) {
        if (input == null) {
            return false;
        }
        if (input.length() == 0) {
            return true;
        }
        Matcher matcher = HEXADECIMAL_PATTERN.matcher(input);
        return matcher.matches();
    }

    ConcurrentHashMap<String, ConcurrentHashMap<String, String>> allParams() {
        return this.partnerParameters;
    }
}

