/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.util.Log;
import io.branch.interfaces.IBranchLoggingCallbacks;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lio/branch/referral/BranchLogger;", "", "()V", "TAG", "", "loggerCallback", "Lio/branch/interfaces/IBranchLoggingCallbacks;", "getLoggerCallback$annotations", "getLoggerCallback", "()Lio/branch/interfaces/IBranchLoggingCallbacks;", "setLoggerCallback", "(Lio/branch/interfaces/IBranchLoggingCallbacks;)V", "loggingEnabled", "", "getLoggingEnabled$annotations", "getLoggingEnabled", "()Z", "setLoggingEnabled", "(Z)V", "loggingLevel", "Lio/branch/referral/BranchLogger$BranchLogLevel;", "getLoggingLevel$annotations", "getLoggingLevel", "()Lio/branch/referral/BranchLogger$BranchLogLevel;", "setLoggingLevel", "(Lio/branch/referral/BranchLogger$BranchLogLevel;)V", "d", "", "message", "e", "i", "logAlways", "shouldLog", "level", "stackTraceToString", "exception", "Ljava/lang/Exception;", "useCustomLogger", "v", "w", "BranchLogLevel", "Branch-SDK_release"})
public final class BranchLogger {
    @NotNull
    public static final BranchLogger INSTANCE = new BranchLogger();
    @NotNull
    private static final String TAG = "BranchSDK";
    @NotNull
    private static BranchLogLevel loggingLevel = BranchLogLevel.DEBUG;
    private static boolean loggingEnabled;
    @Nullable
    private static IBranchLoggingCallbacks loggerCallback;

    private BranchLogger() {
    }

    @NotNull
    public static final BranchLogLevel getLoggingLevel() {
        return loggingLevel;
    }

    public static final void setLoggingLevel(@NotNull BranchLogLevel branchLogLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)branchLogLevel), (String)"<set-?>");
        loggingLevel = branchLogLevel;
    }

    @JvmStatic
    public static /* synthetic */ void getLoggingLevel$annotations() {
    }

    public static final boolean getLoggingEnabled() {
        return loggingEnabled;
    }

    public static final void setLoggingEnabled(boolean bl) {
        loggingEnabled = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getLoggingEnabled$annotations() {
    }

    @Nullable
    public static final IBranchLoggingCallbacks getLoggerCallback() {
        return loggerCallback;
    }

    public static final void setLoggerCallback(@Nullable IBranchLoggingCallbacks iBranchLoggingCallbacks) {
        loggerCallback = iBranchLoggingCallbacks;
    }

    @JvmStatic
    public static /* synthetic */ void getLoggerCallback$annotations() {
    }

    private final boolean shouldLog(BranchLogLevel level) {
        return level.getLevel() <= loggingLevel.getLevel();
    }

    @JvmStatic
    public static final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (loggingEnabled && INSTANCE.shouldLog(BranchLogLevel.ERROR) && ((CharSequence)message).length() > 0) {
            if (INSTANCE.useCustomLogger()) {
                IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                if (iBranchLoggingCallbacks != null) {
                    iBranchLoggingCallbacks.onBranchLog(message, "ERROR");
                }
            } else {
                Log.e((String)TAG, (String)message);
            }
        }
    }

    @JvmStatic
    public static final void w(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (loggingEnabled && INSTANCE.shouldLog(BranchLogLevel.WARN) && ((CharSequence)message).length() > 0) {
            if (INSTANCE.useCustomLogger()) {
                IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                if (iBranchLoggingCallbacks != null) {
                    iBranchLoggingCallbacks.onBranchLog(message, "WARN");
                }
            } else {
                Log.w((String)TAG, (String)message);
            }
        }
    }

    @JvmStatic
    public static final void i(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (loggingEnabled && INSTANCE.shouldLog(BranchLogLevel.INFO) && ((CharSequence)message).length() > 0) {
            if (INSTANCE.useCustomLogger()) {
                IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                if (iBranchLoggingCallbacks != null) {
                    iBranchLoggingCallbacks.onBranchLog(message, "INFO");
                }
            } else {
                Log.i((String)TAG, (String)message);
            }
        }
    }

    @JvmStatic
    public static final void d(@Nullable String message) {
        if (loggingEnabled && INSTANCE.shouldLog(BranchLogLevel.DEBUG)) {
            String string = message;
            boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl) {
                if (INSTANCE.useCustomLogger()) {
                    IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                    if (iBranchLoggingCallbacks != null) {
                        iBranchLoggingCallbacks.onBranchLog(message, "DEBUG");
                    }
                } else {
                    Log.d((String)TAG, (String)message);
                }
            }
        }
    }

    @JvmStatic
    public static final void v(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (loggingEnabled && INSTANCE.shouldLog(BranchLogLevel.VERBOSE) && ((CharSequence)message).length() > 0) {
            if (INSTANCE.useCustomLogger()) {
                IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                if (iBranchLoggingCallbacks != null) {
                    iBranchLoggingCallbacks.onBranchLog(message, "VERBOSE");
                }
            } else {
                Log.v((String)TAG, (String)message);
            }
        }
    }

    @JvmStatic
    public static final void logAlways(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (((CharSequence)message).length() > 0) {
            if (INSTANCE.useCustomLogger()) {
                IBranchLoggingCallbacks iBranchLoggingCallbacks = loggerCallback;
                if (iBranchLoggingCallbacks != null) {
                    iBranchLoggingCallbacks.onBranchLog(message, "INFO");
                }
            } else {
                Log.i((String)TAG, (String)message);
            }
        }
    }

    private final boolean useCustomLogger() {
        return loggerCallback != null;
    }

    @JvmStatic
    @NotNull
    public static final String stackTraceToString(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Writer writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lio/branch/referral/BranchLogger$BranchLogLevel;", "", "level", "", "(Ljava/lang/String;II)V", "getLevel", "()I", "ERROR", "WARN", "INFO", "DEBUG", "VERBOSE", "Branch-SDK_release"})
    public static final class BranchLogLevel
    extends Enum<BranchLogLevel> {
        private final int level;
        public static final /* enum */ BranchLogLevel ERROR = new BranchLogLevel(1);
        public static final /* enum */ BranchLogLevel WARN = new BranchLogLevel(2);
        public static final /* enum */ BranchLogLevel INFO = new BranchLogLevel(3);
        public static final /* enum */ BranchLogLevel DEBUG = new BranchLogLevel(4);
        public static final /* enum */ BranchLogLevel VERBOSE = new BranchLogLevel(5);
        private static final /* synthetic */ BranchLogLevel[] $VALUES;

        private BranchLogLevel(int level) {
            this.level = level;
        }

        public final int getLevel() {
            return this.level;
        }

        public static BranchLogLevel[] values() {
            return (BranchLogLevel[])$VALUES.clone();
        }

        public static BranchLogLevel valueOf(String value) {
            return Enum.valueOf(BranchLogLevel.class, value);
        }

        static {
            $VALUES = branchLogLevelArray = new BranchLogLevel[]{BranchLogLevel.ERROR, BranchLogLevel.WARN, BranchLogLevel.INFO, BranchLogLevel.DEBUG, BranchLogLevel.VERBOSE};
        }
    }
}

