/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.app.ActivityCompat;
import com.android.billingclient.api.Purchase;
import io.branch.indexing.BranchUniversalObject;
import io.branch.interfaces.IBranchLoggingCallbacks;
import io.branch.referral.Base64;
import io.branch.referral.BillingGooglePlay;
import io.branch.referral.BranchActivityLifecycleObserver;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLinkData;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchPluginSupport;
import io.branch.referral.BranchPreinstall;
import io.branch.referral.BranchQRCodeCache;
import io.branch.referral.BranchShareSheetBuilder;
import io.branch.referral.BranchUniversalReferralInitWrapper;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.InstantAppUtil;
import io.branch.referral.NativeShareLinkManager;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestCreateUrl;
import io.branch.referral.ServerRequestGetLATD;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerRequestQueue;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerRequestRegisterOpen;
import io.branch.referral.ServerResponse;
import io.branch.referral.ShareLinkManager;
import io.branch.referral.SystemObserver;
import io.branch.referral.TrackingController;
import io.branch.referral.UniversalResourceAnalyser;
import io.branch.referral.network.BranchRemoteInterface;
import io.branch.referral.network.BranchRemoteInterfaceUrlConnection;
import io.branch.referral.util.BRANCH_STANDARD_EVENT;
import io.branch.referral.util.BranchEvent;
import io.branch.referral.util.DependencyUtilsKt;
import io.branch.referral.util.LinkProperties;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Branch {
    private static final String BRANCH_LIBRARY_VERSION = "io.branch.sdk.android:library:" + Branch.getSdkVersionNumber();
    private static final String GOOGLE_VERSION_TAG = "!SDK-VERSION-STRING!:" + BRANCH_LIBRARY_VERSION;
    public static final String FEATURE_TAG_SHARE = "share";
    public static final String REDIRECT_DESKTOP_URL = "$desktop_url";
    public static final String REDIRECT_ANDROID_URL = "$android_url";
    public static final String REDIRECT_IOS_URL = "$ios_url";
    public static final String REDIRECT_IPAD_URL = "$ipad_url";
    public static final String REDIRECT_FIRE_URL = "$fire_url";
    public static final String REDIRECT_BLACKBERRY_URL = "$blackberry_url";
    public static final String REDIRECT_WINDOWS_PHONE_URL = "$windows_phone_url";
    public static final String OG_TITLE = "$og_title";
    public static final String OG_DESC = "$og_description";
    public static final String OG_IMAGE_URL = "$og_image_url";
    public static final String OG_VIDEO = "$og_video";
    public static final String OG_URL = "$og_url";
    public static final String OG_APP_ID = "$og_app_id";
    public static final String DEEPLINK_PATH = "$deeplink_path";
    public static final String ALWAYS_DEEPLINK = "$always_deeplink";
    public static final int LINK_TYPE_UNLIMITED_USE = 0;
    public static final int LINK_TYPE_ONE_TIME_USE = 1;
    static boolean userAgentSync;
    public static String _userAgentString;
    private JSONObject deeplinkDebugParams_;
    private static boolean disableDeviceIDFetch_;
    static boolean bypassWaitingForIntent_;
    private static boolean bypassCurrentActivityIntentState_;
    static boolean disableAutoSessionInitialization;
    static boolean referringLinkAttributionForPreinstalledAppsEnabled;
    private static Branch branchReferral_;
    private BranchRemoteInterface branchRemoteInterface_;
    final PrefHelper prefHelper_;
    private final DeviceInfo deviceInfo_;
    private final BranchPluginSupport branchPluginSupport_;
    private final Context context_;
    private final BranchQRCodeCache branchQRCodeCache_;
    public final ServerRequestQueue requestQueue_;
    final ConcurrentHashMap<BranchLinkData, String> linkCache_ = new ConcurrentHashMap();
    private static boolean isActivityLifeCycleCallbackRegistered_;
    private CustomTabsIntent customTabsIntentOverride;
    private INTENT_STATE intentState_ = INTENT_STATE.PENDING;
    SESSION_STATE initState_ = SESSION_STATE.UNINITIALISED;
    static boolean deferInitForPluginRuntime;
    public boolean closeRequestNeeded = false;
    private ShareLinkManager shareLinkManager_;
    WeakReference<Activity> currentActivityReference_;
    private static final String AUTO_DEEP_LINK_KEY = "io.branch.sdk.auto_link_keys";
    private static final String AUTO_DEEP_LINK_PATH = "io.branch.sdk.auto_link_path";
    private static final String AUTO_DEEP_LINK_DISABLE = "io.branch.sdk.auto_link_disable";
    private static final String AUTO_DEEP_LINK_REQ_CODE = "io.branch.sdk.auto_link_request_code";
    private static final int DEF_AUTO_DEEP_LINK_REQ_CODE = 1501;
    private static final int LATCH_WAIT_UNTIL = 2500;
    private static final String[] EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST;
    public static String installDeveloperId;
    CountDownLatch getFirstReferringParamsLatch = null;
    CountDownLatch getLatestReferringParamsLatch = null;
    private boolean isInstantDeepLinkPossible = false;
    private BranchActivityLifecycleObserver activityLifeCycleObserver;
    private static boolean enableInstantDeepLinking;
    private final TrackingController trackingController;
    private static String pluginVersion;
    private static String pluginName;
    private BranchReferralInitListener deferredCallback;
    private Uri deferredUri;
    private InitSessionBuilder deferredSessionBuilder;

    private Branch(@NonNull Context context) {
        this.context_ = context;
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.trackingController = new TrackingController(context);
        this.branchRemoteInterface_ = new BranchRemoteInterfaceUrlConnection(this);
        this.deviceInfo_ = new DeviceInfo(context);
        this.branchPluginSupport_ = new BranchPluginSupport(context);
        this.branchQRCodeCache_ = new BranchQRCodeCache(context);
        this.requestQueue_ = ServerRequestQueue.getInstance(context);
    }

    public static synchronized Branch getInstance() {
        if (branchReferral_ == null) {
            BranchLogger.v("Branch instance is not created yet. Make sure you call getAutoInstance(Context).");
        }
        return branchReferral_;
    }

    private static synchronized Branch initBranchSDK(@NonNull Context context, String branchKey) {
        if (branchReferral_ != null) {
            BranchLogger.w("Warning, attempted to reinitialize Branch SDK singleton!");
            return branchReferral_;
        }
        branchReferral_ = new Branch(context.getApplicationContext());
        if (TextUtils.isEmpty((CharSequence)branchKey)) {
            BranchLogger.w("Warning: Please enter your branch_key in your project's Manifest file!");
            Branch.branchReferral_.prefHelper_.setBranchKey("bnc_no_value");
        } else {
            Branch.branchReferral_.prefHelper_.setBranchKey(branchKey);
        }
        if (context instanceof Application) {
            branchReferral_.setActivityLifeCycleObserver((Application)context);
        }
        return branchReferral_;
    }

    public static synchronized Branch getAutoInstance(@NonNull Context context) {
        if (branchReferral_ == null) {
            if (BranchUtil.getEnableLoggingConfig(context)) {
                Branch.enableLogging();
            }
            Branch.deferInitForPluginRuntime(BranchUtil.getDeferInitForPluginRuntimeConfig(context));
            BranchUtil.setAPIBaseUrlFromConfig(context);
            BranchUtil.setFbAppIdFromConfig(context);
            BranchUtil.setCPPLevelFromConfig(context);
            BranchUtil.setTestMode(BranchUtil.checkTestMode(context));
            branchReferral_ = Branch.initBranchSDK(context, BranchUtil.readBranchKey(context));
            BranchPreinstall.getPreinstallSystemData(branchReferral_, context);
        }
        return branchReferral_;
    }

    public static Branch getAutoInstance(@NonNull Context context, @NonNull String branchKey) {
        if (branchReferral_ == null) {
            if (BranchUtil.getEnableLoggingConfig(context)) {
                Branch.enableLogging();
            }
            Branch.deferInitForPluginRuntime(BranchUtil.getDeferInitForPluginRuntimeConfig(context));
            BranchUtil.setAPIBaseUrlFromConfig(context);
            BranchUtil.setFbAppIdFromConfig(context);
            BranchUtil.setCPPLevelFromConfig(context);
            BranchUtil.setTestMode(BranchUtil.checkTestMode(context));
            if (!PrefHelper.isValidBranchKey(branchKey)) {
                BranchLogger.w("Warning, Invalid branch key passed! Branch key will be read from manifest instead!");
                branchKey = BranchUtil.readBranchKey(context);
            }
            branchReferral_ = Branch.initBranchSDK(context, branchKey);
            BranchPreinstall.getPreinstallSystemData(branchReferral_, context);
        }
        return branchReferral_;
    }

    public Context getApplicationContext() {
        return this.context_;
    }

    public void setBranchRemoteInterface(BranchRemoteInterface remoteInterface) {
        this.branchRemoteInterface_ = remoteInterface == null ? new BranchRemoteInterfaceUrlConnection(this) : remoteInterface;
    }

    public BranchRemoteInterface getBranchRemoteInterface() {
        return this.branchRemoteInterface_;
    }

    public static void enableTestMode() {
        BranchUtil.setTestMode(true);
        BranchLogger.logAlways("enableTestMode has been changed. It now uses the test key but will not log or randomize the device IDs. If you wish to enable logging, please invoke enableLogging. If you wish to simulate installs, please see add a Test Device (https://help.branch.io/using-branch/docs/adding-test-devices) then reset your test device's data (https://help.branch.io/using-branch/docs/adding-test-devices#section-resetting-your-test-device-data).");
    }

    public static void disableTestMode() {
        BranchUtil.setTestMode(false);
    }

    public void disableAdNetworkCallouts(boolean disabled) {
        PrefHelper.getInstance(this.context_).setAdNetworkCalloutsDisabled(disabled);
    }

    public static void expectDelayedSessionInitialization(boolean expectDelayedInit) {
        disableAutoSessionInitialization = expectDelayedInit;
    }

    public static void setAPIUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            PrefHelper.setAPIUrl(url);
            BranchLogger.v("setAPIUrl: Branch API URL was set to " + url);
        } else {
            BranchLogger.w("setAPIUrl: URL cannot be empty or null");
        }
    }

    public static void setCDNBaseUrl(String url) {
        PrefHelper.setCDNBaseUrl(url);
    }

    @Deprecated
    public void disableTracking(boolean disableTracking, @Nullable TrackingStateCallback callback) {
        this.trackingController.disableTracking(this.context_, disableTracking, callback);
    }

    @Deprecated
    public void disableTracking(boolean disableTracking) {
        this.disableTracking(disableTracking, null);
    }

    public boolean isTrackingDisabled() {
        return this.trackingController.isTrackingDisabled();
    }

    public static void disableInstantDeepLinking(boolean disableIDL) {
        enableInstantDeepLinking = !disableIDL;
    }

    static void shutDown() {
        ServerRequestQueue.shutDown();
        PrefHelper.shutDown();
        BranchUtil.shutDown();
        branchReferral_ = null;
        bypassCurrentActivityIntentState_ = false;
        enableInstantDeepLinking = false;
        isActivityLifeCycleCallbackRegistered_ = false;
        bypassWaitingForIntent_ = false;
    }

    public void resetUserSession() {
        this.setInitState(SESSION_STATE.UNINITIALISED);
    }

    public void setRetryCount(int retryCount) {
        if (this.prefHelper_ != null && retryCount >= 0) {
            this.prefHelper_.setRetryCount(retryCount);
        }
    }

    public void setRetryInterval(int retryInterval) {
        if (this.prefHelper_ != null && retryInterval > 0) {
            this.prefHelper_.setRetryInterval(retryInterval);
        }
    }

    public void setNetworkTimeout(int timeout) {
        if (this.prefHelper_ != null && timeout > 0) {
            this.prefHelper_.setTimeout(timeout);
        }
    }

    public void setNetworkConnectTimeout(int connectTimeout) {
        if (this.prefHelper_ != null && connectTimeout > 0) {
            this.prefHelper_.setConnectTimeout(connectTimeout);
        }
    }

    public void setNoConnectionRetryMax(int retryMax) {
        if (this.prefHelper_ != null && retryMax > 0) {
            this.prefHelper_.setNoConnectionRetryMax(retryMax);
        }
    }

    public void setReferrerGclidValidForWindow(long window) {
        if (this.prefHelper_ != null) {
            this.prefHelper_.setReferrerGclidValidForWindow(window);
        }
    }

    public static void disableDeviceIDFetch(Boolean deviceIdFetch) {
        disableDeviceIDFetch_ = deviceIdFetch;
    }

    public static boolean isDeviceIDFetchDisabled() {
        return disableDeviceIDFetch_;
    }

    public void setDeepLinkDebugMode(JSONObject debugParams) {
        this.deeplinkDebugParams_ = debugParams;
    }

    public void disableAppList() {
    }

    public void setLimitFacebookTracking(boolean isLimitFacebookTracking) {
        this.prefHelper_.setLimitFacebookTracking(isLimitFacebookTracking);
    }

    public void setDMAParamsForEEA(boolean eeaRegion, boolean adPersonalizationConsent, boolean adUserDataUsageConsent) {
        this.prefHelper_.setEEARegion(eeaRegion);
        this.prefHelper_.setAdPersonalizationConsent(adPersonalizationConsent);
        this.prefHelper_.setAdUserDataUsageConsent(adUserDataUsageConsent);
    }

    public void setRequestMetadata(@NonNull String key, @NonNull String value) {
        this.prefHelper_.setRequestMetadata(key, value);
    }

    public Branch addInstallMetadata(@NonNull String key, @NonNull String value) {
        this.prefHelper_.addInstallMetadata(key, value);
        return this;
    }

    public Branch setPreinstallCampaign(@NonNull String preInstallCampaign) {
        this.addInstallMetadata(Defines.PreinstallKey.campaign.getKey(), preInstallCampaign);
        return this;
    }

    public Branch setPreinstallPartner(@NonNull String preInstallPartner) {
        this.addInstallMetadata(Defines.PreinstallKey.partner.getKey(), preInstallPartner);
        return this;
    }

    public static void setReferringLinkAttributionForPreinstalledAppsEnabled() {
        referringLinkAttributionForPreinstalledAppsEnabled = true;
    }

    public static boolean isReferringLinkAttributionForPreinstalledAppsEnabled() {
        return referringLinkAttributionForPreinstalledAppsEnabled;
    }

    public static void setIsUserAgentSync(boolean sync) {
        userAgentSync = sync;
    }

    public static boolean getIsUserAgentSync() {
        return userAgentSync;
    }

    void closeSessionInternal() {
        this.clearPartnerParameters();
        this.executeClose();
        this.prefHelper_.setSessionParams("bnc_no_value");
        this.prefHelper_.setExternalIntentUri(null);
        this.trackingController.updateTrackingState(this.context_);
    }

    void clearPendingRequests() {
        this.requestQueue_.clear();
    }

    private void executeClose() {
        if (this.initState_ != SESSION_STATE.UNINITIALISED) {
            this.setInitState(SESSION_STATE.UNINITIALISED);
        }
    }

    public static void registerPlugin(String name, String version) {
        pluginName = name;
        pluginVersion = version;
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }

    static String getPluginName() {
        return pluginName;
    }

    private void readAndStripParam(Uri data, Activity activity) {
        BranchLogger.v("Read params uri: " + data + " bypassCurrentActivityIntentState: " + bypassCurrentActivityIntentState_ + " intent state: " + (Object)((Object)this.intentState_));
        if (enableInstantDeepLinking) {
            boolean noUnusedBranchLinkInIntent;
            boolean activityHasValidIntent = this.intentState_ == INTENT_STATE.READY || !this.activityLifeCycleObserver.isCurrentActivityLaunchedFromStack();
            BranchLogger.v("activityHasValidIntent: " + activityHasValidIntent);
            boolean bl = noUnusedBranchLinkInIntent = !this.isRestartSessionRequested(activity != null ? activity.getIntent() : null);
            if (activityHasValidIntent && noUnusedBranchLinkInIntent) {
                this.extractSessionParamsForIDL(data, activity);
            }
        }
        if (bypassCurrentActivityIntentState_) {
            this.intentState_ = INTENT_STATE.READY;
        }
        if (this.intentState_ == INTENT_STATE.READY) {
            this.extractExternalUriAndIntentExtras(data, activity);
            this.extractInitialReferrer(activity);
            if (this.extractBranchLinkFromIntentExtra(activity)) {
                return;
            }
            if (!this.isActivityLaunchedFromHistory(activity)) {
                if (this.extractClickID(data, activity)) {
                    return;
                }
                this.extractAppLink(data, activity);
            }
        }
    }

    void unlockSDKInitWaitLock() {
        if (this.requestQueue_ == null) {
            return;
        }
        this.requestQueue_.postInitClear();
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.SDK_INIT_WAIT_LOCK);
        this.requestQueue_.processNextQueueItem("unlockSDKInitWaitLock");
    }

    private boolean isIntentParamsAlreadyConsumed(Activity activity) {
        boolean result = activity != null && activity.getIntent() != null && activity.getIntent().getBooleanExtra(Defines.IntentKeys.BranchLinkUsed.getKey(), false);
        BranchLogger.v("isIntentParamsAlreadyConsumed " + result);
        return result;
    }

    private boolean isActivityLaunchedFromHistory(Activity activity) {
        return activity != null && activity.getIntent() != null && (activity.getIntent().getFlags() & 0x100000) != 0;
    }

    String getSessionReferredLink() {
        String link = this.prefHelper_.getExternalIntentUri();
        return link.equals("bnc_no_value") ? null : link;
    }

    public Branch addWhiteListedScheme(String urlWhiteListPattern) {
        if (urlWhiteListPattern != null) {
            UniversalResourceAnalyser.getInstance(this.context_).addToAcceptURLFormats(urlWhiteListPattern);
        }
        return this;
    }

    public Branch setWhiteListedSchemes(List<String> urlWhiteListPatternList) {
        if (urlWhiteListPatternList != null) {
            UniversalResourceAnalyser.getInstance(this.context_).addToAcceptURLFormats(urlWhiteListPatternList);
        }
        return this;
    }

    public Branch addUriHostsToSkip(String urlSkipPattern) {
        if (!TextUtils.isEmpty((CharSequence)urlSkipPattern)) {
            UniversalResourceAnalyser.getInstance(this.context_).addToSkipURLFormats(urlSkipPattern);
        }
        return this;
    }

    void updateSkipURLFormats() {
        UniversalResourceAnalyser.getInstance(this.context_).checkAndUpdateSkipURLFormats(this.context_);
    }

    public void setIdentity(@NonNull String userId) {
        this.setIdentity(userId, null);
    }

    public void setIdentity(@NonNull String userId, @Nullable BranchReferralInitListener callback) {
        if (userId != null && !userId.equals(this.prefHelper_.getIdentity())) {
            installDeveloperId = userId;
            this.prefHelper_.setIdentity(userId);
        }
        if (callback != null) {
            callback.onInitFinished(this.getFirstReferringParams(), null);
        }
    }

    public void getLastAttributedTouchData(@NonNull ServerRequestGetLATD.BranchLastAttributedTouchDataListener callback) {
        if (this.context_ != null) {
            this.requestQueue_.handleNewRequest(new ServerRequestGetLATD(this.context_, Defines.RequestPath.GetLATD, callback));
        }
    }

    public void getLastAttributedTouchData(ServerRequestGetLATD.BranchLastAttributedTouchDataListener callback, int attributionWindow) {
        if (this.context_ != null) {
            this.requestQueue_.handleNewRequest(new ServerRequestGetLATD(this.context_, Defines.RequestPath.GetLATD, callback, attributionWindow));
        }
    }

    public boolean isUserIdentified() {
        return !this.prefHelper_.getIdentity().equals("bnc_no_value");
    }

    public void logout() {
        this.logout(null);
    }

    public void logout(LogoutStatusListener callback) {
        this.prefHelper_.setIdentity("bnc_no_value");
        this.prefHelper_.clearUserValues();
        this.linkCache_.clear();
        this.requestQueue_.clear();
        if (callback != null) {
            callback.onLogoutFinished(true, null);
        }
    }

    public JSONObject getFirstReferringParams() {
        String storedParam = this.prefHelper_.getInstallParams();
        JSONObject firstReferringParams = this.convertParamsStringToDictionary(storedParam);
        firstReferringParams = this.appendDebugParams(firstReferringParams);
        return firstReferringParams;
    }

    public void removeSessionInitializationDelay() {
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.USER_SET_WAIT_LOCK);
        this.requestQueue_.processNextQueueItem("removeSessionInitializationDelay");
    }

    public JSONObject getFirstReferringParamsSync() {
        this.getFirstReferringParamsLatch = new CountDownLatch(1);
        if (this.prefHelper_.getInstallParams().equals("bnc_no_value")) {
            try {
                this.getFirstReferringParamsLatch.await(2500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String storedParam = this.prefHelper_.getInstallParams();
        JSONObject firstReferringParams = this.convertParamsStringToDictionary(storedParam);
        this.appendDebugParams(firstReferringParams);
        this.getFirstReferringParamsLatch = null;
        return firstReferringParams;
    }

    public JSONObject getLatestReferringParams() {
        String storedParam = this.prefHelper_.getSessionParams();
        JSONObject latestParams = this.convertParamsStringToDictionary(storedParam);
        latestParams = this.appendDebugParams(latestParams);
        return latestParams;
    }

    public JSONObject getLatestReferringParamsSync() {
        this.getLatestReferringParamsLatch = new CountDownLatch(1);
        try {
            if (this.initState_ != SESSION_STATE.INITIALISED) {
                this.getLatestReferringParamsLatch.await(2500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String storedParam = this.prefHelper_.getSessionParams();
        JSONObject latestParams = this.convertParamsStringToDictionary(storedParam);
        latestParams = this.appendDebugParams(latestParams);
        this.getLatestReferringParamsLatch = null;
        return latestParams;
    }

    public void addFacebookPartnerParameterWithName(@NonNull String key, @NonNull String value) {
        if (!this.trackingController.isTrackingDisabled()) {
            this.prefHelper_.partnerParams_.addFacebookParameter(key, value);
        }
    }

    public void addSnapPartnerParameterWithName(@NonNull String key, @NonNull String value) {
        if (!this.trackingController.isTrackingDisabled()) {
            this.prefHelper_.partnerParams_.addSnapParameter(key, value);
        }
    }

    public void clearPartnerParameters() {
        this.prefHelper_.partnerParams_.clearAllParameters();
    }

    private JSONObject appendDebugParams(JSONObject originalParams) {
        try {
            if (originalParams != null && this.deeplinkDebugParams_ != null) {
                if (this.deeplinkDebugParams_.length() > 0) {
                    BranchLogger.v("You're currently in deep link debug mode. Please comment out 'setDeepLinkDebugMode' to receive the deep link parameters from a real Branch link");
                }
                Iterator keys = this.deeplinkDebugParams_.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    originalParams.put(key, this.deeplinkDebugParams_.get(key));
                }
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return originalParams;
    }

    public JSONObject getDeeplinkDebugParams() {
        if (this.deeplinkDebugParams_ != null && this.deeplinkDebugParams_.length() > 0) {
            BranchLogger.v("You're currently in deep link debug mode. Please comment out 'setDeepLinkDebugMode' to receive the deep link parameters from a real Branch link");
        }
        return this.deeplinkDebugParams_;
    }

    String generateShortLinkInternal(ServerRequestCreateUrl req) {
        if (!req.constructError_ && !req.handleErrors(this.context_)) {
            if (this.linkCache_.containsKey((Object)req.getLinkPost())) {
                String url = this.linkCache_.get((Object)req.getLinkPost());
                req.onUrlAvailable(url);
                return url;
            }
            if (req.isAsync()) {
                this.requestQueue_.handleNewRequest(req);
            } else {
                return this.generateShortLinkSync(req);
            }
        }
        return null;
    }

    @RequiresApi(api=22)
    public void share(@NonNull Activity activity, @NonNull BranchUniversalObject buo, @NonNull LinkProperties linkProperties, @Nullable BranchNativeLinkShareListener callback, String title, String subject) {
        NativeShareLinkManager.getInstance().shareLink(activity, buo, linkProperties, callback, title, subject);
    }

    void shareLink(BranchShareSheetBuilder builder) {
        if (this.shareLinkManager_ != null) {
            this.shareLinkManager_.cancelShareLinkDialog(true);
        }
        this.shareLinkManager_ = new ShareLinkManager();
        this.shareLinkManager_.shareLink(builder);
    }

    public void cancelShareLinkDialog(boolean animateClose) {
        if (this.shareLinkManager_ != null) {
            this.shareLinkManager_.cancelShareLinkDialog(animateClose);
        }
    }

    private String generateShortLinkSync(ServerRequestCreateUrl req) {
        ServerResponse response = null;
        try {
            int timeOut = this.prefHelper_.getTimeout() + 2000;
            response = (ServerResponse)new GetShortLinkTask().execute(new ServerRequest[]{req}).get((long)timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            BranchLogger.d(e.getMessage());
        }
        String url = null;
        if (req.isDefaultToLongUrl()) {
            url = req.getLongUrl();
        }
        if (response != null && response.getStatusCode() == 200) {
            try {
                url = response.getObject().getString("url");
                if (req.getLinkPost() != null) {
                    this.linkCache_.put(req.getLinkPost(), url);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private JSONObject convertParamsStringToDictionary(String paramString) {
        if (paramString.equals("bnc_no_value")) {
            return new JSONObject();
        }
        try {
            return new JSONObject(paramString);
        }
        catch (JSONException e) {
            byte[] encodedArray = Base64.decode(paramString.getBytes(), 2);
            try {
                return new JSONObject(new String(encodedArray));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                return new JSONObject();
            }
        }
    }

    public TrackingController getTrackingController() {
        return this.trackingController;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo_;
    }

    public BranchPluginSupport getBranchPluginSupport() {
        return this.branchPluginSupport_;
    }

    public BranchQRCodeCache getBranchQRCodeCache() {
        return this.branchQRCodeCache_;
    }

    PrefHelper getPrefHelper() {
        return this.prefHelper_;
    }

    ShareLinkManager getShareLinkManager() {
        return this.shareLinkManager_;
    }

    void setIntentState(INTENT_STATE intentState) {
        this.intentState_ = intentState;
    }

    void setInitState(SESSION_STATE initState) {
        this.initState_ = initState;
    }

    SESSION_STATE getInitState() {
        return this.initState_;
    }

    public void setInstantDeepLinkPossible(boolean instantDeepLinkPossible) {
        this.isInstantDeepLinkPossible = instantDeepLinkPossible;
    }

    public boolean isInstantDeepLinkPossible() {
        return this.isInstantDeepLinkPossible;
    }

    private void initializeSession(ServerRequestInitSession initRequest, int delay) {
        BranchLogger.v("initializeSession " + initRequest + " delay " + delay);
        if (this.prefHelper_.getBranchKey() == null || this.prefHelper_.getBranchKey().equalsIgnoreCase("bnc_no_value")) {
            this.setInitState(SESSION_STATE.UNINITIALISED);
            if (initRequest.callback_ != null) {
                initRequest.callback_.onInitFinished(null, new BranchError("Trouble initializing Branch.", -114));
            }
            BranchLogger.w("Warning: Please enter your branch_key in your project's manifest");
            return;
        }
        if (BranchUtil.isTestModeEnabled()) {
            BranchLogger.w("Warning: You are using your test app's Branch Key. Remember to change it to live Branch Key during deployment.");
        }
        if (delay > 0) {
            initRequest.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.USER_SET_WAIT_LOCK);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Branch.this.removeSessionInitializationDelay();
                }
            }, (long)delay);
        }
        Intent intent = this.getCurrentActivity() != null ? this.getCurrentActivity().getIntent() : null;
        boolean forceBranchSession = this.isRestartSessionRequested(intent);
        SESSION_STATE sessionState = this.getInitState();
        BranchLogger.v("Intent: " + intent + " forceBranchSession: " + forceBranchSession + " initState: " + (Object)((Object)sessionState));
        if (sessionState == SESSION_STATE.UNINITIALISED || forceBranchSession) {
            if (forceBranchSession && intent != null) {
                intent.removeExtra(Defines.IntentKeys.ForceNewBranchSession.getKey());
            }
            this.registerAppInit(initRequest, forceBranchSession);
        } else if (initRequest.callback_ != null) {
            initRequest.callback_.onInitFinished(null, new BranchError("Warning.", -118));
        }
    }

    void registerAppInit(@NonNull ServerRequestInitSession request, boolean forceBranchSession) {
        BranchLogger.v("registerAppInit " + request + " forceBranchSession: " + forceBranchSession);
        this.setInitState(SESSION_STATE.INITIALISING);
        ServerRequestInitSession r = this.requestQueue_.getSelfInitRequest();
        BranchLogger.v("Ordering init calls");
        BranchLogger.v("Self init request: " + r);
        this.requestQueue_.printQueue();
        if (r == null || forceBranchSession) {
            BranchLogger.v("Moving " + request + " to front of the queue or behind network-in-progress request");
            this.requestQueue_.insertRequestAtFront(request);
        } else {
            BranchLogger.v("Retrieved " + r + " with callback " + r.callback_ + " in queue currently");
            r.callback_ = request.callback_;
            BranchLogger.v(r + " now has callback " + request.callback_);
        }
        BranchLogger.v("Finished ordering init calls");
        this.requestQueue_.printQueue();
        this.initTasks(request);
        this.requestQueue_.processNextQueueItem("registerAppInit");
    }

    private void initTasks(final ServerRequest request) {
        BranchLogger.v("initTasks " + request);
        if (this.intentState_ != INTENT_STATE.READY && Branch.isWaitingForIntent()) {
            request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.INTENT_PENDING_WAIT_LOCK);
            BranchLogger.v("Added INTENT_PENDING_WAIT_LOCK");
        }
        if (request instanceof ServerRequestRegisterInstall) {
            request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.INSTALL_REFERRER_FETCH_WAIT_LOCK);
            BranchLogger.v("Added INSTALL_REFERRER_FETCH_WAIT_LOCK");
            this.deviceInfo_.getSystemObserver().fetchInstallReferrer(this.context_, new SystemObserver.InstallReferrerFetchEvents(){

                @Override
                public void onInstallReferrersFinished() {
                    request.removeProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.INSTALL_REFERRER_FETCH_WAIT_LOCK);
                    BranchLogger.v("INSTALL_REFERRER_FETCH_WAIT_LOCK removed");
                    Branch.this.requestQueue_.processNextQueueItem("onInstallReferrersFinished");
                }
            });
        }
        request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.GAID_FETCH_WAIT_LOCK);
        BranchLogger.v("Added GAID_FETCH_WAIT_LOCK");
        this.deviceInfo_.getSystemObserver().fetchAdId(this.context_, new SystemObserver.AdsParamsFetchEvents(){

            @Override
            public void onAdsParamsFetchFinished() {
                Branch.this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.GAID_FETCH_WAIT_LOCK);
                Branch.this.requestQueue_.processNextQueueItem("onAdsParamsFetchFinished");
            }
        });
    }

    ServerRequestInitSession getInstallOrOpenRequest(BranchReferralInitListener callback, boolean isAutoInitialization) {
        ServerRequestInitSession request = this.requestQueue_.hasUser() ? new ServerRequestRegisterOpen(this.context_, callback, isAutoInitialization) : new ServerRequestRegisterInstall(this.context_, callback, isAutoInitialization);
        return request;
    }

    void onIntentReady(@NonNull Activity activity) {
        boolean grabIntentParams;
        BranchLogger.v("onIntentReady " + activity + " removing INTENT_PENDING_WAIT_LOCK");
        this.setIntentState(INTENT_STATE.READY);
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.INTENT_PENDING_WAIT_LOCK);
        boolean bl = grabIntentParams = activity.getIntent() != null && this.getInitState() != SESSION_STATE.INITIALISED;
        if (grabIntentParams) {
            Uri intentData = activity.getIntent().getData();
            this.readAndStripParam(intentData, activity);
        }
        this.requestQueue_.processNextQueueItem("onIntentReady");
    }

    public void notifyNetworkAvailable() {
        this.requestQueue_.processNextQueueItem("notifyNetworkAvailable");
    }

    private void setActivityLifeCycleObserver(Application application) {
        BranchLogger.v("setActivityLifeCycleObserver activityLifeCycleObserver: " + this.activityLifeCycleObserver + " application: " + application);
        try {
            this.activityLifeCycleObserver = new BranchActivityLifecycleObserver();
            BranchLogger.v("setActivityLifeCycleObserver set new activityLifeCycleObserver: " + this.activityLifeCycleObserver + " application: " + application);
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifeCycleObserver);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifeCycleObserver);
            isActivityLifeCycleCallbackRegistered_ = true;
        }
        catch (NoClassDefFoundError | NoSuchMethodError Ex) {
            isActivityLifeCycleCallbackRegistered_ = false;
            BranchLogger.v(new BranchError("", -108).getMessage());
        }
    }

    boolean isRestartSessionRequested(Intent intent) {
        return this.checkIntentForSessionRestart(intent) || this.checkIntentForUnusedBranchLink(intent);
    }

    private boolean checkIntentForSessionRestart(Intent intent) {
        boolean forceSessionIntentKeyPresent = false;
        if (intent != null) {
            forceSessionIntentKeyPresent = intent.getBooleanExtra(Defines.IntentKeys.ForceNewBranchSession.getKey(), false);
        }
        return forceSessionIntentKeyPresent;
    }

    private boolean checkIntentForUnusedBranchLink(Intent intent) {
        boolean hasUnusedBranchLink = false;
        if (intent != null) {
            boolean hasBranchLink = intent.getStringExtra(Defines.IntentKeys.BranchURI.getKey()) != null;
            boolean branchLinkNotConsumedYet = !intent.getBooleanExtra(Defines.IntentKeys.BranchLinkUsed.getKey(), false);
            hasUnusedBranchLink = hasBranchLink && branchLinkNotConsumedYet;
        }
        return hasUnusedBranchLink;
    }

    public static boolean isAutoDeepLinkLaunch(Activity activity) {
        return activity.getIntent().getStringExtra(Defines.IntentKeys.AutoDeepLinked.getKey()) != null;
    }

    void checkForAutoDeepLinkConfiguration() {
        JSONObject latestParams = this.getLatestReferringParams();
        String deepLinkActivity = null;
        try {
            if (!latestParams.has(Defines.Jsonkey.Clicked_Branch_Link.getKey()) || !latestParams.getBoolean(Defines.Jsonkey.Clicked_Branch_Link.getKey())) {
                BranchLogger.v("Does not have Clicked_Branch_Link or Clicked_Branch_Link is false, returning");
                return;
            }
            if (latestParams.length() > 0) {
                ApplicationInfo appInfo = this.context_.getPackageManager().getApplicationInfo(this.context_.getPackageName(), 128);
                if (appInfo.metaData != null && appInfo.metaData.getBoolean(AUTO_DEEP_LINK_DISABLE, false)) {
                    return;
                }
                PackageInfo info = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 129);
                ActivityInfo[] activityInfos = info.activities;
                int deepLinkActivityReqCode = 1501;
                if (activityInfos != null) {
                    for (ActivityInfo activityInfo : activityInfos) {
                        if (activityInfo == null || activityInfo.metaData == null || activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY) == null && activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH) == null || !this.checkForAutoDeepLinkKeys(latestParams, activityInfo) && !this.checkForAutoDeepLinkPath(latestParams, activityInfo)) continue;
                        deepLinkActivity = activityInfo.name;
                        deepLinkActivityReqCode = activityInfo.metaData.getInt(AUTO_DEEP_LINK_REQ_CODE, 1501);
                        break;
                    }
                }
                BranchLogger.v("deepLinkActivity " + deepLinkActivity + " getCurrentActivity " + this.getCurrentActivity());
                if (deepLinkActivity != null && this.getCurrentActivity() != null) {
                    Activity currentActivity = this.getCurrentActivity();
                    Intent intent = new Intent((Context)currentActivity, Class.forName(deepLinkActivity));
                    intent.putExtra(Defines.IntentKeys.AutoDeepLinked.getKey(), "true");
                    intent.putExtra(Defines.Jsonkey.ReferringData.getKey(), latestParams.toString());
                    Iterator keys = latestParams.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        intent.putExtra(key, latestParams.getString(key));
                    }
                    currentActivity.startActivityForResult(intent, deepLinkActivityReqCode);
                } else {
                    BranchLogger.v("No activity reference to launch deep linked activity");
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            BranchLogger.w("Warning: Please make sure Activity names set for auto deep link are correct!");
        }
        catch (ClassNotFoundException e) {
            BranchLogger.w("Warning: Please make sure Activity names set for auto deep link are correct! Error while looking for activity " + deepLinkActivity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkForAutoDeepLinkKeys(JSONObject params, ActivityInfo activityInfo) {
        if (activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY) != null) {
            String[] activityLinkKeys;
            for (String activityLinkKey : activityLinkKeys = activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY).split(",")) {
                if (!params.has(activityLinkKey)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForAutoDeepLinkPath(JSONObject params, ActivityInfo activityInfo) {
        String deepLinkPath = null;
        try {
            if (params.has(Defines.Jsonkey.AndroidDeepLinkPath.getKey())) {
                deepLinkPath = params.getString(Defines.Jsonkey.AndroidDeepLinkPath.getKey());
            } else if (params.has(Defines.Jsonkey.DeepLinkPath.getKey())) {
                deepLinkPath = params.getString(Defines.Jsonkey.DeepLinkPath.getKey());
            }
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
        if (activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH) != null && deepLinkPath != null) {
            String[] activityLinkPaths;
            for (String activityLinkPath : activityLinkPaths = activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH).split(",")) {
                if (!this.pathMatch(activityLinkPath.trim(), deepLinkPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pathMatch(String templatePath, String path) {
        String[] pathSegmentsTarget;
        boolean matched = true;
        String[] pathSegmentsTemplate = templatePath.split("\\?")[0].split("/");
        if (pathSegmentsTemplate.length != (pathSegmentsTarget = path.split("\\?")[0].split("/")).length) {
            return false;
        }
        for (int i = 0; i < pathSegmentsTemplate.length && i < pathSegmentsTarget.length; ++i) {
            String pathSegmentTemplate = pathSegmentsTemplate[i];
            String pathSegmentTarget = pathSegmentsTarget[i];
            if (pathSegmentTemplate.equals(pathSegmentTarget) || pathSegmentTemplate.contains("*")) continue;
            matched = false;
            break;
        }
        return matched;
    }

    public static void enableLogging(IBranchLoggingCallbacks iBranchLogging, BranchLogger.BranchLogLevel level) {
        BranchLogger.setLoggerCallback(iBranchLogging);
        BranchLogger.setLoggingLevel(level);
        BranchLogger.setLoggingEnabled(true);
        BranchLogger.logAlways(GOOGLE_VERSION_TAG);
    }

    public static void enableLogging() {
        Branch.enableLogging(null, BranchLogger.BranchLogLevel.VERBOSE);
    }

    public static void enableLogging(IBranchLoggingCallbacks iBranchLogging) {
        Branch.enableLogging(iBranchLogging, BranchLogger.BranchLogLevel.VERBOSE);
    }

    public static void enableLogging(BranchLogger.BranchLogLevel level) {
        Branch.enableLogging(null, level);
    }

    public static void disableLogging() {
        BranchLogger.setLoggingEnabled(false);
        BranchLogger.setLoggerCallback(null);
    }

    @Deprecated
    public static void enableForcedSession() {
        Branch.bypassWaitingForIntent(true);
    }

    public static void bypassWaitingForIntent(boolean bypassIntent) {
        bypassWaitingForIntent_ = bypassIntent;
    }

    @Deprecated
    public static void disableForcedSession() {
        Branch.bypassWaitingForIntent(false);
    }

    @Deprecated
    public static boolean isForceSessionEnabled() {
        return Branch.isWaitingForIntent();
    }

    public static boolean isWaitingForIntent() {
        return !bypassWaitingForIntent_;
    }

    public static void enableBypassCurrentActivityIntentState() {
        bypassCurrentActivityIntentState_ = true;
    }

    public static boolean bypassCurrentActivityIntentState() {
        return bypassCurrentActivityIntentState_;
    }

    public void registerView(BranchUniversalObject branchUniversalObject, BranchUniversalObject.RegisterViewStatusListener callback) {
        if (this.context_ != null) {
            new BranchEvent(BRANCH_STANDARD_EVENT.VIEW_ITEM).addContentItems(branchUniversalObject).logEvent(this.context_);
        }
    }

    public static boolean isInstantApp(@NonNull Context context) {
        return InstantAppUtil.isInstantApp(context);
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode) {
        String installReferrerString = "";
        if (Branch.getInstance() != null) {
            JSONObject latestReferringParams = Branch.getInstance().getLatestReferringParams();
            String referringLinkKey = "~" + Defines.Jsonkey.ReferringLink.getKey();
            if (latestReferringParams != null && latestReferringParams.has(referringLinkKey)) {
                String referringLink = "";
                try {
                    referringLink = latestReferringParams.getString(referringLinkKey);
                    referringLink = URLEncoder.encode(referringLink, "UTF-8");
                }
                catch (UnsupportedEncodingException | JSONException e) {
                    e.printStackTrace();
                }
                if (!TextUtils.isEmpty((CharSequence)referringLink)) {
                    installReferrerString = Defines.Jsonkey.IsFullAppConv.getKey() + "=true&" + Defines.Jsonkey.ReferringLink.getKey() + "=" + referringLink;
                }
            }
        }
        return InstantAppUtil.doShowInstallPrompt(activity, requestCode, installReferrerString);
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode, @Nullable String referrer) {
        String installReferrerString = Defines.Jsonkey.IsFullAppConv.getKey() + "=true&" + referrer;
        return InstantAppUtil.doShowInstallPrompt(activity, requestCode, installReferrerString);
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode, @NonNull BranchUniversalObject buo) {
        String shortUrl = buo.getShortUrl((Context)activity, new LinkProperties());
        String installReferrerString = Defines.Jsonkey.ReferringLink.getKey() + "=" + shortUrl;
        if (!TextUtils.isEmpty((CharSequence)installReferrerString)) {
            return Branch.showInstallPrompt(activity, requestCode, installReferrerString);
        }
        return Branch.showInstallPrompt(activity, requestCode, "");
    }

    private void extractSessionParamsForIDL(Uri data, Activity activity) {
        if (activity == null || activity.getIntent() == null) {
            return;
        }
        Intent intent = activity.getIntent();
        try {
            if (data == null || this.isIntentParamsAlreadyConsumed(activity)) {
                if (!this.prefHelper_.getInstallParams().equals("bnc_no_value")) {
                    JSONObject nonLinkClickJson = new JSONObject();
                    nonLinkClickJson.put(Defines.Jsonkey.IsFirstSession.getKey(), false);
                    this.prefHelper_.setSessionParams(nonLinkClickJson.toString());
                    this.isInstantDeepLinkPossible = true;
                }
            } else if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra(Defines.IntentKeys.BranchData.getKey()))) {
                String rawBranchData = intent.getStringExtra(Defines.IntentKeys.BranchData.getKey());
                if (rawBranchData != null) {
                    JSONObject branchDataJson = new JSONObject(rawBranchData);
                    branchDataJson.put(Defines.Jsonkey.Clicked_Branch_Link.getKey(), true);
                    this.prefHelper_.setSessionParams(branchDataJson.toString());
                    this.isInstantDeepLinkPossible = true;
                }
                intent.removeExtra(Defines.IntentKeys.BranchData.getKey());
                activity.setIntent(intent);
            } else if (data.isHierarchical() && Boolean.valueOf(data.getQueryParameter(Defines.Jsonkey.Instant.getKey())).booleanValue()) {
                JSONObject branchDataJson = new JSONObject();
                for (String key : data.getQueryParameterNames()) {
                    branchDataJson.put(key, (Object)data.getQueryParameter(key));
                }
                branchDataJson.put(Defines.Jsonkey.Clicked_Branch_Link.getKey(), true);
                this.prefHelper_.setSessionParams(branchDataJson.toString());
                this.isInstantDeepLinkPossible = true;
            }
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
    }

    private void extractAppLink(Uri data, Activity activity) {
        if (data == null || activity == null) {
            return;
        }
        String scheme = data.getScheme();
        Intent intent = activity.getIntent();
        if (scheme != null && intent != null && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) && !TextUtils.isEmpty((CharSequence)data.getHost()) && !this.isIntentParamsAlreadyConsumed(activity)) {
            String strippedUrl = UniversalResourceAnalyser.getInstance(this.context_).getStrippedURL(data.toString());
            if (data.toString().equalsIgnoreCase(strippedUrl)) {
                this.prefHelper_.setAppLink(data.toString());
            }
            intent.putExtra(Defines.IntentKeys.BranchLinkUsed.getKey(), true);
            activity.setIntent(intent);
        }
    }

    private boolean extractClickID(Uri data, Activity activity) {
        try {
            if (data == null || !data.isHierarchical()) {
                return false;
            }
            String linkClickID = data.getQueryParameter(Defines.Jsonkey.LinkClickID.getKey());
            if (linkClickID == null) {
                return false;
            }
            this.prefHelper_.setLinkClickIdentifier(linkClickID);
            String paramString = "link_click_id=" + linkClickID;
            String uriString = data.toString();
            paramString = paramString.equals(data.getQuery()) ? "\\?" + paramString : (uriString.length() - paramString.length() == uriString.indexOf(paramString) ? "&" + paramString : paramString + "&");
            Uri uriWithoutClickID = Uri.parse((String)uriString.replaceFirst(paramString, ""));
            activity.getIntent().setData(uriWithoutClickID);
            activity.getIntent().putExtra(Defines.IntentKeys.BranchLinkUsed.getKey(), true);
            return true;
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
            return false;
        }
    }

    private boolean extractBranchLinkFromIntentExtra(Activity activity) {
        BranchLogger.v("extractBranchLinkFromIntentExtra " + activity);
        try {
            if (activity != null && activity.getIntent() != null && activity.getIntent().getExtras() != null && !this.isIntentParamsAlreadyConsumed(activity)) {
                Object object = activity.getIntent().getExtras().get(Defines.IntentKeys.BranchURI.getKey());
                String branchLink = null;
                if (object instanceof String) {
                    branchLink = (String)object;
                } else if (object instanceof Uri) {
                    Uri uri = (Uri)object;
                    branchLink = uri.toString();
                }
                if (!TextUtils.isEmpty((CharSequence)branchLink)) {
                    this.prefHelper_.setPushIdentifier(branchLink);
                    Intent thisIntent = activity.getIntent();
                    thisIntent.putExtra(Defines.IntentKeys.BranchLinkUsed.getKey(), true);
                    activity.setIntent(thisIntent);
                    return true;
                }
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return false;
    }

    private void extractExternalUriAndIntentExtras(Uri data, Activity activity) {
        BranchLogger.v("extractExternalUriAndIntentExtras " + data + " " + activity);
        try {
            if (!this.isIntentParamsAlreadyConsumed(activity)) {
                String strippedUrl = UniversalResourceAnalyser.getInstance(this.context_).getStrippedURL(data.toString());
                this.prefHelper_.setExternalIntentUri(strippedUrl);
                if (strippedUrl.equals(data.toString())) {
                    Bundle bundle = activity.getIntent().getExtras();
                    Set extraKeys = bundle.keySet();
                    if (extraKeys.isEmpty()) {
                        return;
                    }
                    JSONObject extrasJson = new JSONObject();
                    for (String key : EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST) {
                        if (!extraKeys.contains(key)) continue;
                        extrasJson.put(key, bundle.get(key));
                    }
                    if (extrasJson.length() > 0) {
                        this.prefHelper_.setExternalIntentExtra(extrasJson.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
    }

    private void extractInitialReferrer(Activity activity) {
        BranchLogger.v("extractInitialReferrer " + activity);
        if (activity != null) {
            Uri initialReferrer = ActivityCompat.getReferrer((Activity)activity);
            BranchLogger.v("Initial referrer: " + initialReferrer);
            if (initialReferrer != null) {
                this.prefHelper_.setInitialReferrer(initialReferrer.toString());
            }
        }
    }

    @Nullable
    Activity getCurrentActivity() {
        if (this.currentActivityReference_ == null) {
            return null;
        }
        return (Activity)this.currentActivityReference_.get();
    }

    boolean isIDLSession() {
        return Boolean.parseBoolean(Branch.getInstance().requestQueue_.instrumentationExtraData_.get(Defines.Jsonkey.InstantDeepLinkSession.getKey()));
    }

    public static InitSessionBuilder sessionBuilder(Activity activity) {
        return new InitSessionBuilder(activity);
    }

    public static String getSdkVersionNumber() {
        return "5.18.1";
    }

    static void deferInitForPluginRuntime(boolean isDeferred) {
        BranchLogger.v("deferInitForPluginRuntime " + isDeferred);
        deferInitForPluginRuntime = isDeferred;
        if (isDeferred) {
            Branch.expectDelayedSessionInitialization(isDeferred);
        }
    }

    public static void notifyNativeToInit() {
        BranchLogger.v("notifyNativeToInit deferredSessionBuilder " + Branch.getInstance().deferredSessionBuilder);
        SESSION_STATE sessionState = Branch.getInstance().getInitState();
        if (sessionState == SESSION_STATE.UNINITIALISED) {
            deferInitForPluginRuntime = false;
            if (Branch.getInstance().deferredSessionBuilder != null) {
                Branch.getInstance().deferredSessionBuilder.init();
            }
        } else {
            BranchLogger.v("notifyNativeToInit session is not uninitialized. Session state is " + (Object)((Object)sessionState));
        }
    }

    public void logEventWithPurchase(@NonNull Context context, @NonNull Purchase purchase) {
        if (DependencyUtilsKt.classExists("com.android.billingclient.api.BillingClient")) {
            BillingGooglePlay.Companion.getInstance().startBillingClient((Function1<? super Boolean, Unit>)((Function1)succeeded -> {
                if (succeeded.booleanValue()) {
                    BillingGooglePlay.Companion.getInstance().logEventWithPurchase(context, purchase);
                } else {
                    BranchLogger.e("Cannot log IAP event. Billing client setup failed");
                }
                return null;
            }));
        }
    }

    public static void useEUEndpoint() {
        PrefHelper.useEUEndpoint(true);
    }

    public static void setFBAppID(String fbAppID) {
        if (!TextUtils.isEmpty((CharSequence)fbAppID)) {
            PrefHelper.fbAppId_ = fbAppID;
            BranchLogger.v("setFBAppID to " + fbAppID);
        } else {
            BranchLogger.w("setFBAppID: fbAppID cannot be empty or null");
        }
    }

    public void setConsumerProtectionAttributionLevel(Defines.BranchAttributionLevel level) {
        this.setConsumerProtectionAttributionLevel(level, null);
    }

    public void setConsumerProtectionAttributionLevel(Defines.BranchAttributionLevel level, @Nullable TrackingStateCallback callback) {
        this.prefHelper_.setConsumerProtectionAttributionLevel(level);
        BranchLogger.v("Set Consumer Protection Preference to " + (Object)((Object)level));
        if (level == Defines.BranchAttributionLevel.NONE) {
            this.trackingController.disableTracking(this.context_, true, callback);
        } else if (this.trackingController.isTrackingDisabled()) {
            this.trackingController.disableTracking(this.context_, false, callback);
        }
    }

    public void openBrowserExperience(JSONObject jsonObject) {
        BranchLogger.v("openBrowserExperience JSONObject: " + String.valueOf(jsonObject));
        try {
            if (jsonObject == null) {
                BranchLogger.e("openBrowserExperience: jsonObject is null");
                return;
            }
            String experienceType = null;
            String weblinkUrl = null;
            if (jsonObject.has(Defines.Jsonkey.Enhanced_Web_Link_UX.getKey())) {
                experienceType = jsonObject.optString(Defines.Jsonkey.Enhanced_Web_Link_UX.getKey(), null);
            }
            if (jsonObject.has(Defines.Jsonkey.Web_Link_Redirect_URL.getKey())) {
                weblinkUrl = jsonObject.optString(Defines.Jsonkey.Web_Link_Redirect_URL.getKey(), null);
            }
            if (weblinkUrl == null || weblinkUrl.isEmpty()) {
                BranchLogger.e("openBrowserExperience: weblinkUrl is null or empty");
                return;
            }
            boolean customTabsImported = DependencyUtilsKt.classExists("androidx.browser.customtabs.CustomTabsIntent");
            if (Defines.Jsonkey.IN_APP_WEBVIEW.getKey().equals(experienceType) && customTabsImported) {
                if (this.customTabsIntentOverride != null) {
                    BranchLogger.v("Using developer specified CustomTabs");
                    this.launchCustomTabBrowser(this.customTabsIntentOverride, weblinkUrl, this.getCurrentActivity());
                } else {
                    BranchLogger.v("Using default CustomTabs");
                    this.launchCustomTabBrowser(weblinkUrl, this.getCurrentActivity());
                }
            } else {
                BranchLogger.v("customTabsImported " + customTabsImported);
                BranchLogger.v("Opening in external browser.");
                this.launchExternalBrowser(weblinkUrl);
            }
        }
        catch (Exception ex) {
            BranchLogger.e("openBrowserExperience caught exception: " + ex);
        }
    }

    private void launchCustomTabBrowser(String url, Activity activity) {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        this.launchCustomTabBrowser(customTabsIntent, url, activity);
    }

    public void setCustomTabsIntent(CustomTabsIntent customTabsIntent) {
        this.customTabsIntentOverride = customTabsIntent;
    }

    private void launchCustomTabBrowser(CustomTabsIntent customTabsIntent, String url, Activity activity) {
        try {
            this.prefHelper_.setWebLinkUxTypeUsed(Defines.Jsonkey.IN_APP_WEBVIEW.getKey());
            this.prefHelper_.setWebLinkLoadTime(System.currentTimeMillis());
            customTabsIntent.launchUrl((Context)activity, Uri.parse((String)url));
        }
        catch (Exception ex) {
            BranchLogger.e("launchCustomTabBrowser caught exception: " + ex);
        }
    }

    private void launchExternalBrowser(String url) {
        try {
            this.prefHelper_.setWebLinkUxTypeUsed(Defines.Jsonkey.EXTERNAL_BROWSER.getKey());
            this.prefHelper_.setWebLinkLoadTime(System.currentTimeMillis());
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.context_.startActivity(intent);
        }
        catch (Exception ex) {
            BranchLogger.e("launchExternalBrowser caught exception: " + ex);
        }
    }

    static {
        _userAgentString = "";
        bypassWaitingForIntent_ = false;
        bypassCurrentActivityIntentState_ = false;
        referringLinkAttributionForPreinstalledAppsEnabled = false;
        isActivityLifeCycleCallbackRegistered_ = false;
        deferInitForPluginRuntime = false;
        EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST = new String[]{"extra_launch_uri", "branch_intent"};
        installDeveloperId = null;
        enableInstantDeepLinking = false;
        pluginVersion = null;
        pluginName = null;
    }

    public static class InitSessionBuilder {
        private BranchReferralInitListener callback;
        private boolean isAutoInitialization;
        private int delay;
        private Uri uri;
        private Boolean ignoreIntent;
        private boolean isReInitializing;

        private InitSessionBuilder(Activity activity) {
            Branch branch = Branch.getInstance();
            if (!(activity == null || branch.getCurrentActivity() != null && branch.getCurrentActivity().getLocalClassName().equals(activity.getLocalClassName()))) {
                BranchLogger.v("currentActivityReference_ was " + branch.currentActivityReference_);
                branch.currentActivityReference_ = new WeakReference<Activity>(activity);
                BranchLogger.v("currentActivityReference_ is now set to " + branch.currentActivityReference_);
            }
        }

        InitSessionBuilder isAutoInitialization(boolean isAuto) {
            this.isAutoInitialization = isAuto;
            return this;
        }

        public InitSessionBuilder withCallback(BranchUniversalReferralInitListener callback) {
            BranchLogger.v("InitSessionBuilder setting BranchUniversalReferralInitListener withCallback with " + callback);
            this.callback = new BranchUniversalReferralInitWrapper(callback);
            return this;
        }

        public InitSessionBuilder withDelay(int delayMillis) {
            this.delay = delayMillis;
            return this;
        }

        public InitSessionBuilder withCallback(BranchReferralInitListener callback) {
            BranchLogger.v("InitSessionBuilder setting BranchReferralInitListener withCallback with " + callback);
            this.callback = callback;
            return this;
        }

        public InitSessionBuilder withData(Uri uri) {
            BranchLogger.v("InitSessionBuilder setting withData with " + uri);
            this.uri = uri;
            return this;
        }

        public InitSessionBuilder isReferrable(boolean isReferrable) {
            return this;
        }

        public InitSessionBuilder ignoreIntent(boolean ignore) {
            this.ignoreIntent = ignore;
            return this;
        }

        public void init() {
            Activity activity;
            BranchLogger.v("Beginning session initialization");
            BranchLogger.v("Session uri is " + this.uri);
            BranchLogger.v("Callback is " + this.callback);
            BranchLogger.v("Is auto init " + this.isAutoInitialization);
            BranchLogger.v("Will ignore intent " + this.ignoreIntent);
            BranchLogger.v("Is reinitializing " + this.isReInitializing);
            if (deferInitForPluginRuntime) {
                BranchLogger.v("Session init is deferred until signaled by plugin.");
                this.cacheSessionBuilder(this);
                return;
            }
            Branch branch = Branch.getInstance();
            if (branch == null) {
                BranchLogger.logAlways("Branch is not setup properly, make sure to call getAutoInstance in your application class or declare BranchApp in your manifest.");
                return;
            }
            if (this.ignoreIntent != null) {
                Branch.bypassWaitingForIntent(this.ignoreIntent);
            }
            Intent intent = (activity = branch.getCurrentActivity()) != null ? activity.getIntent() : null;
            Uri initialReferrer = null;
            if (activity != null) {
                initialReferrer = ActivityCompat.getReferrer((Activity)activity);
            }
            BranchLogger.v("Activity: " + activity);
            BranchLogger.v("Intent: " + intent);
            BranchLogger.v("Initial Referrer: " + initialReferrer);
            if (activity != null && intent != null && initialReferrer != null) {
                PrefHelper.getInstance((Context)activity).setInitialReferrer(initialReferrer.toString());
            }
            if (this.uri != null) {
                branch.readAndStripParam(this.uri, activity);
            } else if (this.isReInitializing && branch.isRestartSessionRequested(intent)) {
                branch.readAndStripParam(intent != null ? intent.getData() : null, activity);
            } else if (this.isReInitializing) {
                if (this.callback != null) {
                    this.callback.onInitFinished(null, new BranchError("", -119));
                }
                return;
            }
            BranchLogger.v("isInstantDeepLinkPossible " + branch.isInstantDeepLinkPossible);
            if (branch.isInstantDeepLinkPossible) {
                branch.isInstantDeepLinkPossible = false;
                if (this.callback != null) {
                    this.callback.onInitFinished(branch.getLatestReferringParams(), null);
                }
                Branch.getInstance().requestQueue_.addExtraInstrumentationData(Defines.Jsonkey.InstantDeepLinkSession.getKey(), "true");
                branch.checkForAutoDeepLinkConfiguration();
                this.callback = null;
            }
            if (this.delay > 0) {
                Branch.expectDelayedSessionInitialization(true);
            }
            ServerRequestInitSession initRequest = branch.getInstallOrOpenRequest(this.callback, this.isAutoInitialization);
            BranchLogger.d("Creating " + initRequest + " from init on thread " + Thread.currentThread().getName());
            branch.initializeSession(initRequest, this.delay);
        }

        private void cacheSessionBuilder(InitSessionBuilder initSessionBuilder) {
            Branch.getInstance().deferredSessionBuilder = this;
            BranchLogger.v("Session initialization deferred until plugin invokes notifyNativeToInit()\nCaching Session Builder " + Branch.getInstance().deferredSessionBuilder + "\nuri: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.uri + "\ncallback: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.callback + "\nisReInitializing: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.isReInitializing + "\ndelay: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.delay + "\nisAutoInitialization: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.isAutoInitialization + "\nignoreIntent: " + ((Branch)Branch.getInstance()).deferredSessionBuilder.ignoreIntent);
        }

        public void reInit() {
            this.isReInitializing = true;
            this.init();
        }
    }

    static enum INTENT_STATE {
        PENDING,
        READY;

    }

    static enum SESSION_STATE {
        INITIALISED,
        INITIALISING,
        UNINITIALISED;

    }

    public static interface TrackingStateCallback {
        public void onTrackingStateChanged(boolean var1, @Nullable JSONObject var2, @Nullable BranchError var3);
    }

    public static interface BranchReferralInitListener {
        public void onInitFinished(@Nullable JSONObject var1, @Nullable BranchError var2);
    }

    public static interface LogoutStatusListener {
        public void onLogoutFinished(boolean var1, BranchError var2);
    }

    public static interface BranchNativeLinkShareListener {
        public void onLinkShareResponse(String var1, BranchError var2);

        public void onChannelSelected(String var1);
    }

    private class GetShortLinkTask
    extends AsyncTask<ServerRequest, Void, ServerResponse> {
        private GetShortLinkTask() {
        }

        protected ServerResponse doInBackground(ServerRequest ... serverRequests) {
            return Branch.this.branchRemoteInterface_.make_restful_post(serverRequests[0].getPost(), Branch.this.prefHelper_.getAPIBaseUrl() + Defines.RequestPath.GetURL.getPath(), Defines.RequestPath.GetURL.getPath(), Branch.this.prefHelper_.getBranchKey());
        }
    }

    public static interface BranchListResponseListener {
        public void onReceivingResponse(JSONArray var1, BranchError var2);
    }

    public static interface IChannelProperties {
        public String getSharingTitleForChannel(String var1);

        public String getSharingMessageForChannel(String var1);
    }

    public static interface ExtendedBranchLinkShareListener
    extends BranchLinkShareListener {
        public boolean onChannelSelected(String var1, BranchUniversalObject var2, LinkProperties var3);
    }

    public static interface BranchLinkShareListener {
        public void onShareLinkDialogLaunched();

        public void onShareLinkDialogDismissed();

        public void onLinkShareResponse(String var1, String var2, BranchError var3);

        public void onChannelSelected(String var1);
    }

    public static interface BranchLinkCreateListener {
        public void onLinkCreate(String var1, BranchError var2);
    }

    public static interface BranchReferralStateChangedListener {
        public void onStateChanged(boolean var1, @Nullable BranchError var2);
    }

    public static interface BranchUniversalReferralInitListener {
        public void onInitFinished(@Nullable BranchUniversalObject var1, @Nullable LinkProperties var2, @Nullable BranchError var3);
    }
}

