/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ApkParser {
    private static final int endDocTag = 0x100101;
    private static final int startTag = 0x100102;
    private static final int endTag = 0x100103;

    ApkParser() {
    }

    public JSONObject decompressXMLForValidator(byte[] xml, Context context) {
        int xmlTagOff;
        JSONObject intentFilters = new JSONObject();
        JSONArray applinkFilters = new JSONArray();
        JSONObject results = new JSONObject();
        int numbStrings = this.LEW(xml, 16);
        int sitOff = 36;
        int stOff = sitOff + numbStrings * 4;
        for (int ii = xmlTagOff = this.LEW(xml, 12); ii < xml.length - 4; ii += 4) {
            if (this.LEW(xml, ii) != 0x100102) continue;
            xmlTagOff = ii;
            break;
        }
        try {
            String scheme = "";
            int off = xmlTagOff;
            while (off < xml.length) {
                int tag0 = this.LEW(xml, off);
                if (tag0 == 0x100102) {
                    int numbAttrs = this.LEW(xml, off + 28);
                    off += 36;
                    for (int ii = 0; ii < numbAttrs; ++ii) {
                        JSONArray domainList;
                        String attrValue;
                        int attrNameSi = this.LEW(xml, off + 4);
                        int attrValueSi = this.LEW(xml, off + 8);
                        int attrResId = this.LEW(xml, off + 16);
                        off += 20;
                        String attrName = this.compXmlString(xml, sitOff, stOff, attrNameSi);
                        if ("scheme".equals(attrName)) {
                            String string = attrValue = attrValueSi != -1 ? this.compXmlString(xml, sitOff, stOff, attrValueSi) : BranchUtil.decodeResourceId(context, attrResId);
                            if (this.validURI(attrValue)) {
                                scheme = attrValue;
                                if (!intentFilters.has(scheme)) {
                                    JSONArray host = new JSONArray();
                                    intentFilters.put(scheme, (Object)host);
                                } else if (intentFilters.has("0")) {
                                    domainList = (JSONArray)intentFilters.get("0");
                                    intentFilters.put(scheme, (Object)domainList);
                                    intentFilters.remove("0");
                                }
                            }
                            if (!"http".equals(attrValue) && !"https".equals(attrValue)) continue;
                            scheme = attrValue;
                            continue;
                        }
                        if ("host".equals(attrName)) {
                            String string = attrValue = attrValueSi != -1 ? this.compXmlString(xml, sitOff, stOff, attrValueSi) : BranchUtil.decodeResourceId(context, attrResId);
                            if (intentFilters.has(scheme) && scheme != null && !"https".equals(scheme) && !"http".equals(scheme)) {
                                domainList = intentFilters.getJSONArray(scheme);
                                domainList.put((Object)attrValue);
                                intentFilters.put(scheme, (Object)domainList);
                                continue;
                            }
                            if ("https".equals(scheme) || "http".equals(scheme)) {
                                applinkFilters.put((Object)attrValue);
                                continue;
                            }
                            domainList = new JSONArray();
                            domainList.put((Object)attrValue);
                            intentFilters.put("0", (Object)domainList);
                            continue;
                        }
                        if (!"name".equals(attrName)) continue;
                        String string = attrValue = attrValueSi != -1 ? this.compXmlString(xml, sitOff, stOff, attrValueSi) : BranchUtil.decodeResourceId(context, attrResId);
                        if (!"android.intent.action.VIEW".equals(attrValue)) continue;
                        scheme = null;
                    }
                    continue;
                }
                if (tag0 == 0x100103) {
                    off += 24;
                    continue;
                }
                if (tag0 == 0x100101) break;
            }
            intentFilters.remove("0");
            results.put(Defines.Jsonkey.URIScheme.getKey(), (Object)intentFilters);
            results.put(Defines.Jsonkey.AppLinks.getKey(), (Object)applinkFilters);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        return results;
    }

    private boolean validURI(String value) {
        return null != value && !"http".equals(value) && !value.equals("https") && !value.equals("geo") && !value.equals("*") && !value.equals("package") && !value.equals("sms") && !value.equals("smsto") && !value.equals("mms") && !value.equals("mmsto") && !value.equals("tel") && !value.equals("voicemail") && !value.equals("file") && !value.equals("content") && !value.equals("mailto");
    }

    private String compXmlString(byte[] xml, int sitOff, int stOff, int strInd) {
        if (strInd < 0) {
            return null;
        }
        int strOff = stOff + this.LEW(xml, sitOff + strInd * 4);
        return this.compXmlStringAt(xml, strOff);
    }

    private String compXmlStringAt(byte[] arr, int strOff) {
        int strLen = arr[strOff + 1] << 8 & 0xFF00 | arr[strOff] & 0xFF;
        byte[] chars = new byte[strLen];
        for (int ii = 0; ii < strLen; ++ii) {
            chars[ii] = arr[strOff + 2 + ii * 2];
        }
        return new String(chars);
    }

    private int LEW(byte[] arr, int off) {
        return arr[off + 3] << 24 & 0xFF000000 | arr[off + 2] << 16 & 0xFF0000 | arr[off + 1] << 8 & 0xFF00 | arr[off] & 0xFF;
    }
}

