/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.validators;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchUtil;
import io.branch.referral.validators.BranchIntegrationModel;
import io.branch.referral.validators.ServerRequestGetAppConfig;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class IntegrationValidator
implements ServerRequestGetAppConfig.IGetAppConfigEvents {
    private static IntegrationValidator instance;
    private final BranchIntegrationModel integrationModel;
    private final String TAG = "BranchSDK_Doctor";

    private IntegrationValidator(Context context) {
        this.integrationModel = new BranchIntegrationModel(context);
    }

    public static void validate(Context context) {
        if (instance == null) {
            instance = new IntegrationValidator(context);
        }
        instance.validateSDKIntegration(context);
    }

    private void validateSDKIntegration(Context context) {
        this.logValidationProgress("\n\n------------------- Initiating Branch integration verification ---------------------------");
        this.logValidationProgress("1. Verifying Branch instance creation");
        if (Branch.getInstance() == null) {
            this.logIntegrationError("Branch is not initialised from your Application class. Please add `Branch.getAutoInstance(this);` to your Application#onCreate() method.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-load-branch");
            return;
        }
        this.logValidationPassed();
        this.logValidationProgress("2. Checking Branch keys");
        if (TextUtils.isEmpty((CharSequence)BranchUtil.readBranchKey(context))) {
            this.logIntegrationError("Unable to read Branch keys from your application. Did you forget to add Branch keys in your application?.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
            return;
        }
        this.logValidationPassed();
        Branch.getInstance().requestQueue_.handleNewRequest(new ServerRequestGetAppConfig(context, this));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doValidateWithAppConfig(JSONObject branchAppConfig) {
        this.logValidationProgress("3. Verifying application package name");
        if (!this.integrationModel.packageName.equals(branchAppConfig.optString("android_package_name"))) {
            this.logIntegrationError("Incorrect package name in Branch dashboard. Please correct your package name in dashboard -> Configuration page.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-branch-dashboard");
            return;
        }
        this.logValidationPassed();
        this.logValidationProgress("4. Checking Android Manifest for URI based deep link config");
        if (this.integrationModel.deeplinkUriScheme == null || this.integrationModel.deeplinkUriScheme.length() == 0) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError(String.format("No intent found for opening the app through uri Scheme '%s'.Please add the intent with URI scheme to your Android manifest.", branchAppConfig.optString("android_uri_scheme")), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
                return;
            }
            this.logValidationProgress("- Skipping. Unable to verify the deep link config. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationProgress("5. Verifying URI based deep link config with Branch dash board.");
        String branchAppUriScheme = branchAppConfig.optString("android_uri_scheme");
        if (TextUtils.isEmpty((CharSequence)branchAppUriScheme)) {
            this.logIntegrationError("Uri Scheme to open your app is not specified in Branch dashboard. Please add URI scheme in Branch dashboard.", "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-branch-dashboard");
            return;
        }
        this.logValidationPassed();
        this.logValidationProgress("6. Verifying intent for receiving URI scheme.");
        if (!this.checkIfIntentAddedForURIScheme(branchAppUriScheme)) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError(String.format("Uri scheme '%s' specified in Branch dashboard doesn't match with the deep link intent in manifest file", branchAppUriScheme), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-branch-dashboard");
                return;
            }
            this.logValidationProgress("- Skipping. Unable to verify intent for receiving URI scheme. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationProgress("7. Checking AndroidManifest for AppLink config.");
        if (this.integrationModel.applinkScheme.isEmpty()) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError("Could not find any App Link hosts to support Android AppLinks. Please add intent filter for handling AppLinks in your Android Manifest file", "https://help.branch.io/using-branch/docs/android-app-links#section-add-intent-filter-to-manifest");
                return;
            }
            this.logValidationProgress("- Skipping. Unable to verify intent for receiving URI scheme. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationProgress("8. Verifying any supported custom link domains.");
        String customDomain = branchAppConfig.optString("short_url_domain");
        if (!TextUtils.isEmpty((CharSequence)customDomain) && !this.checkIfIntentAddedForLinkDomain(customDomain)) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError(String.format("Could not find intent filter to support custom link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", customDomain), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
                return;
            }
            this.logValidationProgress("- Skipping. Unable to verify supported custom link domains. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationProgress("9. Verifying default link domains integrations.");
        String defAppLinkDomain = branchAppConfig.optString("default_short_url_domain");
        if (!TextUtils.isEmpty((CharSequence)defAppLinkDomain) && !this.checkIfIntentAddedForLinkDomain(defAppLinkDomain)) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError(String.format("Could not find intent filter to support Branch default link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", defAppLinkDomain), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
                return;
            }
            this.logValidationProgress("- Skipping. Unable to verify default link domains. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationProgress("10. Verifying alternate link domains integrations.");
        String alternateAppLinkDomain = branchAppConfig.optString("alternate_short_url_domain");
        if (!TextUtils.isEmpty((CharSequence)alternateAppLinkDomain) && !this.checkIfIntentAddedForLinkDomain(alternateAppLinkDomain)) {
            if (this.integrationModel.appSettingsAvailable) {
                this.logIntegrationError(String.format("Could not find intent filter to support alternate link domain '%s'. Please add intent filter for handling custom link domain in your Android Manifest file ", alternateAppLinkDomain), "https://help.branch.io/developers-hub/docs/android-basic-integration#section-configure-app");
                return;
            }
            this.logValidationProgress("- Skipping.Unable to verify alternate link domains. Failed to read the Android Manifest");
        } else {
            this.logValidationPassed();
        }
        this.logValidationPassed();
        Log.d((String)"BranchSDK_Doctor", (String)"--------------------------------------------\nSuccessfully completed Branch integration validation. Everything looks good!");
        Log.d((String)"BranchSDK_Doctor", (String)"\n         Great! Comment out the 'validateSDKIntegration' line in your app. Next check your deep link routing.\n         Append '?bnc_validate=true' to any of your app's Branch links and click it on your mobile device (not the Simulator!) to start the test.\n         For instance, to validate a link like:\n         https://<yourapp>.app.link/NdJ6nFzRbK\n         click on:\n         https://<yourapp>.app.link/NdJ6nFzRbK?bnc_validate=true");
    }

    private boolean checkIfIntentAddedForURIScheme(String uriScheme) {
        Uri branchDeepLinkURI = Uri.parse((String)uriScheme);
        String uriHost = branchDeepLinkURI.getScheme();
        String uriPath = branchDeepLinkURI.getHost();
        uriPath = TextUtils.isEmpty((CharSequence)uriPath) ? "open" : uriPath;
        boolean foundMatchingUri = false;
        if (this.integrationModel.deeplinkUriScheme != null) {
            Iterator it = this.integrationModel.deeplinkUriScheme.keys();
            block0: while (it.hasNext()) {
                String key = (String)it.next();
                if (uriHost == null || !uriHost.equals(key)) continue;
                JSONArray hosts = this.integrationModel.deeplinkUriScheme.optJSONArray(key);
                if (hosts != null && hosts.length() > 0) {
                    for (int i = 0; i < hosts.length(); ++i) {
                        if (uriPath == null || !uriPath.equals(hosts.optString(i))) continue;
                        foundMatchingUri = true;
                        continue block0;
                    }
                    continue;
                }
                foundMatchingUri = true;
                break;
            }
        }
        return foundMatchingUri;
    }

    private boolean checkIfIntentAddedForLinkDomain(String domainName) {
        boolean foundIntentFilterMatchingDomainName = false;
        if (!TextUtils.isEmpty((CharSequence)domainName) && this.integrationModel.applinkScheme != null) {
            for (String host : this.integrationModel.applinkScheme) {
                if (!domainName.equals(host)) continue;
                foundIntentFilterMatchingDomainName = true;
                break;
            }
        }
        return foundIntentFilterMatchingDomainName;
    }

    @Override
    public void onAppConfigAvailable(JSONObject branchAppConfig) {
        if (branchAppConfig != null) {
            this.doValidateWithAppConfig(branchAppConfig);
        } else {
            this.logIntegrationError("Unable to read Dashboard config. Please confirm that your Branch key is properly added to the manifest. Please fix your Dashboard settings.", "https://branch.app.link/link-settings-page");
        }
    }

    private void logIntegrationError(String message, String documentLink) {
        Log.d((String)"BranchSDK_Doctor", (String)("** ERROR ** : " + message + "\nPlease follow the link for more info " + documentLink));
    }

    private void logValidationProgress(String message) {
        Log.d((String)"BranchSDK_Doctor", (String)(message + " ... "));
    }

    private void logValidationPassed() {
        Log.d((String)"BranchSDK_Doctor", (String)"Passed");
    }
}

