/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.network;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.TrafficStats;
import android.os.Build;
import android.os.NetworkOnMainThreadException;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.common.util.Strings;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.network.BranchRemoteInterface;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchRemoteInterfaceUrlConnection
extends BranchRemoteInterface {
    private static final int THREAD_TAG_POST = 102;
    @NonNull
    private final Branch branch;
    private int lastResponseCode = -1;
    private String lastResponseMessage = "";
    private String lastRequestId = "";
    private PrefHelper prefHelper;
    private int retryLimit;

    public BranchRemoteInterfaceUrlConnection(@NonNull Branch branch) {
        this.branch = branch;
        this.prefHelper = PrefHelper.getInstance(branch.getApplicationContext());
        this.retryLimit = this.prefHelper.getRetryCount();
    }

    @Override
    public BranchRemoteInterface.BranchResponse doRestfulGet(String url) throws BranchRemoteInterface.BranchRemoteException {
        return this.doRestfulGet(url, 0);
    }

    @Override
    public BranchRemoteInterface.BranchResponse doRestfulPost(String url, JSONObject payload) throws BranchRemoteInterface.BranchRemoteException {
        return this.doRestfulPost(url, payload, 0);
    }

    private BranchRemoteInterface.BranchResponse doRestfulGet(String url, int retryNumber) throws BranchRemoteInterface.BranchRemoteException {
        HttpURLConnection connection = null;
        PrefHelper prefHelper = PrefHelper.getInstance(this.branch.getApplicationContext());
        try {
            BranchRemoteInterface.BranchResponse result;
            int timeout = prefHelper.getTimeout();
            int connectTimeout = prefHelper.getConnectTimeout();
            String appendKey = url.contains("?") ? "&" : "?";
            String modifiedUrl = url + appendKey + "retryNumber" + "=" + retryNumber;
            URL urlObject = new URL(modifiedUrl);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(connectTimeout);
            connection.setReadTimeout(timeout);
            String requestId = connection.getHeaderField(Defines.HeaderKey.RequestId.getKey());
            int responseCode = connection.getResponseCode();
            if (responseCode >= 500 && retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    BranchLogger.e(this.getNetworkErrorMessage(e, url, retryNumber));
                }
                BranchRemoteInterface.BranchResponse e = this.doRestfulGet(url, ++retryNumber);
                return e;
            }
            try {
                result = responseCode != 200 && connection.getErrorStream() != null ? new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getErrorStream()), responseCode) : new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getInputStream()), responseCode);
            }
            catch (FileNotFoundException ex) {
                BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
                result = new BranchRemoteInterface.BranchResponse(null, responseCode);
            }
            result.requestId = Strings.emptyToNull((String)requestId);
            BranchRemoteInterface.BranchResponse branchResponse = result;
            return branchResponse;
        }
        catch (SocketException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            throw new BranchRemoteInterface.BranchRemoteException(-113, ex.getMessage());
        }
        catch (SocketTimeoutException ex) {
            if (retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    BranchLogger.e(this.getNetworkErrorMessage(e, url, retryNumber));
                }
                BranchRemoteInterface.BranchResponse e = this.doRestfulGet(url, ++retryNumber);
                return e;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-111, ex.getMessage());
        }
        catch (InterruptedIOException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            if (retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e) {
                    BranchLogger.e(this.getNetworkErrorMessage(e, url, retryNumber));
                }
                BranchRemoteInterface.BranchResponse branchResponse = this.doRestfulGet(url, ++retryNumber);
                return branchResponse;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-120, ex.getMessage());
        }
        catch (IOException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            throw new BranchRemoteInterface.BranchRemoteException(-113, ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                this.resetStats();
            }
        }
    }

    private BranchRemoteInterface.BranchResponse doRestfulPost(String url, JSONObject payload, int retryNumber) throws BranchRemoteInterface.BranchRemoteException {
        BranchRemoteInterface.BranchResponse e5;
        HttpURLConnection connection = null;
        PrefHelper prefHelper = PrefHelper.getInstance(this.branch.getApplicationContext());
        int timeout = prefHelper.getTimeout();
        int connectTimeout = prefHelper.getConnectTimeout();
        try {
            payload.put("retryNumber", retryNumber);
        }
        catch (JSONException e2) {
            BranchLogger.e("Caught JSONException, retry number: " + retryNumber + " " + e2.getMessage() + " stacktrace: " + BranchLogger.stackTraceToString((Exception)((Object)e2)));
        }
        try {
            BranchRemoteInterface.BranchResponse result;
            int responseCode;
            String requestId;
            if (Build.VERSION.SDK_INT >= 26) {
                TrafficStats.setThreadStatsTag((int)102);
            }
            URL urlObject = new URL(url);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(connectTimeout);
            connection.setReadTimeout(timeout);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (url.contains(Defines.Jsonkey.QRCodeTag.getKey())) {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Accept", "image/*");
            } else {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
            }
            connection.setRequestMethod("POST");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(payload.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
            this.lastRequestId = requestId = connection.getHeaderField(Defines.HeaderKey.RequestId.getKey());
            this.lastResponseCode = responseCode = connection.getResponseCode();
            this.lastResponseMessage = connection.getResponseMessage();
            BranchLogger.d("lastResponseMessage " + this.lastResponseMessage);
            if (responseCode >= 500 && retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e3) {
                    BranchLogger.e(this.getNetworkErrorMessage(e3, url, retryNumber));
                }
                BranchRemoteInterface.BranchResponse e3 = this.doRestfulPost(url, payload, ++retryNumber);
                return e3;
            }
            try {
                if (responseCode != 200 && connection.getErrorStream() != null) {
                    BranchLogger.e("Branch Networking Error: \nURL: " + url + "\nResponse Code: " + this.lastResponseCode + "\nResponse Message: " + this.lastResponseMessage + "\nRetry number: " + retryNumber + "\nFinal attempt: true\nrequestId: " + this.lastRequestId + "\nObject: " + this);
                    result = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getErrorStream()), responseCode);
                } else {
                    if (url.contains(Defines.Jsonkey.QRCodeTag.getKey())) {
                        InputStream inputStream = connection.getInputStream();
                        Bitmap bmp = BitmapFactory.decodeStream((InputStream)inputStream);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                        byte[] b = baos.toByteArray();
                        String bmpString = Base64.encodeToString((byte[])b, (int)0);
                        result = new BranchRemoteInterface.BranchResponse(bmpString, responseCode);
                    } else {
                        result = new BranchRemoteInterface.BranchResponse(this.getResponseString(connection.getInputStream()), responseCode);
                    }
                    BranchLogger.v("Branch Networking Success\nURL: " + url + "\nResponse Code: " + this.lastResponseCode + "\nResponse Message: " + this.lastResponseMessage + "\nRetry number: " + retryNumber + "\nrequestId: " + this.lastRequestId + "\nObject: " + this);
                }
            }
            catch (FileNotFoundException ex) {
                BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
                result = new BranchRemoteInterface.BranchResponse(null, responseCode);
            }
            result.requestId = requestId;
            BranchRemoteInterface.BranchResponse branchResponse = result;
            return branchResponse;
        }
        catch (SocketTimeoutException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            if (retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e4) {
                    BranchLogger.e(this.getNetworkErrorMessage(e4, url, retryNumber));
                }
                e5 = this.doRestfulPost(url, payload, ++retryNumber);
                return e5;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-111, ex.getMessage());
        }
        catch (InterruptedIOException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            if (retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e5) {
                    BranchLogger.e(this.getNetworkErrorMessage(e5, url, retryNumber));
                }
                e5 = this.doRestfulPost(url, payload, ++retryNumber);
                return e5;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-120, ex.getMessage());
        }
        catch (IOException ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            if (retryNumber < this.retryLimit) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e6) {
                    BranchLogger.e(this.getNetworkErrorMessage(e6, url, retryNumber));
                }
                BranchRemoteInterface.BranchResponse branchResponse = this.doRestfulPost(url, payload, ++retryNumber);
                return branchResponse;
            }
            throw new BranchRemoteInterface.BranchRemoteException(-113, ex.getMessage());
        }
        catch (Exception ex) {
            BranchLogger.e(this.getNetworkErrorMessage(ex, url, retryNumber));
            if (ex instanceof NetworkOnMainThreadException) {
                BranchLogger.e("Cannot make network request on main thread.");
                throw new BranchRemoteInterface.BranchRemoteException(-121, ex.getMessage());
            }
            throw new BranchRemoteInterface.BranchRemoteException(-122, ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                this.resetStats();
            }
        }
    }

    private void resetStats() {
        this.lastRequestId = "";
        this.lastResponseCode = -1;
        this.lastResponseMessage = "";
    }

    private String getResponseString(InputStream inputStream) {
        String responseString = null;
        if (inputStream != null) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                responseString = sb.toString();
            }
            catch (IOException e) {
                BranchLogger.d(e.getMessage());
            }
        }
        return responseString;
    }

    String getNetworkErrorMessage(Exception e, String url, int retry) {
        return "Branch Networking Error: \nURL: " + url + "\nResponse Code: " + this.lastResponseCode + "\nResponse Message: " + this.lastResponseMessage + "\nCaught exception type: " + e.getClass().getCanonicalName() + "\nRetry number: " + retry + "\nrequestId: " + this.lastRequestId + "\nFinal attempt: " + (retry >= this.retryLimit) + "\nObject: " + this + "\nException Message: " + e.getMessage() + "\nStacktrace: " + BranchLogger.stackTraceToString(e);
    }
}

