/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.network;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.ServerResponse;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BranchRemoteInterface {
    public static final String RETRY_NUMBER = "retryNumber";

    public abstract BranchResponse doRestfulGet(String var1) throws BranchRemoteException;

    public abstract BranchResponse doRestfulPost(String var1, JSONObject var2) throws BranchRemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerResponse make_restful_get(String url, JSONObject params, String tag, String branchKey) {
        String modifiedUrl = url;
        JSONObject jSONObject = params = params != null ? params : new JSONObject();
        if (!this.addCommonParams(params, branchKey)) {
            return new ServerResponse(tag, -114, "", "");
        }
        modifiedUrl = modifiedUrl + this.convertJSONtoString(params);
        long reqStartTime = System.currentTimeMillis();
        BranchLogger.v("getting " + modifiedUrl);
        try {
            BranchResponse response = this.doRestfulGet(modifiedUrl);
            ServerResponse serverResponse = this.processEntityForJSON(response, tag, response.requestId);
            return serverResponse;
        }
        catch (BranchRemoteException branchError) {
            ServerResponse serverResponse = new ServerResponse(tag, branchError.branchErrorCode, "", branchError.branchErrorMessage);
            return serverResponse;
        }
        finally {
            if (Branch.getInstance() != null) {
                int brttVal = (int)(System.currentTimeMillis() - reqStartTime);
                Branch.getInstance().requestQueue_.addExtraInstrumentationData(tag + "-" + Defines.Jsonkey.Branch_Round_Trip_Time.getKey(), String.valueOf(brttVal));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerResponse make_restful_post(JSONObject body, String url, String tag, String branchKey) {
        long reqStartTime = System.currentTimeMillis();
        JSONObject jSONObject = body = body != null ? body : new JSONObject();
        if (!this.addCommonParams(body, branchKey)) {
            return new ServerResponse(tag, -114, "", "");
        }
        BranchLogger.v("posting to " + url);
        BranchLogger.v("Post value = " + body.toString());
        try {
            BranchResponse response = this.doRestfulPost(url, body);
            ServerResponse serverResponse = this.processEntityForJSON(response, tag, response.requestId);
            return serverResponse;
        }
        catch (BranchRemoteException branchError) {
            ServerResponse serverResponse = new ServerResponse(tag, branchError.branchErrorCode, "", branchError.branchErrorMessage);
            return serverResponse;
        }
        finally {
            if (Branch.getInstance() != null) {
                int brttVal = (int)(System.currentTimeMillis() - reqStartTime);
                Branch.getInstance().requestQueue_.addExtraInstrumentationData(tag + "-" + Defines.Jsonkey.Branch_Round_Trip_Time.getKey(), String.valueOf(brttVal));
            }
        }
    }

    private ServerResponse processEntityForJSON(BranchResponse response, String tag, String requestId) {
        ServerResponse result;
        block10: {
            String responseString = response.responseData;
            int statusCode = response.responseCode;
            result = new ServerResponse(tag, statusCode, requestId, "");
            if (!TextUtils.isEmpty((CharSequence)requestId)) {
                BranchLogger.v(String.format(Locale.getDefault(), "Server returned: [%s] Status: [%d]; Data: %s", requestId, statusCode, responseString));
            } else {
                BranchLogger.v(String.format("returned %s", responseString));
            }
            if (responseString != null) {
                try {
                    JSONObject jsonObj = new JSONObject(responseString);
                    result.setPost(jsonObj);
                }
                catch (JSONException ex) {
                    try {
                        JSONArray jsonArray = new JSONArray(responseString);
                        result.setPost(jsonArray);
                    }
                    catch (JSONException ex2) {
                        if (tag.contains(Defines.Jsonkey.QRCodeTag.getKey())) {
                            try {
                                JSONObject jsonObj = new JSONObject();
                                jsonObj.put(Defines.Jsonkey.QRCodeResponseString.getKey(), (Object)responseString);
                                result.setPost(jsonObj);
                            }
                            catch (JSONException e) {
                                BranchLogger.w("Caught JSONException " + e.getMessage());
                            }
                            break block10;
                        }
                        BranchLogger.w("Caught JSONException " + ex2.getMessage());
                    }
                }
            }
        }
        return result;
    }

    private boolean addCommonParams(JSONObject post, String branch_key) {
        try {
            if (!post.has(Defines.Jsonkey.UserData.getKey())) {
                post.put(Defines.Jsonkey.SDK.getKey(), (Object)("android" + Branch.getSdkVersionNumber()));
            }
            if (!branch_key.equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.BranchKey.getKey(), (Object)branch_key);
                return true;
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        return false;
    }

    private String convertJSONtoString(JSONObject json) {
        JSONArray names;
        StringBuilder result = new StringBuilder();
        if (json != null && (names = json.names()) != null) {
            boolean first = true;
            int size = names.length();
            for (int i = 0; i < size; ++i) {
                try {
                    String key = names.getString(i);
                    if (first) {
                        result.append("?");
                        first = false;
                    } else {
                        result.append("&");
                    }
                    String value = json.getString(key);
                    result.append(key).append("=").append(value);
                    continue;
                }
                catch (JSONException e) {
                    BranchLogger.w("Caught JSONException " + e.getMessage());
                    return null;
                }
            }
        }
        return result.toString();
    }

    public static class BranchResponse {
        private final String responseData;
        private final int responseCode;
        String requestId;

        public BranchResponse(@Nullable String responseData, int responseCode) {
            this.responseData = responseData;
            this.responseCode = responseCode;
        }
    }

    public static class BranchRemoteException
    extends Exception {
        private int branchErrorCode;
        private String branchErrorMessage;

        public BranchRemoteException(int errorCode) {
            this.branchErrorCode = errorCode;
        }

        public BranchRemoteException(int errorCode, String errorMessage) {
            this.branchErrorCode = errorCode;
            this.branchErrorMessage = errorMessage;
        }
    }
}

