/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchJsonConfig {
    private JSONObject mConfiguration = null;
    public static final String TAG = "BranchJsonConfig";
    private static final String fileName = "branch.json";
    private static BranchJsonConfig instance;

    private BranchJsonConfig(Context context) {
        try {
            String line;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(context.getAssets().open(fileName)));
            }
            catch (FileNotFoundException e) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            this.mConfiguration = new JSONObject(builder.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error loading branch.json: " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + e.getMessage()));
        }
    }

    public static BranchJsonConfig getInstance(@NonNull Context context) {
        if (instance == null) {
            instance = new BranchJsonConfig(context);
        }
        return instance;
    }

    public boolean isValid() {
        return this.mConfiguration != null;
    }

    public boolean isValid(BranchJsonKey key) {
        return this.mConfiguration != null && this.mConfiguration.has(key.toString());
    }

    @Nullable
    public Object get(BranchJsonKey key) {
        if (!this.isValid(key)) {
            return null;
        }
        try {
            return this.mConfiguration.get(key.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return null;
        }
    }

    @Nullable
    public Boolean getEnableLogging() {
        if (!this.isValid(BranchJsonKey.enableLogging)) {
            return null;
        }
        try {
            return this.mConfiguration.getBoolean(BranchJsonKey.enableLogging.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return false;
        }
    }

    @Nullable
    public Boolean getDeferInitForPluginRuntime() {
        if (!this.isValid(BranchJsonKey.deferInitForPluginRuntime)) {
            return null;
        }
        try {
            return this.mConfiguration.getBoolean(BranchJsonKey.deferInitForPluginRuntime.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return false;
        }
    }

    @Nullable
    public String getBranchKey() {
        if (this.isValid(BranchJsonKey.branchKey) || this.isValid(BranchJsonKey.liveKey) && this.isValid(BranchJsonKey.testKey) && this.isValid(BranchJsonKey.useTestInstance)) {
            try {
                if (this.isValid(BranchJsonKey.branchKey)) {
                    return this.mConfiguration.getString(BranchJsonKey.branchKey.toString());
                }
                return this.getUseTestInstance() != false ? this.getTestKey() : this.getLiveKey();
            }
            catch (JSONException exception) {
                Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
                return null;
            }
        }
        return null;
    }

    @Nullable
    private String getLiveKey() {
        if (!this.isValid(BranchJsonKey.liveKey)) {
            return null;
        }
        try {
            return this.mConfiguration.getString(BranchJsonKey.liveKey.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return null;
        }
    }

    @Nullable
    private String getTestKey() {
        if (this.mConfiguration == null) {
            return null;
        }
        try {
            if (!this.mConfiguration.has(BranchJsonKey.testKey.toString())) {
                return null;
            }
            return this.mConfiguration.getString(BranchJsonKey.testKey.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return null;
        }
    }

    @Nullable
    public Boolean getUseTestInstance() {
        if (!this.isValid(BranchJsonKey.useTestInstance)) {
            return null;
        }
        try {
            return this.mConfiguration.getBoolean(BranchJsonKey.useTestInstance.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return false;
        }
    }

    @Nullable
    public String getAPIUrl() {
        if (this.mConfiguration == null) {
            return null;
        }
        try {
            if (!this.mConfiguration.has(BranchJsonKey.apiUrl.toString())) {
                return null;
            }
            return this.mConfiguration.getString(BranchJsonKey.apiUrl.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return null;
        }
    }

    @Nullable
    public String getFbAppId() {
        if (this.mConfiguration == null) {
            return null;
        }
        try {
            if (!this.mConfiguration.has(BranchJsonKey.fbAppId.toString())) {
                return null;
            }
            return this.mConfiguration.getString(BranchJsonKey.fbAppId.toString());
        }
        catch (JSONException exception) {
            Log.e((String)TAG, (String)("Error parsing branch.json: " + exception.getMessage()));
            return null;
        }
    }

    public static enum BranchJsonKey {
        branchKey,
        testKey,
        liveKey,
        useTestInstance,
        enableLogging,
        deferInitForPluginRuntime,
        apiUrl,
        fbAppId;

    }
}

