/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ProductDetails;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryProductDetailsParams;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.util.BRANCH_STANDARD_EVENT;
import io.branch.referral.util.BranchContentSchema;
import io.branch.referral.util.BranchEvent;
import io.branch.referral.util.ContentMetadata;
import io.branch.referral.util.CurrencyType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010!\u001a\u00020\f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/branch/referral/BillingGooglePlay;", "", "()V", "billingClient", "Lcom/android/billingclient/api/BillingClient;", "getBillingClient", "()Lcom/android/billingclient/api/BillingClient;", "setBillingClient", "(Lcom/android/billingclient/api/BillingClient;)V", "purchasesUpdatedListener", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "createAndLogEventForPurchase", "", "context", "Landroid/content/Context;", "purchase", "Lcom/android/billingclient/api/Purchase;", "contentItems", "", "Lio/branch/indexing/BranchUniversalObject;", "currency", "Lio/branch/referral/util/CurrencyType;", "revenue", "", "productType", "", "createBUOWithInAppProductDetails", "product", "Lcom/android/billingclient/api/ProductDetails;", "quantity", "", "createBUOWithSubsProductDetails", "logEventWithPurchase", "startBillingClient", "callback", "Lkotlin/Function1;", "", "Companion", "Branch-SDK_release"})
public final class BillingGooglePlay {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public BillingClient billingClient;
    @NotNull
    private final PurchasesUpdatedListener purchasesUpdatedListener = BillingGooglePlay::purchasesUpdatedListener$lambda-0;
    private static volatile BillingGooglePlay instance;

    private BillingGooglePlay() {
    }

    @NotNull
    public final BillingClient getBillingClient() {
        BillingClient billingClient = this.billingClient;
        if (billingClient != null) {
            return billingClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"billingClient");
        return null;
    }

    public final void setBillingClient(@NotNull BillingClient billingClient) {
        Intrinsics.checkNotNullParameter((Object)billingClient, (String)"<set-?>");
        this.billingClient = billingClient;
    }

    public final void startBillingClient(@NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.getBillingClient().isReady()) {
            BranchLogger.v("Billing Client has already been started..");
            callback.invoke((Object)true);
        } else {
            this.getBillingClient().startConnection(new BillingClientStateListener(callback){
                final /* synthetic */ Function1<Boolean, Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onBillingSetupFinished(@NotNull BillingResult billingResult) {
                    Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
                    if (billingResult.getResponseCode() == 0) {
                        BranchLogger.v("Billing Client setup finished.");
                        this.$callback.invoke((Object)true);
                    } else {
                        String errorMessage = "Billing Client setup failed with error: " + billingResult.getDebugMessage();
                        BranchLogger.e(errorMessage);
                        this.$callback.invoke((Object)false);
                    }
                }

                public void onBillingServiceDisconnected() {
                    BranchLogger.w("Billing Client disconnected");
                    this.$callback.invoke((Object)false);
                }
            });
        }
    }

    public final void logEventWithPurchase(@NotNull Context context, @NotNull Purchase purchase) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
        List list = purchase.getProducts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"purchase.products");
        List productIds = list;
        List productList = new ArrayList();
        List subsList = new ArrayList();
        for (String productId : productIds) {
            QueryProductDetailsParams.Product subsProduct;
            QueryProductDetailsParams.Product inAppProduct;
            QueryProductDetailsParams.Product.Builder builder = QueryProductDetailsParams.Product.newBuilder();
            String string = productId;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)builder.setProductId(string).setProductType("inapp").build(), (String)"newBuilder()\n           \u2026\n                .build()");
            productList.add(inAppProduct);
            Intrinsics.checkNotNullExpressionValue((Object)QueryProductDetailsParams.Product.newBuilder().setProductId(productId).setProductType("subs").build(), (String)"newBuilder()\n           \u2026\n                .build()");
            subsList.add(subsProduct);
        }
        QueryProductDetailsParams queryProductDetailsParams = QueryProductDetailsParams.newBuilder().setProductList(productList).build();
        Intrinsics.checkNotNullExpressionValue((Object)queryProductDetailsParams, (String)"newBuilder()\n           \u2026ist)\n            .build()");
        QueryProductDetailsParams queryProductDetailsParams2 = queryProductDetailsParams;
        QueryProductDetailsParams queryProductDetailsParams3 = QueryProductDetailsParams.newBuilder().setProductList(subsList).build();
        Intrinsics.checkNotNullExpressionValue((Object)queryProductDetailsParams3, (String)"newBuilder()\n           \u2026ist)\n            .build()");
        QueryProductDetailsParams querySubsProductDetailsParams = queryProductDetailsParams3;
        this.getBillingClient().queryProductDetailsAsync(querySubsProductDetailsParams, (arg_0, arg_1) -> BillingGooglePlay.logEventWithPurchase$lambda-1(this, context, purchase, arg_0, arg_1));
        this.getBillingClient().queryProductDetailsAsync(queryProductDetailsParams2, (arg_0, arg_1) -> BillingGooglePlay.logEventWithPurchase$lambda-2(purchase, this, context, arg_0, arg_1));
    }

    private final BranchUniversalObject createBUOWithSubsProductDetails(ProductDetails product) {
        if (product != null) {
            CurrencyType currencyType;
            ProductDetails.PricingPhase pricingPhaseList;
            List list = product.getSubscriptionOfferDetails();
            ProductDetails.PricingPhase pricingPhase = pricingPhaseList = list != null && (list = (ProductDetails.SubscriptionOfferDetails)list.get(0)) != null && (list = list.getPricingPhases()) != null && (list = list.getPricingPhaseList()) != null ? (ProductDetails.PricingPhase)list.get(0) : null;
            if (pricingPhase != null) {
                ProductDetails.PricingPhase it = pricingPhase;
                boolean bl = false;
                String string = it.getPriceCurrencyCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.priceCurrencyCode");
                currencyType = CurrencyType.valueOf(string);
            } else {
                currencyType = null;
            }
            CurrencyType currency = currencyType;
            ProductDetails.PricingPhase pricingPhase2 = pricingPhaseList;
            Double price = pricingPhase2 != null ? Double.valueOf((double)pricingPhase2.getPriceAmountMicros() / 1000000.0) : null;
            BranchUniversalObject buo = new BranchUniversalObject().setCanonicalIdentifier(product.getProductId()).setTitle(product.getTitle());
            ContentMetadata contentMetadata = new ContentMetadata().addCustomMetadata("product_type", product.getProductType()).setProductName(product.getName()).setQuantity(1.0).setContentSchema(BranchContentSchema.COMMERCE_PRODUCT);
            if (price != null && currency != null) {
                contentMetadata.setPrice(price, currency);
            }
            buo.setContentMetadata(contentMetadata);
            Intrinsics.checkNotNullExpressionValue((Object)buo, (String)"buo");
            return buo;
        }
        return new BranchUniversalObject();
    }

    private final BranchUniversalObject createBUOWithInAppProductDetails(ProductDetails product, int quantity) {
        if (product != null) {
            CurrencyType currencyType;
            Object object = product.getOneTimePurchaseOfferDetails();
            if (object != null && (object = object.getPriceCurrencyCode()) != null) {
                Object it = object;
                boolean bl = false;
                currencyType = CurrencyType.valueOf((String)it);
            } else {
                currencyType = null;
            }
            CurrencyType currency = currencyType;
            ProductDetails.OneTimePurchaseOfferDetails oneTimePurchaseOfferDetails = product.getOneTimePurchaseOfferDetails();
            Double price = oneTimePurchaseOfferDetails != null ? Double.valueOf((double)oneTimePurchaseOfferDetails.getPriceAmountMicros() / 1000000.0) : null;
            BranchUniversalObject buo = new BranchUniversalObject().setCanonicalIdentifier(product.getProductId()).setTitle(product.getTitle());
            ContentMetadata contentMetadata = new ContentMetadata().addCustomMetadata("product_type", product.getProductType()).setProductName(product.getName()).setQuantity(Double.valueOf(quantity)).setContentSchema(BranchContentSchema.COMMERCE_PRODUCT);
            if (price != null && currency != null) {
                contentMetadata.setPrice(price, currency);
            }
            buo.setContentMetadata(contentMetadata);
            Intrinsics.checkNotNullExpressionValue((Object)buo, (String)"buo");
            return buo;
        }
        return new BranchUniversalObject();
    }

    public final void createAndLogEventForPurchase(@NotNull Context context, @NotNull Purchase purchase, @NotNull List<? extends BranchUniversalObject> contentItems, @NotNull CurrencyType currency, double revenue, @NotNull String productType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
        Intrinsics.checkNotNullParameter(contentItems, (String)"contentItems");
        Intrinsics.checkNotNullParameter((Object)((Object)currency), (String)"currency");
        Intrinsics.checkNotNullParameter((Object)productType, (String)"productType");
        new BranchEvent(BRANCH_STANDARD_EVENT.PURCHASE).setCurrency(currency).setDescription(purchase.getOrderId()).setCustomerEventAlias(productType).setRevenue(revenue).addCustomDataProperty("package_name", purchase.getPackageName()).addCustomDataProperty("order_id", purchase.getOrderId()).addCustomDataProperty("logged_from_IAP", "true").addCustomDataProperty("is_auto_renewing", String.valueOf(purchase.isAutoRenewing())).addCustomDataProperty("purchase_token", purchase.getPurchaseToken()).addContentItems(contentItems).logEvent(context);
        BranchLogger.i("Successfully logged in-app purchase as Branch Event");
    }

    private static final void purchasesUpdatedListener$lambda-0(BillingResult billingResult, List list) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"<anonymous parameter 0>");
    }

    private static final void logEventWithPurchase$lambda-1(BillingGooglePlay this$0, Context $context, Purchase $purchase, BillingResult billingResult, List subsProductDetailsList) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$purchase, (String)"$purchase");
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        Intrinsics.checkNotNullParameter((Object)subsProductDetailsList, (String)"subsProductDetailsList");
        if (billingResult.getResponseCode() == 0) {
            List contentItemBUOs = new ArrayList();
            CurrencyType currency = CurrencyType.USD;
            double revenue = 0.0;
            for (ProductDetails product : subsProductDetailsList) {
                BranchUniversalObject buo = this$0.createBUOWithSubsProductDetails(product);
                contentItemBUOs.add(buo);
                Double d = buo.getContentMetadata().price;
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"buo.contentMetadata.price");
                revenue += ((Number)d).doubleValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)buo.getContentMetadata().currencyType), (String)"buo.contentMetadata.currencyType");
            }
            if (!((Collection)contentItemBUOs).isEmpty()) {
                this$0.createAndLogEventForPurchase($context, $purchase, contentItemBUOs, currency, revenue, "subs");
            }
        } else {
            BranchLogger.e("Failed to query subscriptions. Error: " + billingResult.getDebugMessage());
        }
    }

    private static final void logEventWithPurchase$lambda-2(Purchase $purchase, BillingGooglePlay this$0, Context $context, BillingResult billingResult, List productDetailsList) {
        Intrinsics.checkNotNullParameter((Object)$purchase, (String)"$purchase");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        Intrinsics.checkNotNullParameter((Object)productDetailsList, (String)"productDetailsList");
        if (billingResult.getResponseCode() == 0) {
            List contentItemBUOs = new ArrayList();
            CurrencyType currency = CurrencyType.USD;
            double revenue = 0.0;
            int quantity = $purchase.getQuantity();
            for (ProductDetails product : productDetailsList) {
                BranchUniversalObject buo = this$0.createBUOWithInAppProductDetails(product, quantity);
                contentItemBUOs.add(buo);
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(buo.getContentMetadata().price)).multiply(new BigDecimal(String.valueOf(quantity)));
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.multiply(other)");
                revenue += bigDecimal.doubleValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)buo.getContentMetadata().currencyType), (String)"buo.contentMetadata.currencyType");
            }
            if (!((Collection)contentItemBUOs).isEmpty()) {
                this$0.createAndLogEventForPurchase($context, $purchase, contentItemBUOs, currency, revenue, "inapp");
            }
        } else {
            BranchLogger.e("Failed to query subscriptions. Error: " + billingResult.getDebugMessage());
        }
    }

    public /* synthetic */ BillingGooglePlay(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/branch/referral/BillingGooglePlay$Companion;", "", "()V", "instance", "Lio/branch/referral/BillingGooglePlay;", "getInstance", "Branch-SDK_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BillingGooglePlay getInstance() {
            Companion companion = this;
            synchronized (companion) {
                BillingGooglePlay billingGooglePlay;
                boolean bl = false;
                if (instance == null) {
                    instance = new BillingGooglePlay(null);
                    BillingGooglePlay billingGooglePlay2 = instance;
                    if (billingGooglePlay2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                        billingGooglePlay2 = null;
                    }
                    BillingClient.Builder builder = BillingClient.newBuilder((Context)Branch.getInstance().getApplicationContext());
                    BillingGooglePlay billingGooglePlay3 = instance;
                    if (billingGooglePlay3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                        billingGooglePlay3 = null;
                    }
                    BillingClient billingClient = builder.setListener(billingGooglePlay3.purchasesUpdatedListener).enablePendingPurchases().build();
                    Intrinsics.checkNotNullExpressionValue((Object)billingClient, (String)"newBuilder(Branch.getIns\u2026                 .build()");
                    billingGooglePlay2.setBillingClient(billingClient);
                }
                if ((billingGooglePlay = instance) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                    billingGooglePlay = null;
                }
                BillingGooglePlay billingGooglePlay4 = billingGooglePlay;
                return billingGooglePlay4;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

