/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;

public class AnimatedDialog
extends Dialog {
    private boolean isClosing_ = false;
    private final boolean isFullWidthStyle_;

    public AnimatedDialog(Context context, boolean isFullWidthStyle) {
        super(context);
        this.isFullWidthStyle_ = isFullWidthStyle;
        this.init(context);
    }

    public AnimatedDialog(Context context, int theme) {
        super(context, theme);
        this.isFullWidthStyle_ = false;
        this.init(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isFullWidthStyle_) {
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            params.width = -1;
            this.getWindow().setAttributes(params);
        }
    }

    public void show() {
        this.slideOpen();
    }

    public void cancel() {
        this.slideClose();
    }

    public void setContentView(int layoutResID) {
        this.setDialogWindowAttributes();
        super.setContentView(layoutResID);
    }

    private void init(Context context) {
        this.setDialogWindowAttributes();
        this.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    AnimatedDialog.this.slideClose();
                }
                return true;
            }
        });
    }

    public void setDialogWindowAttributes() {
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().addFlags(2);
        this.getWindow().addFlags(1024);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 80;
        lp.dimAmount = 0.8f;
        this.getWindow().setAttributes(lp);
        this.getWindow().setWindowAnimations(17432578);
        this.setCanceledOnTouchOutside(true);
    }

    private void slideOpen() {
        TranslateAnimation slideUp = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        slideUp.setDuration(500L);
        slideUp.setInterpolator((Interpolator)new AccelerateInterpolator());
        ((ViewGroup)this.getWindow().getDecorView()).getChildAt(0).startAnimation((Animation)slideUp);
        super.show();
    }

    private void slideClose() {
        if (!this.isClosing_) {
            this.isClosing_ = true;
            TranslateAnimation slideDown = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
            slideDown.setDuration(500L);
            slideDown.setInterpolator((Interpolator)new DecelerateInterpolator());
            ((ViewGroup)this.getWindow().getDecorView()).getChildAt(0).startAnimation((Animation)slideDown);
            slideDown.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AnimatedDialog.this.dismiss();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
    }
}

