/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.type;

import io.bit3.jsass.type.SassBoolean;
import io.bit3.jsass.type.SassError;
import io.bit3.jsass.type.SassList;
import io.bit3.jsass.type.SassMap;
import io.bit3.jsass.type.SassNull;
import io.bit3.jsass.type.SassNumber;
import io.bit3.jsass.type.SassString;
import io.bit3.jsass.type.SassValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TypeUtils {
    public static SassValue convertToSassValue(Object value) {
        if (null == value) {
            return new SassNull();
        }
        if (value instanceof SassValue) {
            return (SassValue)value;
        }
        Class<?> cls = value.getClass();
        if (Boolean.TYPE.isAssignableFrom(cls) || value instanceof Boolean) {
            return new SassBoolean((Boolean)value);
        }
        if (Byte.TYPE.isAssignableFrom(cls) || Short.TYPE.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls) || value instanceof Number) {
            return new SassNumber(((Number)value).doubleValue(), "");
        }
        if (Character.TYPE.isAssignableFrom(cls) || value instanceof CharSequence) {
            return new SassString(value.toString());
        }
        if (value instanceof Collection) {
            return new SassList((Collection<?>)((Collection)value).stream().map(TypeUtils::convertToSassValue).collect(Collectors.toList()));
        }
        if (value instanceof Map) {
            SassMap map = new SassMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String key = entry.getKey().toString();
                SassValue item = TypeUtils.convertToSassValue(entry.getValue());
                map.put(key, item);
            }
            return map;
        }
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String message = throwable.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                printWriter.append(message).append("\n");
            }
            throwable.printStackTrace(printWriter);
            return new SassError(stringWriter.toString());
        }
        return new SassError(String.format("Could not convert object of type %s into a sass value", value.getClass().toString()));
    }
}

