/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.function.arguments.converter.ArgumentConverter;
import io.bit3.jsass.type.SassError;
import io.bit3.jsass.type.SassValue;
import io.bit3.jsass.type.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FunctionDeclaration {
    private final ImportStack importStack;
    private final Context context;
    protected final String signature;
    protected final Object object;
    protected final Method method;
    protected final List<ArgumentConverter> argumentConverters;

    public FunctionDeclaration(ImportStack importStack, Context context, String signature, Object object, Method method, List<ArgumentConverter> argumentConverters) {
        this.importStack = importStack;
        this.context = context;
        this.signature = signature;
        this.object = object;
        this.method = method;
        this.argumentConverters = argumentConverters;
    }

    public String getSignature() {
        return this.signature;
    }

    public Object getObject() {
        return this.object;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ArgumentConverter> getArgumentConverters() {
        return this.argumentConverters;
    }

    public SassValue invoke(List<?> arguments) {
        try {
            ArrayList<Object> values = new ArrayList<Object>(this.argumentConverters.size());
            for (ArgumentConverter argumentConverter : this.argumentConverters) {
                Object value = argumentConverter.convert(arguments, this.importStack, this.context);
                values.add(value);
            }
            Object result = this.method.invoke(this.object, values.toArray());
            return TypeUtils.convertToSassValue(result);
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String message = throwable.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                printWriter.append(message).append("\n");
            }
            throwable.printStackTrace(printWriter);
            return new SassError(stringWriter.toString());
        }
    }
}

