/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import io.bit3.jsass.annotation.DefaultBooleanValue;
import io.bit3.jsass.annotation.DefaultByteValue;
import io.bit3.jsass.annotation.DefaultCharacterValue;
import io.bit3.jsass.annotation.DefaultDoubleValue;
import io.bit3.jsass.annotation.DefaultFloatValue;
import io.bit3.jsass.annotation.DefaultIntegerValue;
import io.bit3.jsass.annotation.DefaultLongValue;
import io.bit3.jsass.annotation.DefaultShortValue;
import io.bit3.jsass.annotation.DefaultStringValue;
import io.bit3.jsass.annotation.Name;
import io.bit3.jsass.function.FunctionArgumentSignature;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.List;

public class FunctionArgumentSignatureFactory {
    public List<FunctionArgumentSignature> createDefaultArgumentSignature(Method method, Parameter parameter) {
        LinkedList<FunctionArgumentSignature> list = new LinkedList<FunctionArgumentSignature>();
        String name = this.getParameterName(parameter);
        Object defaultValue = this.getDefaultValue(parameter);
        list.add(new FunctionArgumentSignature(name, defaultValue));
        return list;
    }

    public String getParameterName(Parameter parameter) {
        Name annotation = parameter.getAnnotation(Name.class);
        if (null == annotation) {
            return parameter.getName();
        }
        return annotation.value();
    }

    public Object getDefaultValue(Parameter parameter) {
        DefaultBooleanValue defaultBooleanValue;
        DefaultCharacterValue defaultCharacterValue;
        DefaultDoubleValue defaultDoubleValue;
        DefaultFloatValue defaultFloatValue;
        DefaultLongValue defaultLongValue;
        DefaultIntegerValue defaultIntegerValue;
        DefaultShortValue defaultShortValue;
        DefaultByteValue defaultByteValue;
        DefaultStringValue defaultStringValue;
        Class<?> type = parameter.getType();
        if (CharSequence.class.isAssignableFrom(type) && null != (defaultStringValue = parameter.getAnnotation(DefaultStringValue.class))) {
            return defaultStringValue.value();
        }
        if ((Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) && null != (defaultByteValue = parameter.getAnnotation(DefaultByteValue.class))) {
            return defaultByteValue.value();
        }
        if ((Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) && null != (defaultShortValue = parameter.getAnnotation(DefaultShortValue.class))) {
            return defaultShortValue.value();
        }
        if ((Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) && null != (defaultIntegerValue = parameter.getAnnotation(DefaultIntegerValue.class))) {
            return defaultIntegerValue.value();
        }
        if ((Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) && null != (defaultLongValue = parameter.getAnnotation(DefaultLongValue.class))) {
            return defaultLongValue.value();
        }
        if ((Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) && null != (defaultFloatValue = parameter.getAnnotation(DefaultFloatValue.class))) {
            return Float.valueOf(defaultFloatValue.value());
        }
        if ((Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) && null != (defaultDoubleValue = parameter.getAnnotation(DefaultDoubleValue.class))) {
            return defaultDoubleValue.value();
        }
        if ((Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) && null != (defaultCharacterValue = parameter.getAnnotation(DefaultCharacterValue.class))) {
            return Character.valueOf(defaultCharacterValue.value());
        }
        if ((Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) && null != (defaultBooleanValue = parameter.getAnnotation(DefaultBooleanValue.class))) {
            return defaultBooleanValue.value();
        }
        return null;
    }
}

