/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.adapter;

import io.bit3.jsass.adapter.NativeImport;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import io.bit3.jsass.importer.JsassCustomHeaderImporter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

class NativeImporterWrapper {
    private final ImportStack importStack;
    private final Importer importer;

    public NativeImporterWrapper(ImportStack importStack, Importer importer) {
        this.importStack = importStack;
        this.importer = importer;
    }

    public Collection<NativeImport> apply(String url, NativeImport previousNative) {
        try {
            Import previous = new Import(previousNative.importPath, previousNative.absolutePath, previousNative.contents, previousNative.sourceMap);
            boolean isNotJsassCustomImporter = !(this.importer instanceof JsassCustomHeaderImporter);
            Collection<Import> imports = this.importer.apply(url, previous);
            if (null == imports) {
                return null;
            }
            LinkedList<NativeImport> nativeImports = new LinkedList<NativeImport>();
            for (Import importObject : imports) {
                if (isNotJsassCustomImporter) {
                    NativeImport preImport = this.createPreImport(importObject);
                    nativeImports.add(preImport);
                }
                nativeImports.add(new NativeImport(importObject));
                if (!isNotJsassCustomImporter) continue;
                NativeImport postImport = this.createPostImport(importObject);
                nativeImports.add(postImport);
            }
            return nativeImports;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            NativeImport nativeImport = new NativeImport(throwable);
            return Collections.singletonList(nativeImport);
        }
    }

    private NativeImport createPreImport(Import importSource) {
        int id = this.importStack.register(importSource);
        StringBuilder preSource = new StringBuilder();
        preSource.append(String.format("$jsass-void: jsass_import_stack_push(%d) !global;\n", id));
        try {
            return new NativeImport(new Import(new URI(importSource.getAbsoluteUri() + "/JSASS_PRE_IMPORT.scss"), new URI(importSource.getAbsoluteUri() + "/JSASS_PRE_IMPORT.scss"), preSource.toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private NativeImport createPostImport(Import importSource) {
        StringBuilder postSource = new StringBuilder();
        postSource.append("$jsass-void: jsass_import_stack_pop() !global;\n");
        try {
            return new NativeImport(new Import(new URI(importSource.getAbsoluteUri() + "/JSASS_POST_IMPORT.scss"), new URI(importSource.getAbsoluteUri() + "/JSASS_POST_IMPORT.scss"), postSource.toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

