/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.adapter;

import io.bit3.jsass.importer.Import;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

class NativeImport {
    public final String importPath;
    public final String absolutePath;
    public final String contents;
    public final String sourceMap;
    public final String errorMessage;

    public NativeImport(Import sassImport) {
        URI uri = sassImport.getImportUri();
        URI base = sassImport.getAbsoluteUri();
        String contents = sassImport.getContents();
        String sourceMap = sassImport.getSourceMap();
        String uriString = "";
        if (null != uri) {
            uriString = "file".equals(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
        }
        String baseString = "";
        if (null != base) {
            baseString = "file".equals(base.getScheme()) ? new File(base).getAbsolutePath() : base.toString();
        }
        this.importPath = uriString;
        this.absolutePath = baseString;
        this.contents = null == contents ? "" : contents;
        this.sourceMap = null == sourceMap ? "" : sourceMap;
        this.errorMessage = "";
    }

    public NativeImport(String importPath, String absolutePath, String contents, String sourceMap) {
        this.importPath = importPath;
        this.absolutePath = absolutePath;
        this.contents = contents;
        this.sourceMap = sourceMap;
        this.errorMessage = "";
    }

    public NativeImport(Throwable throwable) {
        this.importPath = "";
        this.absolutePath = "";
        this.contents = "";
        this.sourceMap = "";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String message = throwable.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            printWriter.append(message).append("\n");
        }
        throwable.printStackTrace(printWriter);
        this.errorMessage = stringWriter.toString();
    }
}

