/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.adapter.NativeAdapter;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.FileContext;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.context.StringContext;
import io.bit3.jsass.function.FunctionArgumentSignatureFactory;
import io.bit3.jsass.function.FunctionWrapperFactory;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;

public class Compiler {
    public final Charset defaultCharset = Charsets.UTF_8;
    private final NativeAdapter adapter;

    public Compiler() {
        FunctionArgumentSignatureFactory functionArgumentSignatureFactory = new FunctionArgumentSignatureFactory();
        FunctionWrapperFactory functionWrapperFactory = new FunctionWrapperFactory(functionArgumentSignatureFactory);
        this.adapter = new NativeAdapter(functionWrapperFactory);
    }

    public Output compileString(String string, Options options) throws CompilationException {
        return this.compileString(string, this.defaultCharset, null, null, options);
    }

    public Output compileString(String string, Charset charset, Options options) throws CompilationException {
        return this.compileString(string, charset, null, null, options);
    }

    public Output compileString(String string, URI inputPath, URI outputPath, Options options) throws CompilationException {
        return this.compileString(string, this.defaultCharset, inputPath, outputPath, options);
    }

    public Output compileString(String string, Charset charset, URI inputPath, URI outputPath, Options options) throws CompilationException {
        StringContext context = new StringContext(string, inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compileFile(URI inputPath, URI outputPath, Options options) throws CompilationException {
        FileContext context = new FileContext(inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compile(Context context) throws CompilationException {
        if (context instanceof FileContext) {
            return this.compile((FileContext)context);
        }
        if (context instanceof StringContext) {
            return this.compile((StringContext)context);
        }
        throw new RuntimeException(String.format("Context type \"%s\" is not supported", null == context ? "null" : context.getClass().getName()));
    }

    public Output compile(StringContext context) throws CompilationException {
        ImportStack importStack = new ImportStack();
        return this.adapter.compile(context, importStack);
    }

    public Output compile(FileContext context) throws CompilationException {
        ImportStack importStack = new ImportStack();
        return this.adapter.compile(context, importStack);
    }
}

