/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.type;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Separator;
import io.bit3.jsass.type.SassColor;
import io.bit3.jsass.type.SassList;
import io.bit3.jsass.type.SassNumber;
import io.bit3.jsass.type.SassString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import sass.SassLibrary;

public class TypeUtils {
    public static Object decodeValue(SassLibrary sass, SassLibrary.Sass_Value value) throws CompilationException {
        if (sass.sass_value_is_null(value) > 0) {
            return null;
        }
        if (sass.sass_value_is_number(value) > 0) {
            return TypeUtils.decodeNumber(sass, value);
        }
        if (sass.sass_value_is_string(value) > 0) {
            return TypeUtils.decodeString(sass, value);
        }
        if (sass.sass_value_is_boolean(value) > 0) {
            return TypeUtils.decodeBoolean(sass, value);
        }
        if (sass.sass_value_is_color(value) > 0) {
            return TypeUtils.decodeColor(sass, value);
        }
        if (sass.sass_value_is_list(value) > 0) {
            return TypeUtils.decodeList(sass, value);
        }
        if (sass.sass_value_is_map(value) > 0) {
            return TypeUtils.decodeMap(sass, value);
        }
        throw new CompilationException(-1, "SASS value has an unknown type");
    }

    public static SassNumber decodeNumber(SassLibrary sass, SassLibrary.Sass_Value value) {
        double number = sass.sass_number_get_value(value);
        String unit = sass.sass_number_get_unit(value);
        return new SassNumber(number, unit);
    }

    public static SassString decodeString(SassLibrary sass, SassLibrary.Sass_Value value) {
        String unquoted;
        String string = sass.sass_string_get_value(value);
        boolean quoted = !string.equals(unquoted = sass.sass_string_unquote(string).getString(0L));
        return new SassString(unquoted, quoted);
    }

    public static Boolean decodeBoolean(SassLibrary sass, SassLibrary.Sass_Value value) {
        return sass.sass_boolean_get_value(value) > 0;
    }

    public static SassColor decodeColor(SassLibrary sass, SassLibrary.Sass_Value value) {
        double red = sass.sass_color_get_r(value);
        double green = sass.sass_color_get_g(value);
        double blue = sass.sass_color_get_b(value);
        double alpha = sass.sass_color_get_a(value);
        return new SassColor(red, green, blue, alpha);
    }

    public static SassList decodeList(SassLibrary sass, SassLibrary.Sass_Value value) throws CompilationException {
        long size = sass.sass_list_get_length(value).longValue();
        int separator = sass.sass_list_get_separator(value);
        SassList sassList = new SassList();
        if (1 == separator) {
            sassList.setSeparator(Separator.SPACE);
        } else {
            sassList.setSeparator(Separator.COMMA);
        }
        int index = 0;
        while ((long)index < size) {
            SassLibrary.Sass_Value item = sass.sass_list_get_value(value, new NativeSize((long)index));
            Object decodedItem = TypeUtils.decodeValue(sass, item);
            sassList.add(decodedItem);
            ++index;
        }
        return sassList;
    }

    public static Map<?, ?> decodeMap(SassLibrary sass, SassLibrary.Sass_Value value) throws CompilationException {
        long size = sass.sass_map_get_length(value).longValue();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int index = 0;
        while ((long)index < size) {
            NativeSize nativeIndex = new NativeSize((long)index);
            SassLibrary.Sass_Value itemKey = sass.sass_map_get_key(value, nativeIndex);
            SassLibrary.Sass_Value itemValue = sass.sass_map_get_value(value, nativeIndex);
            Object decodedKey = TypeUtils.decodeValue(sass, itemKey);
            Object decodedValue = TypeUtils.decodeValue(sass, itemValue);
            map.put(decodedKey, decodedValue);
            ++index;
        }
        return map;
    }

    public static SassLibrary.Sass_Value encodeValue(SassLibrary sass, Object value) throws CompilationException {
        if (null == value) {
            return sass.sass_make_null();
        }
        if (value instanceof Number) {
            return TypeUtils.encodeNumber(sass, (Number)value);
        }
        if (value instanceof CharSequence) {
            return TypeUtils.encodeString(sass, (CharSequence)value);
        }
        if (value instanceof Boolean) {
            return TypeUtils.encodeBoolean(sass, (Boolean)value);
        }
        if (value instanceof SassColor) {
            return TypeUtils.encodeColor(sass, (SassColor)value);
        }
        if (value instanceof Collection) {
            return TypeUtils.encodeList(sass, (Collection)value);
        }
        if (value instanceof Map) {
            return TypeUtils.encodeMap(sass, (Map)value);
        }
        throw new CompilationException(-1, String.format("Java object %s cannot be converted to SASS", value.getClass().getName()));
    }

    public static SassLibrary.Sass_Value encodeNumber(SassLibrary sass, Number number) {
        double value = number.doubleValue();
        String unit = "";
        if (number instanceof SassNumber) {
            unit = ((SassNumber)number).getUnit();
        }
        return sass.sass_make_number(value, unit);
    }

    public static SassLibrary.Sass_Value encodeString(SassLibrary sass, CharSequence sequence) {
        String value = sequence.toString();
        if (sequence instanceof SassString) {
            SassString string = (SassString)sequence;
            if (string.isQuoted()) {
                value = sass.sass_string_quote(value, (byte)string.getQuote()).getString(0L);
            }
        } else {
            value = sass.sass_string_quote(value, (byte)39).getString(0L);
        }
        return sass.sass_make_string(value);
    }

    public static SassLibrary.Sass_Value encodeBoolean(SassLibrary sass, Boolean bool) {
        return sass.sass_make_boolean(bool != false ? (byte)1 : 0);
    }

    public static SassLibrary.Sass_Value encodeColor(SassLibrary sass, SassColor color) {
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        double alpha = color.getAlpha();
        return sass.sass_make_color(red, green, blue, alpha);
    }

    public static SassLibrary.Sass_Value encodeList(SassLibrary sass, Collection<?> list) throws CompilationException {
        int libsassSeparator = 0;
        if (list instanceof SassList) {
            Separator sep = ((SassList)list).getSeparator();
            switch (sep) {
                case COMMA: {
                    break;
                }
                case SPACE: {
                    libsassSeparator = 1;
                    break;
                }
                default: {
                    throw new IllegalAccessError(String.format("The separator \"%s\" cannot be converted to any libsass separator", null == sep ? "null" : sep.toString()));
                }
            }
        }
        SassLibrary.Sass_Value value = sass.sass_make_list(new NativeSize((long)list.size()), libsassSeparator);
        int index = 0;
        for (Object item : list) {
            sass.sass_list_set_value(value, new NativeSize((long)index), TypeUtils.encodeValue(sass, item));
            ++index;
        }
        return value;
    }

    public static SassLibrary.Sass_Value encodeMap(SassLibrary sass, Map<?, ?> map) throws CompilationException {
        SassLibrary.Sass_Value value = sass.sass_make_map(new NativeSize((long)map.size()));
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            SassLibrary.Sass_Value itemKey = TypeUtils.encodeValue(sass, entry.getKey());
            SassLibrary.Sass_Value itemValue = TypeUtils.encodeValue(sass, entry.getValue());
            NativeSize nativeIndex = new NativeSize((long)index);
            sass.sass_map_set_key(value, nativeIndex, itemKey);
            sass.sass_map_set_value(value, nativeIndex, itemValue);
            ++index;
        }
        return value;
    }
}

