/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.importer;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.nio.ByteBuffer;
import java.util.Collection;
import sass.SassLibrary;

public class ImporterWrapper
implements SassLibrary.Sass_C_Import_Fn {
    private final SassLibrary sass;
    private final Context originalContext;
    private final Importer importer;

    public ImporterWrapper(SassLibrary sass, Context originalContext, Importer importer) {
        this.sass = sass;
        this.originalContext = originalContext;
        this.importer = importer;
    }

    @Override
    public PointerByReference apply(Pointer url, Pointer prev, Pointer cookie) {
        Collection<Import> imports = this.importer.apply(url.getString(0L), prev.getString(0L), this.originalContext);
        if (null == imports) {
            return null;
        }
        PointerByReference list = this.sass.sass_make_import_list(new NativeSize((long)imports.size()));
        int index = 0;
        for (Import importSource : imports) {
            Memory sourceMapMemory;
            byte[] bytes;
            Memory sourceMemory;
            String base;
            String path = importSource.getUri().toString();
            String string = base = null == importSource.getBase() ? "" : importSource.getBase().toString();
            if (null == importSource.getContents()) {
                sourceMemory = new Memory(1L);
                sourceMemory.setByte(0L, (byte)0);
            } else {
                bytes = importSource.getContents().getBytes(importSource.getContentsCharset());
                sourceMemory = new Memory((long)(bytes.length + 1));
                sourceMemory.write(0L, bytes, 0, bytes.length);
                sourceMemory.setByte((long)bytes.length, (byte)0);
            }
            ByteBuffer source = sourceMemory.getByteBuffer(0L, sourceMemory.size());
            if (null == importSource.getSourceMap()) {
                sourceMapMemory = new Memory(1L);
                sourceMapMemory.setByte(0L, (byte)0);
            } else {
                bytes = importSource.getSourceMap().getBytes(importSource.getSourceMapCharset());
                sourceMapMemory = new Memory((long)(bytes.length + 1));
                sourceMapMemory.write(0L, bytes, 0, bytes.length);
                sourceMapMemory.setByte((long)bytes.length, (byte)0);
            }
            ByteBuffer sourceMap = sourceMapMemory.getByteBuffer(0L, sourceMapMemory.size());
            SassLibrary.Sass_Import entry = this.sass.sass_make_import(path, base, source, sourceMap);
            this.sass.sass_import_set_list_entry(list, new NativeSize((long)index), entry);
            ++index;
        }
        return list;
    }
}

