/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import java.lang.reflect.Method;
import java.util.List;

public class FunctionDeclaration {
    protected final String signature;
    protected final Object object;
    protected final Method method;
    protected final Class<?>[] types;

    public FunctionDeclaration(String signature, Object object, Method method, Class<?>[] types) {
        this.signature = signature;
        this.object = object;
        this.method = method;
        this.types = types;
    }

    public String getSignature() {
        return this.signature;
    }

    public Object getObject() {
        return this.object;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public Object invoke(List<?> arguments) {
        Object[] args = new Object[this.types.length];
        for (int index = 0; index < args.length; ++index) {
            Class<?> targetType = this.types[index];
            Object value = index >= arguments.size() ? null : (Object)arguments.get(index);
            if (null != value && !targetType.isAssignableFrom(value.getClass())) {
                if (String.class.isAssignableFrom(targetType)) {
                    value = value.toString();
                } else if (Byte.class.isAssignableFrom(targetType) || Byte.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : Byte.valueOf(Byte.parseByte(value.toString()));
                } else if (Short.class.isAssignableFrom(targetType) || Short.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Short.valueOf(((Number)value).shortValue()) : Short.valueOf(Short.parseShort(value.toString()));
                } else if (Integer.class.isAssignableFrom(targetType) || Integer.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(Integer.parseInt(value.toString()));
                } else if (Long.class.isAssignableFrom(targetType) || Long.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(Long.parseLong(value.toString()));
                } else if (Float.class.isAssignableFrom(targetType) || Float.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(Float.parseFloat(value.toString()));
                } else if (Double.class.isAssignableFrom(targetType) || Double.TYPE.isAssignableFrom(targetType)) {
                    value = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(Double.parseDouble(value.toString()));
                } else if (Boolean.class.isAssignableFrom(targetType) || Boolean.TYPE.isAssignableFrom(targetType)) {
                    value = Boolean.valueOf(value.toString());
                } else if (Character.class.isAssignableFrom(targetType) || Character.TYPE.isAssignableFrom(targetType)) {
                    value = Character.valueOf(value.toString().charAt(0));
                } else {
                    throw new RuntimeException(String.format("Cannot convert SASS type %s to Java type %s", value.getClass().getName(), targetType.getName()));
                }
            }
            args[index] = value;
        }
        try {
            return this.method.invoke(this.object, args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

