/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import io.bit3.jsass.annotation.DefaultBooleanValue;
import io.bit3.jsass.annotation.DefaultByteValue;
import io.bit3.jsass.annotation.DefaultCharacterValue;
import io.bit3.jsass.annotation.DefaultDoubleValue;
import io.bit3.jsass.annotation.DefaultFloatValue;
import io.bit3.jsass.annotation.DefaultIntegerValue;
import io.bit3.jsass.annotation.DefaultLongValue;
import io.bit3.jsass.annotation.DefaultShortValue;
import io.bit3.jsass.annotation.DefaultStringValue;
import io.bit3.jsass.annotation.Name;
import io.bit3.jsass.function.FunctionDeclaration;
import io.bit3.jsass.function.FunctionWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import sass.SassLibrary;

public class FunctionCallbackFactory {
    private SassLibrary sass;

    public FunctionCallbackFactory(SassLibrary sass) {
        this.sass = sass;
    }

    public List<SassLibrary.Sass_C_Function_Callback> compileFunctions(List<?> objects) {
        LinkedList<SassLibrary.Sass_C_Function_Callback> callbacks = new LinkedList<SassLibrary.Sass_C_Function_Callback>();
        for (Object object : objects) {
            List<SassLibrary.Sass_C_Function_Callback> objectCallbacks = this.compileFunctions(object);
            callbacks.addAll(objectCallbacks);
        }
        return callbacks;
    }

    public List<SassLibrary.Sass_C_Function_Callback> compileFunctions(Object object) {
        Class<?> functionClass = object.getClass();
        Method[] methods = functionClass.getDeclaredMethods();
        LinkedList<FunctionDeclaration> declarations = new LinkedList<FunctionDeclaration>();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            FunctionDeclaration declaration = this.createDeclaration(object, method);
            declarations.add(declaration);
        }
        LinkedList<SassLibrary.Sass_C_Function_Callback> callbacks = new LinkedList<SassLibrary.Sass_C_Function_Callback>();
        for (FunctionDeclaration declaration : declarations) {
            FunctionWrapper wrapper = new FunctionWrapper(this.sass, declaration);
            SassLibrary.Sass_C_Function_Callback callback = this.sass.sass_make_function(declaration.signature, (SassLibrary.Sass_C_Function)wrapper, null);
            callbacks.add(callback);
        }
        return callbacks;
    }

    public SassLibrary.Sass_C_Function_List toSassCFunctionList(List<SassLibrary.Sass_C_Function_Callback> callbacks) {
        SassLibrary.Sass_C_Function_List functionList = this.sass.sass_make_function_list(new NativeSize((long)callbacks.size()));
        int index = 0;
        for (SassLibrary.Sass_C_Function_Callback callback : callbacks) {
            this.sass.sass_function_set_list_entry(functionList, new NativeSize((long)index), callback);
            ++index;
        }
        return functionList;
    }

    public FunctionDeclaration createDeclaration(Object object, Method method) {
        StringBuilder signature = new StringBuilder();
        Parameter[] parameters = method.getParameters();
        Object[] defaultValues = new Object[parameters.length];
        signature.append(method.getName()).append("(");
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            String name = this.getParameterName(parameter);
            if (index > 0) {
                signature.append(", ");
            }
            signature.append("$").append(name);
            Object defaultValue = this.getDefaultValue(parameter);
            if (null != defaultValue) {
                signature.append(": ").append(this.formatDefaultValue(defaultValue));
            }
            defaultValues[index] = defaultValue;
        }
        signature.append(")");
        return new FunctionDeclaration(signature.toString(), object, method, method.getParameterTypes());
    }

    private String getParameterName(Parameter parameter) {
        Name annotation = parameter.getAnnotation(Name.class);
        if (null == annotation) {
            return parameter.getName();
        }
        return annotation.value();
    }

    private Object getDefaultValue(Parameter parameter) {
        DefaultBooleanValue defaultBooleanValue;
        DefaultCharacterValue defaultCharacterValue;
        DefaultDoubleValue defaultDoubleValue;
        DefaultFloatValue defaultFloatValue;
        DefaultLongValue defaultLongValue;
        DefaultIntegerValue defaultIntegerValue;
        DefaultShortValue defaultShortValue;
        DefaultByteValue defaultByteValue;
        DefaultStringValue defaultStringValue;
        Class<?> type = parameter.getType();
        if (CharSequence.class.isAssignableFrom(type) && null != (defaultStringValue = parameter.getAnnotation(DefaultStringValue.class))) {
            return defaultStringValue.value();
        }
        if ((Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) && null != (defaultByteValue = parameter.getAnnotation(DefaultByteValue.class))) {
            return defaultByteValue.value();
        }
        if ((Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) && null != (defaultShortValue = parameter.getAnnotation(DefaultShortValue.class))) {
            return defaultShortValue.value();
        }
        if ((Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) && null != (defaultIntegerValue = parameter.getAnnotation(DefaultIntegerValue.class))) {
            return defaultIntegerValue.value();
        }
        if ((Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) && null != (defaultLongValue = parameter.getAnnotation(DefaultLongValue.class))) {
            return defaultLongValue.value();
        }
        if ((Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) && null != (defaultFloatValue = parameter.getAnnotation(DefaultFloatValue.class))) {
            return Float.valueOf(defaultFloatValue.value());
        }
        if ((Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) && null != (defaultDoubleValue = parameter.getAnnotation(DefaultDoubleValue.class))) {
            return defaultDoubleValue.value();
        }
        if ((Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) && null != (defaultCharacterValue = parameter.getAnnotation(DefaultCharacterValue.class))) {
            return Character.valueOf(defaultCharacterValue.value());
        }
        if ((Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) && null != (defaultBooleanValue = parameter.getAnnotation(DefaultBooleanValue.class))) {
            return defaultBooleanValue.value();
        }
        return null;
    }

    private String formatDefaultValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            boolean first = true;
            for (Object item : (Collection)value) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(this.formatDefaultValue(item));
            }
            builder.append(")");
            return builder.toString();
        }
        String string = value.toString();
        string = this.sass.sass_string_unquote(string).getString(0L);
        return this.sass.sass_string_quote(string, (byte)39).getString(0L);
    }
}

