/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.context;

import com.sun.jna.Memory;
import io.bit3.jsass.Options;
import io.bit3.jsass.OutputStyle;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.FileContext;
import io.bit3.jsass.context.StringContext;
import io.bit3.jsass.function.FunctionCallbackFactory;
import io.bit3.jsass.importer.Importer;
import io.bit3.jsass.importer.ImporterCallbackFactory;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import sass.SassLibrary;

public class ContextFactory {
    private final SassLibrary sass;

    public ContextFactory(SassLibrary sass) {
        this.sass = sass;
    }

    public SassLibrary.Sass_File_Context create(FileContext context) {
        URI inputPath = context.getInputPath();
        SassLibrary.Sass_File_Context fileContext = this.sass.sass_make_file_context(inputPath.toString());
        SassLibrary.Sass_Options libsassOptions = this.sass.sass_file_context_get_options(fileContext);
        this.configure(context, libsassOptions);
        return fileContext;
    }

    public SassLibrary.Sass_Data_Context create(StringContext context) {
        String string = context.getString();
        Charset charset = context.getCharset();
        byte[] bytes = string.getBytes(charset);
        Memory memory = new Memory((long)(bytes.length + 1));
        memory.write(0L, bytes, 0, bytes.length);
        memory.setByte((long)bytes.length, (byte)0);
        ByteBuffer buffer = memory.getByteBuffer(0L, memory.size());
        SassLibrary.Sass_Data_Context dataContext = this.sass.sass_make_data_context(buffer);
        SassLibrary.Sass_Options libsassOptions = this.sass.sass_data_context_get_options(dataContext);
        this.configure(context, libsassOptions);
        return dataContext;
    }

    private void configure(Context context, SassLibrary.Sass_Options libsassOptions) {
        URI inputPath = context.getInputPath();
        URI outputPath = context.getOutputPath();
        Options javaOptions = context.getOptions();
        int precision = javaOptions.getPrecision();
        int outputStyle = this.mapOutputStyle(javaOptions.getOutputStyle());
        byte sourceComments = this.createBooleanByte(javaOptions.isSourceComments());
        byte sourceMapEmbed = this.createBooleanByte(javaOptions.isSourceMapEmbed());
        byte sourceMapContents = this.createBooleanByte(javaOptions.isSourceMapContents());
        byte omitSourceMapUrl = this.createBooleanByte(javaOptions.isOmitSourceMapUrl());
        byte isIndentedSyntaxSrc = this.createBooleanByte(javaOptions.isIndentedSyntaxSrc());
        String inputPathString = null == inputPath ? "" : inputPath.toString();
        String outputPathString = null == outputPath ? "" : outputPath.toString();
        String imagePath = javaOptions.getImageUrl();
        String includePaths = this.joinFilePaths(javaOptions.getIncludePaths());
        String sourceMapFile = null == javaOptions.getSourceMapFile() ? "" : javaOptions.getSourceMapFile().toString();
        SassLibrary.Sass_C_Function_List functions = this.createFunctions(javaOptions.getFunctionProviders());
        SassLibrary.Sass_C_Import_Callback importer = this.createImporter(context, javaOptions.getImporters());
        inputPathString = inputPathString.replaceFirst("^file:", "");
        outputPathString = outputPathString.replaceFirst("^file:", "");
        sourceMapFile = sourceMapFile.replaceFirst("^file:", "");
        this.sass.sass_option_set_precision(libsassOptions, precision);
        this.sass.sass_option_set_output_style(libsassOptions, outputStyle);
        this.sass.sass_option_set_source_comments(libsassOptions, sourceComments);
        this.sass.sass_option_set_source_map_embed(libsassOptions, sourceMapEmbed);
        this.sass.sass_option_set_source_map_contents(libsassOptions, sourceMapContents);
        this.sass.sass_option_set_omit_source_map_url(libsassOptions, omitSourceMapUrl);
        this.sass.sass_option_set_is_indented_syntax_src(libsassOptions, isIndentedSyntaxSrc);
        this.sass.sass_option_set_input_path(libsassOptions, inputPathString);
        this.sass.sass_option_set_output_path(libsassOptions, outputPathString);
        this.sass.sass_option_set_image_path(libsassOptions, imagePath);
        this.sass.sass_option_set_include_path(libsassOptions, includePaths);
        this.sass.sass_option_set_source_map_file(libsassOptions, sourceMapFile);
        this.sass.sass_option_set_c_functions(libsassOptions, functions);
        this.sass.sass_option_set_importer(libsassOptions, importer);
    }

    private int mapOutputStyle(OutputStyle outputStyle) {
        int result;
        switch (outputStyle) {
            case NESTED: {
                result = 0;
                break;
            }
            case EXPANDED: {
                result = 1;
                break;
            }
            case COMPACT: {
                result = 2;
                break;
            }
            case COMPRESSED: {
                result = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The given output style \"%s\" cannot be converted to libsass!", null == outputStyle ? "null" : outputStyle.toString()));
            }
        }
        return result;
    }

    private String joinFilePaths(List<File> list) {
        if (null == list || list.isEmpty()) {
            return "";
        }
        String separator = File.pathSeparator;
        StringBuilder string = new StringBuilder();
        for (File file : list) {
            string.append(separator).append(file.getAbsolutePath());
        }
        return string.substring(1);
    }

    private SassLibrary.Sass_C_Function_List createFunctions(List<?> functionProviders) {
        FunctionCallbackFactory functionCallbackFactory = new FunctionCallbackFactory(this.sass);
        List<SassLibrary.Sass_C_Function_Callback> callbacks = functionCallbackFactory.compileFunctions(functionProviders);
        return functionCallbackFactory.toSassCFunctionList(callbacks);
    }

    private SassLibrary.Sass_C_Import_Callback createImporter(Context originalContext, Collection<Importer> importers) {
        if (importers.isEmpty()) {
            return null;
        }
        ImporterCallbackFactory importerCallbackFactory = new ImporterCallbackFactory(this.sass);
        return importerCallbackFactory.create(originalContext, importers);
    }

    private byte createBooleanByte(boolean bool) {
        return bool ? (byte)1 : 0;
    }
}

