/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass;

import com.sun.jna.Native;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.ContextFactory;
import io.bit3.jsass.context.FileContext;
import io.bit3.jsass.context.StringContext;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import sass.SassLibrary;

public class Compiler {
    public final Charset defaultCharset = Charsets.UTF_8;
    private final SassLibrary sass = (SassLibrary)Native.loadLibrary((String)"sass", SassLibrary.class);
    private final ContextFactory contextFactory = new ContextFactory(this.sass);

    public Output compileString(String string, Options options) throws CompilationException {
        return this.compileString(string, this.defaultCharset, null, null, options);
    }

    public Output compileString(String string, Charset charset, Options options) throws CompilationException {
        return this.compileString(string, charset, null, null, options);
    }

    public Output compileString(String string, URI inputPath, URI outputPath, Options options) throws CompilationException {
        return this.compileString(string, this.defaultCharset, inputPath, outputPath, options);
    }

    public Output compileString(String string, Charset charset, URI inputPath, URI outputPath, Options options) throws CompilationException {
        StringContext context = new StringContext(string, charset, inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compileFile(URI inputPath, URI outputPath, Options options) throws CompilationException {
        FileContext context = new FileContext(inputPath, outputPath, options);
        return this.compile(context);
    }

    public Output compile(Context context) throws CompilationException {
        if (context instanceof FileContext) {
            return this.compile((FileContext)context);
        }
        if (context instanceof StringContext) {
            return this.compile((StringContext)context);
        }
        throw new RuntimeException(String.format("Context type \"%s\" is not supported", null == context ? "null" : context.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output compile(StringContext context) throws CompilationException {
        SassLibrary.Sass_Data_Context dataContext = null;
        try {
            dataContext = this.contextFactory.create(context);
            this.sass.sass_compile_data_context(dataContext);
            SassLibrary.Sass_Context libsassContext = this.sass.sass_data_context_get_context(dataContext);
            this.checkErrorStatus(libsassContext);
            Output output = this.createOutput(libsassContext);
            return output;
        }
        finally {
            if (null != dataContext) {
                this.sass.sass_delete_data_context(dataContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output compile(FileContext context) throws CompilationException {
        SassLibrary.Sass_File_Context fileContext = null;
        try {
            fileContext = this.contextFactory.create(context);
            this.sass.sass_compile_file_context(fileContext);
            SassLibrary.Sass_Context libsassContext = this.sass.sass_file_context_get_context(fileContext);
            this.checkErrorStatus(libsassContext);
            Output output = this.createOutput(libsassContext);
            return output;
        }
        finally {
            if (null != fileContext) {
                this.sass.sass_delete_file_context(fileContext);
            }
        }
    }

    private void checkErrorStatus(SassLibrary.Sass_Context context) throws CompilationException {
        int status = this.sass.sass_context_get_error_status(context);
        if (status != 0) {
            String file = this.sass.sass_context_get_error_file(context);
            String message = this.sass.sass_context_get_error_message(context);
            throw new CompilationException(status, file + ": " + message);
        }
    }

    private Output createOutput(SassLibrary.Sass_Context context) {
        String css = this.sass.sass_context_get_output_string(context);
        String sourceMap = this.sass.sass_context_get_source_map_string(context);
        return new Output(css, sourceMap);
    }
}

