package sass;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
/**
 * JNA Wrapper for library <b>sass</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public interface SassLibrary extends Library {
	public static final String JNA_LIBRARY_NAME = "sass";
	public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance(SassLibrary.JNA_LIBRARY_NAME);
	public static final SassLibrary INSTANCE = (SassLibrary)Native.loadLibrary(SassLibrary.JNA_LIBRARY_NAME, SassLibrary.class);
	/**
	 * Type for Sass values<br>
	 * <i>native declaration : src/main/libsass/sass_values.h:11</i><br>
	 * enum values
	 */
	public static interface Sass_Tag {
		/** <i>native declaration : src/main/libsass/sass_values.h:12</i> */
		public static final int SASS_BOOLEAN = 0;
		/** <i>native declaration : src/main/libsass/sass_values.h:13</i> */
		public static final int SASS_NUMBER = 1;
		/** <i>native declaration : src/main/libsass/sass_values.h:14</i> */
		public static final int SASS_COLOR = 2;
		/** <i>native declaration : src/main/libsass/sass_values.h:15</i> */
		public static final int SASS_STRING = 3;
		/** <i>native declaration : src/main/libsass/sass_values.h:16</i> */
		public static final int SASS_LIST = 4;
		/** <i>native declaration : src/main/libsass/sass_values.h:17</i> */
		public static final int SASS_MAP = 5;
		/** <i>native declaration : src/main/libsass/sass_values.h:18</i> */
		public static final int SASS_NULL = 6;
		/** <i>native declaration : src/main/libsass/sass_values.h:19</i> */
		public static final int SASS_ERROR = 7;
		/** <i>native declaration : src/main/libsass/sass_values.h:20</i> */
		public static final int SASS_WARNING = 8;
	};
	/**
	 * Tags for denoting Sass list separators<br>
	 * <i>native declaration : src/main/libsass/sass_values.h:24</i><br>
	 * enum values
	 */
	public static interface Sass_Separator {
		/** <i>native declaration : src/main/libsass/sass_values.h:25</i> */
		public static final int SASS_COMMA = 0;
		/** <i>native declaration : src/main/libsass/sass_values.h:26</i> */
		public static final int SASS_SPACE = 1;
	};
	/**
	 * Different render styles<br>
	 * <i>native declaration : src/main/libsass/sass.h:27</i><br>
	 * enum values
	 */
	public static interface Sass_Output_Style {
		/** <i>native declaration : src/main/libsass/sass.h:28</i> */
		public static final int SASS_STYLE_NESTED = 0;
		/** <i>native declaration : src/main/libsass/sass.h:29</i> */
		public static final int SASS_STYLE_EXPANDED = 1;
		/** <i>native declaration : src/main/libsass/sass.h:30</i> */
		public static final int SASS_STYLE_COMPACT = 2;
		/** <i>native declaration : src/main/libsass/sass.h:31</i> */
		public static final int SASS_STYLE_COMPRESSED = 3;
	};
	/** <i>native declaration : src/main/libsass/sass.h</i> */
	public static final String LIBSASS_VERSION = (String)"[NA]";
	/** <i>native declaration : src/main/libsass/sass_functions.h</i> */
	public interface Sass_C_Import_Fn extends Callback {
		PointerByReference apply(Pointer url, Pointer prev, Pointer cookie);
	};
	/** <i>native declaration : src/main/libsass/sass_functions.h</i> */
	public interface Sass_C_Function extends Callback {
		SassLibrary.Sass_Value apply(SassLibrary.Sass_Value Sass_ValuePtr1, Pointer cookie);
	};
	/**
	 * Check is needed before accessing specific values!<br>
	 * Original signature : <code>Sass_Tag sass_value_get_tag(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:31</i>
	 */
	int sass_value_get_tag(SassLibrary.Sass_Value v);
	/**
	 * Can also be used before accessing properties!<br>
	 * Original signature : <code>bool sass_value_is_null(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:35</i>
	 */
	byte sass_value_is_null(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_number(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:36</i>
	 */
	byte sass_value_is_number(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_string(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:37</i>
	 */
	byte sass_value_is_string(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_boolean(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:38</i>
	 */
	byte sass_value_is_boolean(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_color(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:39</i>
	 */
	byte sass_value_is_color(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_list(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:40</i>
	 */
	byte sass_value_is_list(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_map(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:41</i>
	 */
	byte sass_value_is_map(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_error(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:42</i>
	 */
	byte sass_value_is_error(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>bool sass_value_is_warning(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:43</i>
	 */
	byte sass_value_is_warning(SassLibrary.Sass_Value v);
	/**
	 * Getters and setters for Sass_Number<br>
	 * Original signature : <code>double sass_number_get_value(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:46</i>
	 */
	double sass_number_get_value(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_number_set_value(Sass_Value*, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:47</i>
	 */
	void sass_number_set_value(SassLibrary.Sass_Value v, double value);
	/**
	 * Original signature : <code>char* sass_number_get_unit(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:48</i>
	 */
	String sass_number_get_unit(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_number_set_unit(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:49</i><br>
	 * @deprecated use the safer methods {@link #sass_number_set_unit(sass.SassLibrary.Sass_Value, java.nio.ByteBuffer)} and {@link #sass_number_set_unit(sass.SassLibrary.Sass_Value, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_number_set_unit(SassLibrary.Sass_Value v, Pointer unit);
	/**
	 * Original signature : <code>void sass_number_set_unit(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:49</i>
	 */
	void sass_number_set_unit(SassLibrary.Sass_Value v, ByteBuffer unit);
	/**
	 * Getters and setters for Sass_String<br>
	 * Original signature : <code>char* sass_string_get_value(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:52</i>
	 */
	String sass_string_get_value(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_string_set_value(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:53</i><br>
	 * @deprecated use the safer methods {@link #sass_string_set_value(sass.SassLibrary.Sass_Value, java.nio.ByteBuffer)} and {@link #sass_string_set_value(sass.SassLibrary.Sass_Value, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_string_set_value(SassLibrary.Sass_Value v, Pointer value);
	/**
	 * Original signature : <code>void sass_string_set_value(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:53</i>
	 */
	void sass_string_set_value(SassLibrary.Sass_Value v, ByteBuffer value);
	/**
	 * Getters and setters for Sass_Boolean<br>
	 * Original signature : <code>bool sass_boolean_get_value(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:56</i>
	 */
	byte sass_boolean_get_value(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_boolean_set_value(Sass_Value*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:57</i>
	 */
	void sass_boolean_set_value(SassLibrary.Sass_Value v, byte value);
	/**
	 * Getters and setters for Sass_Color<br>
	 * Original signature : <code>double sass_color_get_r(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:60</i>
	 */
	double sass_color_get_r(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_color_set_r(Sass_Value*, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:61</i>
	 */
	void sass_color_set_r(SassLibrary.Sass_Value v, double r);
	/**
	 * Original signature : <code>double sass_color_get_g(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:62</i>
	 */
	double sass_color_get_g(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_color_set_g(Sass_Value*, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:63</i>
	 */
	void sass_color_set_g(SassLibrary.Sass_Value v, double g);
	/**
	 * Original signature : <code>double sass_color_get_b(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:64</i>
	 */
	double sass_color_get_b(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_color_set_b(Sass_Value*, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:65</i>
	 */
	void sass_color_set_b(SassLibrary.Sass_Value v, double b);
	/**
	 * Original signature : <code>double sass_color_get_a(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:66</i>
	 */
	double sass_color_get_a(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_color_set_a(Sass_Value*, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:67</i>
	 */
	void sass_color_set_a(SassLibrary.Sass_Value v, double a);
	/**
	 * Getter for the number of items in list<br>
	 * Original signature : <code>size_t sass_list_get_length(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:70</i>
	 */
	NativeSize sass_list_get_length(SassLibrary.Sass_Value v);
	/**
	 * Getters and setters for Sass_List<br>
	 * Original signature : <code>Sass_Separator sass_list_get_separator(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:72</i>
	 */
	int sass_list_get_separator(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_list_set_separator(Sass_Value*, Sass_Separator)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:73</i>
	 */
	void sass_list_set_separator(SassLibrary.Sass_Value v, int value);
	/**
	 * Getters and setters for Sass_List values<br>
	 * Original signature : <code>Sass_Value* sass_list_get_value(Sass_Value*, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:75</i>
	 */
	SassLibrary.Sass_Value sass_list_get_value(SassLibrary.Sass_Value v, NativeSize i);
	/**
	 * Original signature : <code>void sass_list_set_value(Sass_Value*, size_t, Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:76</i>
	 */
	void sass_list_set_value(SassLibrary.Sass_Value v, NativeSize i, SassLibrary.Sass_Value value);
	/**
	 * Getter for the number of items in map<br>
	 * Original signature : <code>size_t sass_map_get_length(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:79</i>
	 */
	NativeSize sass_map_get_length(SassLibrary.Sass_Value v);
	/**
	 * Getters and setters for Sass_List keys and values<br>
	 * Original signature : <code>Sass_Value* sass_map_get_key(Sass_Value*, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:81</i>
	 */
	SassLibrary.Sass_Value sass_map_get_key(SassLibrary.Sass_Value v, NativeSize i);
	/**
	 * Original signature : <code>void sass_map_set_key(Sass_Value*, size_t, Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:82</i>
	 */
	void sass_map_set_key(SassLibrary.Sass_Value v, NativeSize i, SassLibrary.Sass_Value Sass_ValuePtr1);
	/**
	 * Original signature : <code>Sass_Value* sass_map_get_value(Sass_Value*, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:83</i>
	 */
	SassLibrary.Sass_Value sass_map_get_value(SassLibrary.Sass_Value v, NativeSize i);
	/**
	 * Original signature : <code>void sass_map_set_value(Sass_Value*, size_t, Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:84</i>
	 */
	void sass_map_set_value(SassLibrary.Sass_Value v, NativeSize i, SassLibrary.Sass_Value Sass_ValuePtr1);
	/**
	 * Getters and setters for Sass_Error<br>
	 * Original signature : <code>char* sass_error_get_message(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:87</i>
	 */
	Pointer sass_error_get_message(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_error_set_message(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:88</i><br>
	 * @deprecated use the safer methods {@link #sass_error_set_message(sass.SassLibrary.Sass_Value, java.nio.ByteBuffer)} and {@link #sass_error_set_message(sass.SassLibrary.Sass_Value, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_error_set_message(SassLibrary.Sass_Value v, Pointer msg);
	/**
	 * Original signature : <code>void sass_error_set_message(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:88</i>
	 */
	void sass_error_set_message(SassLibrary.Sass_Value v, ByteBuffer msg);
	/**
	 * Getters and setters for Sass_Warning<br>
	 * Original signature : <code>char* sass_warning_get_message(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:91</i>
	 */
	Pointer sass_warning_get_message(SassLibrary.Sass_Value v);
	/**
	 * Original signature : <code>void sass_warning_set_message(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:92</i><br>
	 * @deprecated use the safer methods {@link #sass_warning_set_message(sass.SassLibrary.Sass_Value, java.nio.ByteBuffer)} and {@link #sass_warning_set_message(sass.SassLibrary.Sass_Value, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_warning_set_message(SassLibrary.Sass_Value v, Pointer msg);
	/**
	 * Original signature : <code>void sass_warning_set_message(Sass_Value*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:92</i>
	 */
	void sass_warning_set_message(SassLibrary.Sass_Value v, ByteBuffer msg);
	/**
	 * Creator functions for all value types<br>
	 * Original signature : <code>Sass_Value* sass_make_null()</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:95</i>
	 */
	SassLibrary.Sass_Value sass_make_null();
	/**
	 * Original signature : <code>Sass_Value* sass_make_boolean(bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:96</i>
	 */
	SassLibrary.Sass_Value sass_make_boolean(byte val);
	/**
	 * Original signature : <code>Sass_Value* sass_make_string(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:97</i><br>
	 * @deprecated use the safer methods {@link #sass_make_string(java.lang.String)} and {@link #sass_make_string(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Value sass_make_string(Pointer val);
	/**
	 * Original signature : <code>Sass_Value* sass_make_string(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:97</i>
	 */
	SassLibrary.Sass_Value sass_make_string(String val);
	/**
	 * Original signature : <code>Sass_Value* sass_make_number(double, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:98</i><br>
	 * @deprecated use the safer methods {@link #sass_make_number(double, java.lang.String)} and {@link #sass_make_number(double, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Value sass_make_number(double val, Pointer unit);
	/**
	 * Original signature : <code>Sass_Value* sass_make_number(double, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:98</i>
	 */
	SassLibrary.Sass_Value sass_make_number(double val, String unit);
	/**
	 * Original signature : <code>Sass_Value* sass_make_color(double, double, double, double)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:99</i>
	 */
	SassLibrary.Sass_Value sass_make_color(double r, double g, double b, double a);
	/**
	 * Original signature : <code>Sass_Value* sass_make_list(size_t, Sass_Separator)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:100</i>
	 */
	SassLibrary.Sass_Value sass_make_list(NativeSize len, int sep);
	/**
	 * Original signature : <code>Sass_Value* sass_make_map(size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:101</i>
	 */
	SassLibrary.Sass_Value sass_make_map(NativeSize len);
	/**
	 * Original signature : <code>Sass_Value* sass_make_error(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:102</i><br>
	 * @deprecated use the safer methods {@link #sass_make_error(java.lang.String)} and {@link #sass_make_error(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Value sass_make_error(Pointer msg);
	/**
	 * Original signature : <code>Sass_Value* sass_make_error(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:102</i>
	 */
	SassLibrary.Sass_Value sass_make_error(String msg);
	/**
	 * Original signature : <code>Sass_Value* sass_make_warning(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:103</i><br>
	 * @deprecated use the safer methods {@link #sass_make_warning(java.lang.String)} and {@link #sass_make_warning(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Value sass_make_warning(Pointer msg);
	/**
	 * Original signature : <code>Sass_Value* sass_make_warning(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:103</i>
	 */
	SassLibrary.Sass_Value sass_make_warning(String msg);
	/**
	 * Means we will delete recursively for lists and maps<br>
	 * Original signature : <code>void sass_delete_value(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:108</i>
	 */
	void sass_delete_value(SassLibrary.Sass_Value val);
	/**
	 * Make a deep cloned copy of the given sass value<br>
	 * Original signature : <code>Sass_Value* sass_clone_value(Sass_Value*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_values.h:111</i>
	 */
	SassLibrary.Sass_Value sass_clone_value(SassLibrary.Sass_Value val);
	/**
	 * The pointer is mostly used to store the callback into the actual binding<br>
	 * Original signature : <code>Sass_C_Import_Callback sass_make_importer(Sass_C_Import_Fn, void*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:20</i>
	 */
	SassLibrary.Sass_C_Import_Callback sass_make_importer(SassLibrary.Sass_C_Import_Fn Sass_C_Import_Fn1, Pointer cookie);
	/**
	 * Getters for import function descriptors<br>
	 * Original signature : <code>Sass_C_Import_Fn sass_import_get_function(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:23</i><br>
	 * @deprecated use the safer methods {@link #sass_import_get_function(sass.SassLibrary.Sass_C_Import_Callback)} and {@link #sass_import_get_function(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_C_Import_Fn sass_import_get_function(Pointer fn);
	/**
	 * Getters for import function descriptors<br>
	 * Original signature : <code>Sass_C_Import_Fn sass_import_get_function(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:23</i>
	 */
	SassLibrary.Sass_C_Import_Fn sass_import_get_function(SassLibrary.Sass_C_Import_Callback fn);
	/**
	 * Original signature : <code>void* sass_import_get_cookie(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:24</i><br>
	 * @deprecated use the safer methods {@link #sass_import_get_cookie(sass.SassLibrary.Sass_C_Import_Callback)} and {@link #sass_import_get_cookie(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	Pointer sass_import_get_cookie(Pointer fn);
	/**
	 * Original signature : <code>void* sass_import_get_cookie(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:24</i>
	 */
	Pointer sass_import_get_cookie(SassLibrary.Sass_C_Import_Callback fn);
	/**
	 * Deallocator for associated memory<br>
	 * Original signature : <code>void sass_delete_importer(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:27</i><br>
	 * @deprecated use the safer methods {@link #sass_delete_importer(sass.SassLibrary.Sass_C_Import_Callback)} and {@link #sass_delete_importer(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_delete_importer(Pointer fn);
	/**
	 * Deallocator for associated memory<br>
	 * Original signature : <code>void sass_delete_importer(Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:27</i>
	 */
	void sass_delete_importer(SassLibrary.Sass_C_Import_Callback fn);
	/**
	 * Creator for sass custom importer return argument list<br>
	 * Original signature : <code>Sass_Import** sass_make_import_list(size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:30</i>
	 */
	PointerByReference sass_make_import_list(NativeSize length);
	/**
	 * Creator for a single import entry returned by the custom importer inside the list<br>
	 * Original signature : <code>Sass_Import* sass_make_import_entry(const char*, char*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:32</i><br>
	 * @deprecated use the safer methods {@link #sass_make_import_entry(java.lang.String, java.nio.ByteBuffer, java.nio.ByteBuffer)} and {@link #sass_make_import_entry(com.sun.jna.Pointer, com.sun.jna.Pointer, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Import sass_make_import_entry(Pointer path, Pointer source, Pointer srcmap);
	/**
	 * Creator for a single import entry returned by the custom importer inside the list<br>
	 * Original signature : <code>Sass_Import* sass_make_import_entry(const char*, char*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:32</i>
	 */
	SassLibrary.Sass_Import sass_make_import_entry(String path, ByteBuffer source, ByteBuffer srcmap);
	/**
	 * Original signature : <code>Sass_Import* sass_make_import(const char*, const char*, char*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:33</i><br>
	 * @deprecated use the safer methods {@link #sass_make_import(java.lang.String, java.lang.String, java.nio.ByteBuffer, java.nio.ByteBuffer)} and {@link #sass_make_import(com.sun.jna.Pointer, com.sun.jna.Pointer, com.sun.jna.Pointer, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Import sass_make_import(Pointer path, Pointer base, Pointer source, Pointer srcmap);
	/**
	 * Original signature : <code>Sass_Import* sass_make_import(const char*, const char*, char*, char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:33</i>
	 */
	SassLibrary.Sass_Import sass_make_import(String path, String base, ByteBuffer source, ByteBuffer srcmap);
	/**
	 * Since we are dealing with pointers they should have a guaranteed and fixed size<br>
	 * Original signature : <code>void sass_import_set_list_entry(Sass_Import**, size_t, Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:37</i><br>
	 * @deprecated use the safer method {@link #sass_import_set_list_entry(sass.SassLibrary.Sass_Import[], com.ochafik.lang.jnaerator.runtime.NativeSize, sass.SassLibrary.Sass_Import)} instead
	 */
	@Deprecated 
	void sass_import_set_list_entry(PointerByReference list, NativeSize idx, SassLibrary.Sass_Import entry);
	/**
	 * Since we are dealing with pointers they should have a guaranteed and fixed size<br>
	 * Original signature : <code>void sass_import_set_list_entry(Sass_Import**, size_t, Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:37</i>
	 */
	void sass_import_set_list_entry(SassLibrary.Sass_Import list[], NativeSize idx, SassLibrary.Sass_Import entry);
	/**
	 * Original signature : <code>Sass_Import* sass_import_get_list_entry(Sass_Import**, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:38</i><br>
	 * @deprecated use the safer method {@link #sass_import_get_list_entry(sass.SassLibrary.Sass_Import[], com.ochafik.lang.jnaerator.runtime.NativeSize)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Import sass_import_get_list_entry(PointerByReference list, NativeSize idx);
	/**
	 * Original signature : <code>Sass_Import* sass_import_get_list_entry(Sass_Import**, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:38</i>
	 */
	SassLibrary.Sass_Import sass_import_get_list_entry(SassLibrary.Sass_Import list[], NativeSize idx);
	/**
	 * Getters for import entry<br>
	 * Original signature : <code>char* sass_import_get_path(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:41</i>
	 */
	String sass_import_get_path(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Original signature : <code>char* sass_import_get_base(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:42</i>
	 */
	String sass_import_get_base(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Original signature : <code>char* sass_import_get_source(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:43</i>
	 */
	String sass_import_get_source(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Original signature : <code>char* sass_import_get_srcmap(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:44</i>
	 */
	String sass_import_get_srcmap(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * The property on our struct will be reset to NULL<br>
	 * Original signature : <code>char* sass_import_take_source(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:47</i>
	 */
	Pointer sass_import_take_source(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Original signature : <code>char* sass_import_take_srcmap(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:48</i>
	 */
	Pointer sass_import_take_srcmap(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Deallocator for associated memory (incl. entries)<br>
	 * Original signature : <code>void sass_delete_import_list(Sass_Import**)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:51</i><br>
	 * @deprecated use the safer method {@link #sass_delete_import_list(sass.SassLibrary.Sass_Import[])} instead
	 */
	@Deprecated 
	void sass_delete_import_list(PointerByReference Sass_ImportPtrPtr1);
	/**
	 * Deallocator for associated memory (incl. entries)<br>
	 * Original signature : <code>void sass_delete_import_list(Sass_Import**)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:51</i>
	 */
	void sass_delete_import_list(SassLibrary.Sass_Import Sass_ImportPtrPtr1[]);
	/**
	 * Just in case we have some stray import structs<br>
	 * Original signature : <code>void sass_delete_import(Sass_Import*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:53</i>
	 */
	void sass_delete_import(SassLibrary.Sass_Import Sass_ImportPtr1);
	/**
	 * Creators for sass function list and function descriptors<br>
	 * Original signature : <code>Sass_C_Function_List sass_make_function_list(size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:67</i>
	 */
	SassLibrary.Sass_C_Function_List sass_make_function_list(NativeSize length);
	/**
	 * Original signature : <code>Sass_C_Function_Callback sass_make_function(const char*, Sass_C_Function, void*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:68</i><br>
	 * @deprecated use the safer methods {@link #sass_make_function(java.lang.String, sass.SassLibrary.Sass_C_Function, com.sun.jna.Pointer)} and {@link #sass_make_function(com.sun.jna.Pointer, sass.SassLibrary.Sass_C_Function, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_C_Function_Callback sass_make_function(Pointer signature, SassLibrary.Sass_C_Function fn, Pointer cookie);
	/**
	 * Original signature : <code>Sass_C_Function_Callback sass_make_function(const char*, Sass_C_Function, void*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:68</i>
	 */
	SassLibrary.Sass_C_Function_Callback sass_make_function(String signature, SassLibrary.Sass_C_Function fn, Pointer cookie);
	/**
	 * Setters and getters for callbacks on function lists<br>
	 * Original signature : <code>Sass_C_Function_Callback sass_function_get_list_entry(Sass_C_Function_List, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:71</i><br>
	 * @deprecated use the safer methods {@link #sass_function_get_list_entry(sass.SassLibrary.Sass_C_Function_List, com.ochafik.lang.jnaerator.runtime.NativeSize)} and {@link #sass_function_get_list_entry(com.sun.jna.Pointer, com.ochafik.lang.jnaerator.runtime.NativeSize)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_C_Function_Callback sass_function_get_list_entry(Pointer list, NativeSize pos);
	/**
	 * Setters and getters for callbacks on function lists<br>
	 * Original signature : <code>Sass_C_Function_Callback sass_function_get_list_entry(Sass_C_Function_List, size_t)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:71</i>
	 */
	SassLibrary.Sass_C_Function_Callback sass_function_get_list_entry(SassLibrary.Sass_C_Function_List list, NativeSize pos);
	/**
	 * Original signature : <code>void sass_function_set_list_entry(Sass_C_Function_List, size_t, Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:72</i><br>
	 * @deprecated use the safer methods {@link #sass_function_set_list_entry(sass.SassLibrary.Sass_C_Function_List, com.ochafik.lang.jnaerator.runtime.NativeSize, sass.SassLibrary.Sass_C_Function_Callback)} and {@link #sass_function_set_list_entry(com.sun.jna.Pointer, com.ochafik.lang.jnaerator.runtime.NativeSize, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_function_set_list_entry(Pointer list, NativeSize pos, Pointer cb);
	/**
	 * Original signature : <code>void sass_function_set_list_entry(Sass_C_Function_List, size_t, Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:72</i>
	 */
	void sass_function_set_list_entry(SassLibrary.Sass_C_Function_List list, NativeSize pos, SassLibrary.Sass_C_Function_Callback cb);
	/**
	 * Getters for custom function descriptors<br>
	 * Original signature : <code>char* sass_function_get_signature(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:75</i><br>
	 * @deprecated use the safer methods {@link #sass_function_get_signature(sass.SassLibrary.Sass_C_Function_Callback)} and {@link #sass_function_get_signature(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	String sass_function_get_signature(Pointer fn);
	/**
	 * Getters for custom function descriptors<br>
	 * Original signature : <code>char* sass_function_get_signature(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:75</i>
	 */
	String sass_function_get_signature(SassLibrary.Sass_C_Function_Callback fn);
	/**
	 * Original signature : <code>Sass_C_Function sass_function_get_function(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:76</i><br>
	 * @deprecated use the safer methods {@link #sass_function_get_function(sass.SassLibrary.Sass_C_Function_Callback)} and {@link #sass_function_get_function(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_C_Function sass_function_get_function(Pointer fn);
	/**
	 * Original signature : <code>Sass_C_Function sass_function_get_function(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:76</i>
	 */
	SassLibrary.Sass_C_Function sass_function_get_function(SassLibrary.Sass_C_Function_Callback fn);
	/**
	 * Original signature : <code>void* sass_function_get_cookie(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:77</i><br>
	 * @deprecated use the safer methods {@link #sass_function_get_cookie(sass.SassLibrary.Sass_C_Function_Callback)} and {@link #sass_function_get_cookie(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	Pointer sass_function_get_cookie(Pointer fn);
	/**
	 * Original signature : <code>void* sass_function_get_cookie(Sass_C_Function_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_functions.h:77</i>
	 */
	Pointer sass_function_get_cookie(SassLibrary.Sass_C_Function_Callback fn);
	/**
	 * Some convenient string helper function<br>
	 * Original signature : <code>char* sass_string_quote(const char*, const char)</code><br>
	 * <i>native declaration : src/main/libsass/sass.h:35</i><br>
	 * @deprecated use the safer methods {@link #sass_string_quote(java.lang.String, byte)} and {@link #sass_string_quote(com.sun.jna.Pointer, byte)} instead
	 */
	@Deprecated 
	Pointer sass_string_quote(Pointer str, byte quotemark);
	/**
	 * Some convenient string helper function<br>
	 * Original signature : <code>char* sass_string_quote(const char*, const char)</code><br>
	 * <i>native declaration : src/main/libsass/sass.h:35</i>
	 */
	Pointer sass_string_quote(String str, byte quotemark);
	/**
	 * Original signature : <code>char* sass_string_unquote(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass.h:36</i><br>
	 * @deprecated use the safer methods {@link #sass_string_unquote(java.lang.String)} and {@link #sass_string_unquote(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	Pointer sass_string_unquote(Pointer str);
	/**
	 * Original signature : <code>char* sass_string_unquote(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass.h:36</i>
	 */
	Pointer sass_string_unquote(String str);
	/**
	 * Get compiled libsass version<br>
	 * Original signature : <code>char* libsass_version()</code><br>
	 * <i>native declaration : src/main/libsass/sass.h:39</i>
	 */
	String libsass_version();
	/**
	 * Create and initialize an option struct<br>
	 * Original signature : <code>Sass_Options* sass_make_options()</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:22</i>
	 */
	SassLibrary.Sass_Options sass_make_options();
	/**
	 * Create and initialize a specific context<br>
	 * Original signature : <code>Sass_File_Context* sass_make_file_context(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:24</i><br>
	 * @deprecated use the safer methods {@link #sass_make_file_context(java.lang.String)} and {@link #sass_make_file_context(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_File_Context sass_make_file_context(Pointer input_path);
	/**
	 * Create and initialize a specific context<br>
	 * Original signature : <code>Sass_File_Context* sass_make_file_context(const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:24</i>
	 */
	SassLibrary.Sass_File_Context sass_make_file_context(String input_path);
	/**
	 * Original signature : <code>Sass_Data_Context* sass_make_data_context(char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:25</i><br>
	 * @deprecated use the safer methods {@link #sass_make_data_context(java.nio.ByteBuffer)} and {@link #sass_make_data_context(com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	SassLibrary.Sass_Data_Context sass_make_data_context(Pointer source_string);
	/**
	 * Original signature : <code>Sass_Data_Context* sass_make_data_context(char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:25</i>
	 */
	SassLibrary.Sass_Data_Context sass_make_data_context(ByteBuffer source_string);
	/**
	 * Call the compilation step for the specific context<br>
	 * Original signature : <code>int sass_compile_file_context(Sass_File_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:28</i>
	 */
	int sass_compile_file_context(SassLibrary.Sass_File_Context ctx);
	/**
	 * Original signature : <code>int sass_compile_data_context(Sass_Data_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:29</i>
	 */
	int sass_compile_data_context(SassLibrary.Sass_Data_Context ctx);
	/**
	 * Create a sass compiler instance for more control<br>
	 * Original signature : <code>Sass_Compiler* sass_make_file_compiler(Sass_File_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:32</i>
	 */
	SassLibrary.Sass_Compiler sass_make_file_compiler(SassLibrary.Sass_File_Context file_ctx);
	/**
	 * Original signature : <code>Sass_Compiler* sass_make_data_compiler(Sass_Data_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:33</i>
	 */
	SassLibrary.Sass_Compiler sass_make_data_compiler(SassLibrary.Sass_Data_Context data_ctx);
	/**
	 * Usefull if you only want to query the included files<br>
	 * Original signature : <code>int sass_compiler_parse(Sass_Compiler*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:37</i>
	 */
	int sass_compiler_parse(SassLibrary.Sass_Compiler compiler);
	/**
	 * Original signature : <code>int sass_compiler_execute(Sass_Compiler*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:38</i>
	 */
	int sass_compiler_execute(SassLibrary.Sass_Compiler compiler);
	/**
	 * This does _not_ include any contexts or options<br>
	 * Original signature : <code>void sass_delete_compiler(Sass_Compiler*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:42</i>
	 */
	void sass_delete_compiler(SassLibrary.Sass_Compiler compiler);
	/**
	 * Release all memory allocated and also ourself<br>
	 * Original signature : <code>void sass_delete_file_context(Sass_File_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:45</i>
	 */
	void sass_delete_file_context(SassLibrary.Sass_File_Context ctx);
	/**
	 * Original signature : <code>void sass_delete_data_context(Sass_Data_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:46</i>
	 */
	void sass_delete_data_context(SassLibrary.Sass_Data_Context ctx);
	/**
	 * Getters for context from specific implementation<br>
	 * Original signature : <code>Sass_Context* sass_file_context_get_context(Sass_File_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:49</i>
	 */
	SassLibrary.Sass_Context sass_file_context_get_context(SassLibrary.Sass_File_Context file_ctx);
	/**
	 * Original signature : <code>Sass_Context* sass_data_context_get_context(Sass_Data_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:50</i>
	 */
	SassLibrary.Sass_Context sass_data_context_get_context(SassLibrary.Sass_Data_Context data_ctx);
	/**
	 * Getters for context options from Sass_Context<br>
	 * Original signature : <code>Sass_Options* sass_context_get_options(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:53</i>
	 */
	SassLibrary.Sass_Options sass_context_get_options(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>Sass_Options* sass_file_context_get_options(Sass_File_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:54</i>
	 */
	SassLibrary.Sass_Options sass_file_context_get_options(SassLibrary.Sass_File_Context file_ctx);
	/**
	 * Original signature : <code>Sass_Options* sass_data_context_get_options(Sass_Data_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:55</i>
	 */
	SassLibrary.Sass_Options sass_data_context_get_options(SassLibrary.Sass_Data_Context data_ctx);
	/**
	 * Original signature : <code>void sass_file_context_set_options(Sass_File_Context*, Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:56</i>
	 */
	void sass_file_context_set_options(SassLibrary.Sass_File_Context file_ctx, SassLibrary.Sass_Options opt);
	/**
	 * Original signature : <code>void sass_data_context_set_options(Sass_Data_Context*, Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:57</i>
	 */
	void sass_data_context_set_options(SassLibrary.Sass_Data_Context data_ctx, SassLibrary.Sass_Options opt);
	/**
	 * Getters for options<br>
	 * Original signature : <code>int sass_option_get_precision(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:61</i>
	 */
	int sass_option_get_precision(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>Sass_Output_Style sass_option_get_output_style(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:62</i>
	 */
	int sass_option_get_output_style(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>bool sass_option_get_source_comments(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:63</i>
	 */
	byte sass_option_get_source_comments(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>bool sass_option_get_source_map_embed(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:64</i>
	 */
	byte sass_option_get_source_map_embed(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>bool sass_option_get_source_map_contents(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:65</i>
	 */
	byte sass_option_get_source_map_contents(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>bool sass_option_get_omit_source_map_url(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:66</i>
	 */
	byte sass_option_get_omit_source_map_url(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>bool sass_option_get_is_indented_syntax_src(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:67</i>
	 */
	byte sass_option_get_is_indented_syntax_src(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>char* sass_option_get_input_path(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:68</i>
	 */
	String sass_option_get_input_path(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>char* sass_option_get_output_path(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:69</i>
	 */
	String sass_option_get_output_path(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>char* sass_option_get_image_path(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:70</i>
	 */
	String sass_option_get_image_path(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>char* sass_option_get_include_path(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:71</i>
	 */
	String sass_option_get_include_path(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>char* sass_option_get_source_map_file(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:72</i>
	 */
	String sass_option_get_source_map_file(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>Sass_C_Function_List sass_option_get_c_functions(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:73</i>
	 */
	SassLibrary.Sass_C_Function_List sass_option_get_c_functions(SassLibrary.Sass_Options options);
	/**
	 * Original signature : <code>Sass_C_Import_Callback sass_option_get_importer(Sass_Options*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:74</i>
	 */
	SassLibrary.Sass_C_Import_Callback sass_option_get_importer(SassLibrary.Sass_Options options);
	/**
	 * Setters for options<br>
	 * Original signature : <code>void sass_option_set_precision(Sass_Options*, int)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:77</i>
	 */
	void sass_option_set_precision(SassLibrary.Sass_Options options, int precision);
	/**
	 * Original signature : <code>void sass_option_set_output_style(Sass_Options*, Sass_Output_Style)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:78</i>
	 */
	void sass_option_set_output_style(SassLibrary.Sass_Options options, int output_style);
	/**
	 * Original signature : <code>void sass_option_set_source_comments(Sass_Options*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:79</i>
	 */
	void sass_option_set_source_comments(SassLibrary.Sass_Options options, byte source_comments);
	/**
	 * Original signature : <code>void sass_option_set_source_map_embed(Sass_Options*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:80</i>
	 */
	void sass_option_set_source_map_embed(SassLibrary.Sass_Options options, byte source_map_embed);
	/**
	 * Original signature : <code>void sass_option_set_source_map_contents(Sass_Options*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:81</i>
	 */
	void sass_option_set_source_map_contents(SassLibrary.Sass_Options options, byte source_map_contents);
	/**
	 * Original signature : <code>void sass_option_set_omit_source_map_url(Sass_Options*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:82</i>
	 */
	void sass_option_set_omit_source_map_url(SassLibrary.Sass_Options options, byte omit_source_map_url);
	/**
	 * Original signature : <code>void sass_option_set_is_indented_syntax_src(Sass_Options*, bool)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:83</i>
	 */
	void sass_option_set_is_indented_syntax_src(SassLibrary.Sass_Options options, byte is_indented_syntax_src);
	/**
	 * Original signature : <code>void sass_option_set_input_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:84</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_input_path(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_set_input_path(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_input_path(SassLibrary.Sass_Options options, Pointer input_path);
	/**
	 * Original signature : <code>void sass_option_set_input_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:84</i>
	 */
	void sass_option_set_input_path(SassLibrary.Sass_Options options, String input_path);
	/**
	 * Original signature : <code>void sass_option_set_output_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:85</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_output_path(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_set_output_path(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_output_path(SassLibrary.Sass_Options options, Pointer output_path);
	/**
	 * Original signature : <code>void sass_option_set_output_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:85</i>
	 */
	void sass_option_set_output_path(SassLibrary.Sass_Options options, String output_path);
	/**
	 * Original signature : <code>void sass_option_set_image_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:86</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_image_path(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_set_image_path(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_image_path(SassLibrary.Sass_Options options, Pointer image_path);
	/**
	 * Original signature : <code>void sass_option_set_image_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:86</i>
	 */
	void sass_option_set_image_path(SassLibrary.Sass_Options options, String image_path);
	/**
	 * Original signature : <code>void sass_option_set_include_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:87</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_include_path(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_set_include_path(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_include_path(SassLibrary.Sass_Options options, Pointer include_path);
	/**
	 * Original signature : <code>void sass_option_set_include_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:87</i>
	 */
	void sass_option_set_include_path(SassLibrary.Sass_Options options, String include_path);
	/**
	 * Original signature : <code>void sass_option_set_source_map_file(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:88</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_source_map_file(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_set_source_map_file(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_source_map_file(SassLibrary.Sass_Options options, Pointer source_map_file);
	/**
	 * Original signature : <code>void sass_option_set_source_map_file(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:88</i>
	 */
	void sass_option_set_source_map_file(SassLibrary.Sass_Options options, String source_map_file);
	/**
	 * Original signature : <code>void sass_option_set_c_functions(Sass_Options*, Sass_C_Function_List)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:89</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_c_functions(sass.SassLibrary.Sass_Options, sass.SassLibrary.Sass_C_Function_List)} and {@link #sass_option_set_c_functions(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_c_functions(SassLibrary.Sass_Options options, Pointer c_functions);
	/**
	 * Original signature : <code>void sass_option_set_c_functions(Sass_Options*, Sass_C_Function_List)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:89</i>
	 */
	void sass_option_set_c_functions(SassLibrary.Sass_Options options, SassLibrary.Sass_C_Function_List c_functions);
	/**
	 * Original signature : <code>void sass_option_set_importer(Sass_Options*, Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:90</i><br>
	 * @deprecated use the safer methods {@link #sass_option_set_importer(sass.SassLibrary.Sass_Options, sass.SassLibrary.Sass_C_Import_Callback)} and {@link #sass_option_set_importer(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_set_importer(SassLibrary.Sass_Options options, Pointer importer);
	/**
	 * Original signature : <code>void sass_option_set_importer(Sass_Options*, Sass_C_Import_Callback)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:90</i>
	 */
	void sass_option_set_importer(SassLibrary.Sass_Options options, SassLibrary.Sass_C_Import_Callback importer);
	/**
	 * Getter for context<br>
	 * Original signature : <code>char* sass_context_get_output_string(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:94</i>
	 */
	String sass_context_get_output_string(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>int sass_context_get_error_status(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:95</i>
	 */
	int sass_context_get_error_status(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_get_error_json(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:96</i>
	 */
	String sass_context_get_error_json(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_get_error_message(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:97</i>
	 */
	String sass_context_get_error_message(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_get_error_file(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:98</i>
	 */
	String sass_context_get_error_file(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>size_t sass_context_get_error_line(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:99</i>
	 */
	NativeSize sass_context_get_error_line(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>size_t sass_context_get_error_column(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:100</i>
	 */
	NativeSize sass_context_get_error_column(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_get_source_map_string(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:101</i>
	 */
	String sass_context_get_source_map_string(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char** sass_context_get_included_files(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:102</i>
	 */
	PointerByReference sass_context_get_included_files(SassLibrary.Sass_Context ctx);
	/**
	 * Take ownership of memory (value on context is set to 0)<br>
	 * Original signature : <code>char* sass_context_take_error_json(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:105</i>
	 */
	Pointer sass_context_take_error_json(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_take_error_message(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:106</i>
	 */
	Pointer sass_context_take_error_message(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_take_error_file(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:107</i>
	 */
	Pointer sass_context_take_error_file(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_take_output_string(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:108</i>
	 */
	Pointer sass_context_take_output_string(SassLibrary.Sass_Context ctx);
	/**
	 * Original signature : <code>char* sass_context_take_source_map_string(Sass_Context*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:109</i>
	 */
	Pointer sass_context_take_source_map_string(SassLibrary.Sass_Context ctx);
	/**
	 * Push function for include paths (no manipulation support for now)<br>
	 * Original signature : <code>void sass_option_push_include_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:112</i><br>
	 * @deprecated use the safer methods {@link #sass_option_push_include_path(sass.SassLibrary.Sass_Options, java.lang.String)} and {@link #sass_option_push_include_path(sass.SassLibrary.Sass_Options, com.sun.jna.Pointer)} instead
	 */
	@Deprecated 
	void sass_option_push_include_path(SassLibrary.Sass_Options options, Pointer path);
	/**
	 * Push function for include paths (no manipulation support for now)<br>
	 * Original signature : <code>void sass_option_push_include_path(Sass_Options*, const char*)</code><br>
	 * <i>native declaration : src/main/libsass/sass_context.h:112</i>
	 */
	void sass_option_push_include_path(SassLibrary.Sass_Options options, String path);
	public static class Sass_Import extends PointerType {
		public Sass_Import(Pointer address) {
			super(address);
		}
		public Sass_Import() {
			super();
		}
	};
	public static class Sass_Context extends PointerType {
		public Sass_Context(Pointer address) {
			super(address);
		}
		public Sass_Context() {
			super();
		}
	};
	public static class Sass_Value extends PointerType {
		public Sass_Value(Pointer address) {
			super(address);
		}
		public Sass_Value() {
			super();
		}
	};
	public static class Sass_Options extends PointerType {
		public Sass_Options(Pointer address) {
			super(address);
		}
		public Sass_Options() {
			super();
		}
	};
	public static class Sass_C_Function_List extends PointerType {
		public Sass_C_Function_List(Pointer address) {
			super(address);
		}
		public Sass_C_Function_List() {
			super();
		}
	};
	public static class Sass_C_Function_Callback extends PointerType {
		public Sass_C_Function_Callback(Pointer address) {
			super(address);
		}
		public Sass_C_Function_Callback() {
			super();
		}
	};
	public static class Sass_File_Context extends PointerType {
		public Sass_File_Context(Pointer address) {
			super(address);
		}
		public Sass_File_Context() {
			super();
		}
	};
	public static class Sass_Compiler extends PointerType {
		public Sass_Compiler(Pointer address) {
			super(address);
		}
		public Sass_Compiler() {
			super();
		}
	};
	public static class Sass_C_Import_Callback extends PointerType {
		public Sass_C_Import_Callback(Pointer address) {
			super(address);
		}
		public Sass_C_Import_Callback() {
			super();
		}
	};
	public static class Sass_Data_Context extends PointerType {
		public Sass_Data_Context(Pointer address) {
			super(address);
		}
		public Sass_Data_Context() {
			super();
		}
	};
}
