/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event.transformation.impl;

import io.axoniq.axonserver.connector.event.transformation.ActiveTransformation;
import io.axoniq.axonserver.connector.event.transformation.EventTransformation;
import io.axoniq.axonserver.connector.event.transformation.EventTransformationChannel;
import io.axoniq.axonserver.connector.event.transformation.impl.DefaultActiveTransformation;
import io.axoniq.axonserver.connector.event.transformation.impl.EventTransformationService;
import io.axoniq.axonserver.connector.event.transformation.impl.grpc.GrpcEventTransformationService;
import io.axoniq.axonserver.connector.impl.AbstractAxonServerChannel;
import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.StreamSupport;

public class EventTransformationChannelImpl
extends AbstractAxonServerChannel<Void>
implements EventTransformationChannel {
    private static final Long INITIAL_SEQUENCE = -1L;
    private final EventTransformationService service;

    public EventTransformationChannelImpl(ClientIdentification clientIdentification, ScheduledExecutorService executor, AxonServerManagedChannel axonServerManagedChannel) {
        this(clientIdentification, executor, axonServerManagedChannel, new GrpcEventTransformationService(axonServerManagedChannel));
    }

    EventTransformationChannelImpl(ClientIdentification clientIdentification, ScheduledExecutorService executor, AxonServerManagedChannel axonServerManagedChannel, EventTransformationService service) {
        super(clientIdentification, executor, axonServerManagedChannel);
        this.service = service;
    }

    @Override
    public CompletableFuture<Iterable<EventTransformation>> transformations() {
        return this.service.transformations();
    }

    @Override
    public CompletableFuture<ActiveTransformation> activeTransformation() {
        return this.service.transformations().thenApply(iterable -> StreamSupport.stream(iterable.spliterator(), false).filter(t -> EventTransformation.State.ACTIVE.equals((Object)t.state())).findFirst().map(this::activeTransformation).orElseThrow(IllegalStateException::new));
    }

    private ActiveTransformation activeTransformation(EventTransformation eventTransformation) {
        return this.newActiveTransformation(eventTransformation.id(), eventTransformation.lastSequence());
    }

    @Override
    public CompletableFuture<ActiveTransformation> newTransformation(String description) {
        return this.service.newTransformation(description).thenApply(id -> this.newActiveTransformation((String)id, INITIAL_SEQUENCE));
    }

    private ActiveTransformation newActiveTransformation(String id, long currentSequence) {
        return new DefaultActiveTransformation(id, currentSequence, this.service);
    }

    @Override
    public CompletableFuture<Void> startCompacting() {
        return this.service.startCompacting();
    }

    @Override
    public void connect() {
    }

    @Override
    public void reconnect() {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

