/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event;

import io.axoniq.axonserver.connector.ResultStream;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.event.dcb.AddTagsResponse;
import io.axoniq.axonserver.grpc.event.dcb.AppendEventsResponse;
import io.axoniq.axonserver.grpc.event.dcb.ConsistencyCondition;
import io.axoniq.axonserver.grpc.event.dcb.Event;
import io.axoniq.axonserver.grpc.event.dcb.GetHeadResponse;
import io.axoniq.axonserver.grpc.event.dcb.GetSequenceAtResponse;
import io.axoniq.axonserver.grpc.event.dcb.GetTagsResponse;
import io.axoniq.axonserver.grpc.event.dcb.GetTailResponse;
import io.axoniq.axonserver.grpc.event.dcb.RemoveTagsResponse;
import io.axoniq.axonserver.grpc.event.dcb.SourceEventsRequest;
import io.axoniq.axonserver.grpc.event.dcb.SourceEventsResponse;
import io.axoniq.axonserver.grpc.event.dcb.StreamEventsRequest;
import io.axoniq.axonserver.grpc.event.dcb.StreamEventsResponse;
import io.axoniq.axonserver.grpc.event.dcb.Tag;
import io.axoniq.axonserver.grpc.event.dcb.TaggedEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public interface DcbEventChannel {
    public AppendEventsTransaction startTransaction();

    public AppendEventsTransaction startTransaction(ConsistencyCondition var1);

    default public CompletableFuture<AppendEventsResponse> append(Collection<TaggedEvent> taggedEvents) {
        if (taggedEvents == null || taggedEvents.isEmpty()) {
            return DcbEventChannel.noEmptyEvents();
        }
        return this.startTransaction().appendAll(taggedEvents).commit();
    }

    default public CompletableFuture<AppendEventsResponse> append(Collection<TaggedEvent> taggedEvents, ConsistencyCondition condition) {
        if (taggedEvents == null || taggedEvents.isEmpty()) {
            return DcbEventChannel.noEmptyEvents();
        }
        return this.startTransaction(condition).appendAll(taggedEvents).commit();
    }

    default public CompletableFuture<AppendEventsResponse> append(ConsistencyCondition condition, TaggedEvent ... taggedEvents) {
        return this.append(Arrays.asList(taggedEvents), condition);
    }

    default public CompletableFuture<AppendEventsResponse> append(TaggedEvent ... taggedEvents) {
        return this.append(Arrays.asList(taggedEvents));
    }

    private static CompletableFuture<AppendEventsResponse> noEmptyEvents() {
        return CompletableFuture.failedFuture(new IllegalArgumentException("taggedEvents must not be null or empty"));
    }

    default public ResultStream<StreamEventsResponse> stream(StreamEventsRequest request) {
        return this.stream(request, 64);
    }

    default public ResultStream<StreamEventsResponse> stream(StreamEventsRequest request, int bufferSize) {
        return this.stream(request, bufferSize, Math.max(bufferSize >> 3, 16));
    }

    public ResultStream<StreamEventsResponse> stream(StreamEventsRequest var1, int var2, int var3);

    public ResultStream<SourceEventsResponse> source(SourceEventsRequest var1);

    public CompletableFuture<GetTagsResponse> tagsFor(long var1);

    public CompletableFuture<AddTagsResponse> addTags(long var1, Collection<Tag> var3);

    public CompletableFuture<RemoveTagsResponse> removeTags(long var1, Collection<Tag> var3);

    public CompletableFuture<GetHeadResponse> head();

    public CompletableFuture<GetTailResponse> tail();

    public CompletableFuture<GetSequenceAtResponse> getSequenceAt(Instant var1);

    default public CompletableFuture<String> scheduleEvent(Duration triggerDuration, Event event) {
        return this.scheduleEvent(Instant.now().plus(triggerDuration), event);
    }

    public CompletableFuture<String> scheduleEvent(Instant var1, Event var2);

    public CompletableFuture<InstructionAck> cancelSchedule(String var1);

    default public CompletableFuture<String> reschedule(String scheduleToken, Duration triggerDuration, Event event) {
        return this.reschedule(scheduleToken, Instant.now().plus(triggerDuration), event);
    }

    public CompletableFuture<String> reschedule(String var1, Instant var2, @Nullable Event var3);

    public static interface AppendEventsTransaction {
        public AppendEventsTransaction append(TaggedEvent var1);

        default public AppendEventsTransaction appendAll(Collection<TaggedEvent> taggedEvents) {
            taggedEvents.forEach(this::append);
            return this;
        }

        public CompletableFuture<AppendEventsResponse> commit();

        public void rollback();
    }
}

